package jp.co.sra.jun.goodies.sound;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StSymbol;

import jp.co.sra.jun.system.framework.JunAbstractViewCanvas;

/**
 * JunSoundLevelMeterViewAwt class
 * 
 *  @author    Hoshi Takanori
 *  @created   2003/08/29 (by Hoshi Takanori)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun519 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSoundLevelMeterViewAwt.java,v 8.10 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunSoundLevelMeterViewAwt extends JunAbstractViewCanvas implements JunSoundLevelMeterView {

	/**
	 * Create a new instance of JunSoundLevelMeterViewAwt and initialize it.
	 *
	 * @param aSoundMeterModel jp.co.sra.jun.goodies.sound.JunSoundMeterModel
	 */
	public JunSoundLevelMeterViewAwt(JunSoundMeterModel aSoundMeterModel) {
		super(aSoundMeterModel);
	}

	/**
	 * Display on a graphics context.
	 * 
	 * @param graphicsContext java.awt.Graphics
	 */
	public void displayOn_(Graphics graphicsContext) {
		if (this.isShowing() == false) {
			return;
		}

		Dimension size = this.getSize();
		graphicsContext.setColor(Color.white);
		graphicsContext.fillRect(0, 0, size.width, size.height);
		graphicsContext.setColor(Color.gray);
		graphicsContext.drawLine(size.width / 2, 0, size.width / 2, size.height);
	}

	/**
	 * Display the level value on the graphics context.
	 *
	 * @param graphicsContext java.awt.Graphics
	 * @param levelValue double[]
	 */
	public void displayOn_levelValue_(Graphics graphicsContext, double[] levelValue) {
		Dimension size = this.getSize();
		int left = (int) Math.round(levelValue[0] * size.width);
		int right = (int) Math.round(levelValue[1] * size.width);
		graphicsContext.setColor(Color.white);
		graphicsContext.fillRect(0, 0, left, size.height);
		graphicsContext.fillRect(right, 0, size.width - right, size.height);
		float darkness = 0.75f - (float) (levelValue[1] - levelValue[0]) * 0.5f;
		graphicsContext.setColor(new Color(darkness, darkness, darkness));
		graphicsContext.fillRect(left, 0, right - left, size.height);
		graphicsContext.setColor(Color.gray);
		graphicsContext.drawLine(size.width / 2, 0, size.width / 2, size.height);
	}

	/**
	 * Action for the update notification.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (this.isShowing() == false) {
			return;
		}

		StSymbol aSymbol = evt.getAspect();
		if (aSymbol == $("level")) {
			Object parameter = evt.getParameter();
			if (parameter instanceof double[]) {
				Graphics graphics = this.getGraphics();
				if (graphics != null) {
					this.displayOn_levelValue_(graphics, (double[]) parameter);
				}
			}
		} else if (aSymbol == $("wave")) {
			return;
		} else {
			super.update_(evt);
		}
	}

}
