package jp.co.sra.jun.goodies.soroban;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

import jp.co.sra.jun.system.framework.JunAbstractController;

/**
 * JunSorobanController class
 * 
 *  @author    m-asada
 *  @created   2006/03/13 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun563 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSorobanController.java,v 8.10 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunSorobanController extends JunAbstractController {
	/**
	 * Create a new instance of <code>JunSorobanController</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunSorobanController() {
		super();
	}

	/**
	 * Invoked when a mouse button has been pressed on the view.
	 * 
	 * @param evt java.awt.event.MouseEvent
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mousePressed(MouseEvent evt) {
		if (evt.isPopupTrigger() || evt.isMetaDown()) {
			super.mousePressed(evt);
			return;
		}

		Point point = new Point(evt.getPoint().x - this.getView().marginRectangle().originX(), evt.getPoint().y - this.getView().marginRectangle().originY());
		if (new Rectangle(0, 0, this.getModel().reeds() * this.getView().reedWidth(), this.getView().reedHeight()).contains(point) == false) {
			this.view()._showPopupMenu(evt.getX(), evt.getY());
			return;
		}

		int x = (point.x / this.getView().reedWidth());
		int y = 0;
		int index = -1;
		char aChar = '0';
		String patternString = this.getModel().patternAt_(x);
		char[] pattern = patternString.toCharArray();
		while (point.y > y) {
			index++;
			aChar = pattern[index];
			int height = (aChar == '+') ? this.getView().komaHeight() : this.getView().kushiHeight();
			y += height;
		}
		if (aChar != '+') {
			return;
		}

		if (index < 3) {
			char tmp = pattern[0];
			pattern[0] = pattern[1];
			pattern[1] = tmp;
		} else {
			y = patternString.lastIndexOf('-');
			pattern[index] = '-';
			pattern[y] = '+';
			if (evt.isShiftDown()) {
				char tmp = pattern[0];
				pattern[0] = pattern[1];
				pattern[1] = tmp;
			}
		}
		this.getModel().at_pattern_(x, new String(pattern));
	}

	/**
	 * Answer the receiver's model as JunSorobanModel
	 * 
	 * @return jp.co.sra.jun.goodies.soroban.JunSorobanModel
	 * @category model accessing
	 */
	public JunSorobanModel getModel() {
		return (JunSorobanModel) this.getView().getModel();
	}

	/**
	 * Answer the receiver's view as JunSorobanView
	 * 
	 * @return jp.co.sra.jun.goodies.soroban.JunSorobanView
	 * @category view accessing
	 */
	public JunSorobanView getView() {
		return (JunSorobanView) this.view();
	}
}
