package jp.co.sra.jun.goodies.prolog;

import java.io.*;
import jp.co.sra.smalltalk.*;

/**
 * JunPrologString class
 * 
 *  @author    kondo
 *  @created   1999/09/09 (by kondo)
 *  @updated   2003/04/28 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun301 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologString.java,v 8.10 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunPrologString extends JunPrologEntity {

	protected String string;

	/**
	 * Create a new instance of JunPrologString and initialize it.
	 *
	 * @param aString java.lang.String
	 */
	public JunPrologString(String aString) {
		this.string_(aString);
	}

	/**
	 * Read a JunPrologString from the stream.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 * @param aStream jp.co.sra.smalltalk.StReadStream
	 */
	public static JunPrologEntity ReadFrom_(StReadStream aStream) {
		StringBuffer buffer = new StringBuffer(20);
		char ch = aStream.next();
		if (ch == '"') {
			while ((ch = aStream.peek()) != 0) {
				if (ch == '"') {
					aStream.next();
					ch = aStream.peek();
					if (ch != '"') {
						return new JunPrologString(buffer.toString());
					}
				}
				buffer.append(aStream.next());
			}
		}

		String string = aStream.upToEnd();
		if (string.length() > 100) {
			string = string.substring(0, 99);
		}
		throw SmalltalkException.Error("Syntax error near $\" unmatched $\"\n" + (string.length() == 0 ? "-- end of file --" : "--> " + string));
	}

	/**
	 * Convert the receiver to a string.
	 *
	 * @return java.lang.String
	 */
	public String asString() {
		return this.string();
	}

	/**
	 * Answer true if the receiver is equals to the object, otherwise false.
	 *
	 * @return boolean
	 * @param anObject java.lang.Object
	 */
	public boolean equals(Object anObject) {
		if (anObject.getClass() != this.getClass()) {
			return false;
		}
		return this.string().equals(((JunPrologString) anObject).string());
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws IOException if failed.
	 */
	public void printJunPrologOn_(Writer aWriter) throws IOException {
		aWriter.write('"');
		int length = string.length();
		for (int i = 0; i < length; i++) {
			char x = string.charAt(i);
			aWriter.write(x);
			if (x == '"') {
				aWriter.write(x);
			}
		}
		aWriter.write('"');
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @param anInteger int
	 * @throws IOException if failed.
	 */
	public void printJunPrologOn_level_(Writer aWriter, int anInteger) throws IOException {
		this.printJunPrologOn_(aWriter);
	}

	/**
	 * Print my string representation on aWriter.
	 * 
	 * @param aWriter java.io.Writer
	 * 
	 * @throws IOException if failed.
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write(this._className().toString());
		aWriter.write("(");
		aWriter.write(this.string());
		aWriter.write(")");
	}

	/**
	 * Answre my current string.
	 *
	 * @return java.lang.String
	 */
	public String string() {
		return string;
	}

	/**
	 * Set my new string.
	 *
	 * @param newString java.lang.String
	 */
	public void string_(String newString) {
		string = newString;
	}
}
