package jp.co.sra.jun.goodies.prolog;

import java.io.*;
import jp.co.sra.smalltalk.*;

/**
 * JunPrologObject class
 * 
 *  @author    kondo
 *  @created   1999/09/09 (by kondo)
 *  @updated   2003/04/30 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun301 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologObject.java,v 8.11 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunPrologObject extends JunPrologEntity {

	protected String source;
	protected Object object;

	/**
	 * Create a new instance of <code>JunPrologObject</code> and initialize it.
	 *
	 * @param anObject java.lang.Object
	 * @category Instance creation
	 */
	public JunPrologObject(Object anObject) {
		this(null, anObject);
	}

	/**
	 * Create a new instance of <code>JunPrologObject</code> and initialize it.
	 *
	 * @param aString java.lang.String
	 * @param anObject java.lang.Object
	 * @category Instance creation
	 */
	public JunPrologObject(String aString, Object anObject) {
		this.source_object_(aString, anObject);
	}

	/**
	 * Read a string representation of JunPrologObject from the stream.
	 *
	 * @return java.lang.String
	 * @param aStream jp.co.sra.smalltalk.StReadStream
	 * @category Instance creation
	 */
	public static String ReadFrom_(StReadStream aStream) {
		StringBuffer buffer = new StringBuffer(20);
		char ch;
		while ((ch = aStream.next()) != '}') {
			if (ch == 0) {
				throw SmalltalkException.Error("Syntax error near ${ unmatched $}\n" + "-- end of file --");
			}
			buffer.append(ch);
		}
		return buffer.toString();
	}

	/**
	 * Answer true if the receiver is equals to the object, otherwise false.
	 *
	 * @return boolean
	 * @param anObject java.lang.Object
	 * @see java.lang.Object#equals(java.lang.Object)
	 * @category comparing
	 */
	public boolean equals(Object anObject) {
		if (anObject.getClass() != this.getClass()) {
			return false;
		}
		return this.object().equals(((JunPrologObject) anObject).object());
	}

	/**
	 * Answer my current object.
	 *
	 * @return java.lang.Object
	 * @category accessing
	 */
	public Object object() {
		return object;
	}

	/**
	 * Set my new object.
	 *
	 * @param newObject java.lang.Object
	 * @category accessing
	 */
	public void object_(Object newObject) {
		object = newObject;
	}

	/**
	 * Print my string representation on the writer.
	 *
	 * @param aWriter java.io.Writer
	 * @exception java.io.IOException if failed.
	 * @see jp.co.sra.jun.goodies.prolog.JunPrologEntity#printJunPrologOn_(java.io.Writer)
	 * @category printing
	 */
	public void printJunPrologOn_(Writer aWriter) throws IOException {
		if (source == null) {
			aWriter.write("[]");
		} else {
			aWriter.write('{');
			aWriter.write(source);
			aWriter.write('}');
		}
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @param anInteger int
	 * @throws IOException if failed.
	 * @see jp.co.sra.jun.goodies.prolog.JunPrologEntity#printJunPrologOn_level_(java.io.Writer, int)
	 * @category printing
	 */
	public void printJunPrologOn_level_(Writer aWriter, int anInteger) throws IOException {
		this.printJunPrologOn_(aWriter);
	}

	/**
	 * Print my string representation on aWriter.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws IOException if failed.
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write(this.object().toString());
	}

	/**
	 * Answer my current source string.
	 *
	 * @return java.lang.String
	 * @category accessing
	 */
	public String source() {
		return source;
	}

	/**
	 * Set my new source string.
	 *
	 * @param newSource java.lang.String
	 * @category accessing
	 */
	public void source_(String newSource) {
		source = newSource;
	}

	/**
	 * Initialize the variables.
	 *
	 * @param aString java.lang.String
	 * @param anObject java.lang.Object
	 * @category private
	 */
	protected void source_object_(String aString, Object anObject) {
		this.source_(aString);
		this.object_(anObject);
	}
}
