package jp.co.sra.jun.goodies.prolog;

/**
 * JunPrologDefinition class
 * 
 *  @author    kondo
 *  @created   1999/09/09 (by kondo)
 *  @updated   2003/05/01 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun301 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologDefinition.java,v 8.10 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunPrologDefinition extends JunPrologList {

	/**
	 * Create a new instance of JunPrologDefinition and initialize it.
	 *
	 * @param aJunPrologClause jp.co.sra.jun.goodies.prolog.JunPrologClause
	 * @param link jp.co.sra.jun.goodies.prolog.JunPrologDefinition
	 */
	public JunPrologDefinition(JunPrologClause aJunPrologClause, JunPrologDefinition link) {
		this.clause_next_(aJunPrologClause, link);
	}

	/**
	 * Create a new instance of JunPrologDefinition from the list.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologBody
	 * @param aJunPrologDotPair jp.co.sra.jun.goodies.prolog.JunPrologList
	 */
	public static JunPrologDefinition FromList_(JunPrologList aJunPrologDotPair) {
		return FromReverseList_(aJunPrologDotPair.reverse());
	}

	/**
	 * Create a new instance of JunPrologDefinition from the reverse list.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologDefinition
	 * @param aJunPrologDotPair jp.co.sra.jun.goodies.prolog.JunPrologList
	 */
	public static JunPrologDefinition FromReverseList_(JunPrologList aJunPrologDotPair) {
		JunPrologEntity list = aJunPrologDotPair;
		JunPrologDefinition definition = null;
		while (list != null && list.consp()) {
			definition = new JunPrologDefinition((JunPrologClause) list.car(), definition);
			list = list.cdr();
		}
		return definition;
	}

	/**
	 * Create a new instance with the specified arguments.
	 * This method have to be overrided to create a subclass specified instance.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologList
	 * @param carEntity jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 * @param cdrEntity jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 */
	protected JunPrologList _newInstanceWith(JunPrologEntity carEntity, JunPrologEntity cdrEntity) {
		throw new jp.co.sra.smalltalk.SmalltalkException("Do you really need this?");
	}

	/**
	 * Initialize the variables.
	 *
	 * @param aJunPrologClause jp.co.sra.jun.goodies.prolog.JunPrologClause
	 * @param link jp.co.sra.jun.goodies.prolog.JunPrologDefinition
	 */
	protected void clause_next_(JunPrologClause aJunPrologClause, JunPrologDefinition link) {
		carPart = aJunPrologClause;
		cdrPart = link;
	}
}
