package jp.co.sra.jun.goodies.prolog;

import java.io.*;

/**
 * JunPrologBoolean class
 * 
 *  @author    kondo
 *  @created   1999/09/21 (by kondo)
 *  @updated   2003/04/30 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun301 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologBoolean.java,v 8.10 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunPrologBoolean extends JunPrologObject {

	public static final JunPrologBoolean TRUE = new JunPrologBoolean(Boolean.TRUE);
	public static final JunPrologBoolean FALSE = new JunPrologBoolean(Boolean.FALSE);

	/**
	 * Create a new instance of JunPrologBoolean and initialize it.
	 *
	 * @param aBoolean java.lang.Boolean
	 */
	public JunPrologBoolean(Boolean aBoolean) {
		super(aBoolean);
	}

	/**
	 * Print my string representation on the writer.
	 *
	 * @param aWriter java.io.Writer
	 * @exception java.io.IOException if failed.
	 */
	public void printJunPrologOn_(Writer aWriter) throws IOException {
		aWriter.write('{');
		aWriter.write(this.object().toString());
		aWriter.write('}');
	}
}
