package jp.co.sra.jun.goodies.pen;

/**
 * JunPenTransformation class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1999/1/5 (by Hirotsugu Kondo)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPenTransformation.java,v 8.10 2008/02/20 06:32:01 nisinaka Exp $
 */
public class JunPenTransformation extends JunPenGeometry {
	private double a;
	private double b;
	private double c;
	private double p;
	private double d;
	private double e;
	private double f;
	private double q;
	private double g;
	private double h;
	private double i;
	private double r;
	private double l;
	private double m;
	private double n;
	private double s;

	/**
	 * DOCUMENT ME!
	 * 
	 * @param alignmentLocation DOCUMENT ME!
	 * @param relativeLocation DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenTransformation Align_with_(Object alignmentLocation, Object relativeLocation) {
		JunPenLocation alignment = JunPenLocation.Coerce_(alignmentLocation);
		JunPenLocation relative = JunPenLocation.Coerce_(relativeLocation);

		return Translate_(relative.minus_(alignment));
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anAngle DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenTransformation Cabinet_(Object anAngle) {
		JunPenAngle thePoint = JunPenAngle.Coerce_(anAngle);
		JunPenTransformation aTransformation = Unity();
		aTransformation.setG_(thePoint.cos() / 2);
		aTransformation.setH_(thePoint.sin() / 2);

		return aTransformation;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anAngle DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenTransformation Cavalie_(Object anAngle) {
		JunPenAngle thePoint = JunPenAngle.Coerce_(anAngle);
		JunPenTransformation aTransformation = Unity();
		aTransformation.setG_(thePoint.cos());
		aTransformation.setH_(thePoint.sin());

		return aTransformation;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anArray DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenTransformation FromArray_(double[] anArray) {
		int length = anArray.length;

		if (length < 16) {
			return null;
		}

		JunPenTransformation transformation = new JunPenTransformation();
		transformation.setA_(anArray[0]);
		transformation.setB_(anArray[1]);
		transformation.setC_(anArray[2]);
		transformation.setP_(anArray[3]);
		transformation.setD_(anArray[4]);
		transformation.setE_(anArray[5]);
		transformation.setF_(anArray[6]);
		transformation.setQ_(anArray[7]);
		transformation.setG_(anArray[8]);
		transformation.setH_(anArray[9]);
		transformation.setI_(anArray[10]);
		transformation.setR_(anArray[11]);
		transformation.setL_(anArray[12]);
		transformation.setM_(anArray[13]);
		transformation.setN_(anArray[14]);
		transformation.setS_(anArray[15]);

		return transformation;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aPoint DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenTransformation Parallel_(Object aPoint) {
		JunPenLocation thePoint = JunPenLocation.Coerce_(aPoint);
		JunPenTransformation aTransformation = Unity();
		aTransformation.setG_(thePoint.x() / thePoint.z() * -1);
		aTransformation.setH_(thePoint.y() / thePoint.z() * -1);

		return aTransformation;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aPoint DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenTransformation Perspective_(Object aPoint) {
		JunPenLocation thePoint = JunPenLocation.Coerce_(aPoint);
		JunPenTransformation aTransformation = Unity();
		aTransformation.setA_(thePoint.z() * -1);
		aTransformation.setE_(thePoint.z() * -1);
		aTransformation.setG_(thePoint.x());
		aTransformation.setH_(thePoint.y());
		aTransformation.setI_(-1);
		aTransformation.setR_(1);
		aTransformation.setS_(thePoint.z() * -1);

		return aTransformation;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anAngle DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenTransformation Rotate_(Object anAngle) {
		return RotateZ_(anAngle);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anAngle DOCUMENT ME!
	 * @param aLine DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenTransformation Rotate_around_(Object anAngle, Object aLine) {
		JunPenAngle theAngle = JunPenAngle.Coerce_(anAngle);
		JunPenLocation[] line = (JunPenLocation[]) aLine;
		JunPenLocation firstPoint = line[0];
		JunPenLocation lastPoint = line[1];
		JunPenLocation aVector = lastPoint.minus_(firstPoint);
		double aV = Math.sqrt(Math.pow(aVector.y(), 2) + Math.pow(aVector.z(), 2));
		double aL = Math.sqrt(Math.pow(aVector.x(), 2) + Math.pow(aVector.y(), 2) + Math.pow(aVector.z(), 2));
		JunPenTransformation aT = Translate_(firstPoint.negated());
		JunPenTransformation aRx = Unity();

		if (aV != 0.0d) {
			aRx.setE_(aVector.z() / aV);
			aRx.setF_(aVector.y() / aV);
			aRx.setH_(aVector.y() / aV * -1);
			aRx.setI_(aVector.z() / aV);
		}

		JunPenTransformation aRy = Unity();

		if (aL != 0.0d) {
			aRy.setA_(aV / aL);
			aRy.setC_(aVector.x() / aL);
			aRy.setG_(aVector.x() / aL * -1);
			aRy.setI_(aV / aL);
		}

		JunPenTransformation aRz = Rotate_(theAngle);
		JunPenTransformation rRy = Unity();

		if (aL != 0.0d) {
			rRy.setA_(aV / aL);
			rRy.setC_(aVector.x() / aL * -1);
			rRy.setG_(aVector.x() / aL);
			rRy.setI_(aV / aL);
		}

		JunPenTransformation rRx = Unity();

		if (aV != 0.0d) {
			rRx.setE_(aVector.z() / aV);
			rRx.setF_(aVector.y() / aV * -1);
			rRx.setH_(aVector.y() / aV);
			rRx.setI_(aVector.z() / aV);
		}

		JunPenTransformation rT = Translate_(firstPoint);
		JunPenTransformation aTransformation = aT.product_(aRx);
		aTransformation = aTransformation.product_(aRy);
		aTransformation = aTransformation.product_(aRz);
		aTransformation = aTransformation.product_(rRy);
		aTransformation = aTransformation.product_(rRx);
		aTransformation = aTransformation.product_(rT);

		return aTransformation;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anAngle DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenTransformation RotateX_(Object anAngle) {
		JunPenAngle thePoint = JunPenAngle.Coerce_(anAngle);
		JunPenTransformation aTransformation = Unity();
		aTransformation.setE_(thePoint.cos());
		aTransformation.setF_(thePoint.sin());
		aTransformation.setH_(thePoint.sin() * -1);
		aTransformation.setI_(thePoint.cos());

		return aTransformation;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anAngle DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenTransformation RotateY_(Object anAngle) {
		JunPenAngle thePoint = JunPenAngle.Coerce_(anAngle);
		JunPenTransformation aTransformation = Unity();
		aTransformation.setA_(thePoint.cos());
		aTransformation.setC_(thePoint.sin() * -1);
		aTransformation.setG_(thePoint.sin());
		aTransformation.setI_(thePoint.cos());

		return aTransformation;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anAngle DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenTransformation RotateZ_(Object anAngle) {
		JunPenAngle thePoint = JunPenAngle.Coerce_(anAngle);
		JunPenTransformation aTransformation = Unity();
		aTransformation.setA_(thePoint.cos());
		aTransformation.setB_(thePoint.sin());
		aTransformation.setD_(thePoint.sin() * -1);
		aTransformation.setE_(thePoint.cos());

		return aTransformation;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aPoint DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenTransformation Scale_(Object aPoint) {
		JunPenLocation thePoint = JunPenLocation.Coerce_(aPoint);
		JunPenTransformation aTransformation = Unity();
		aTransformation.setA_(thePoint.x());
		aTransformation.setE_(thePoint.y());
		aTransformation.setI_(thePoint.z());

		return aTransformation;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aPoint DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenTransformation Translate_(Object aPoint) {
		JunPenLocation thePoint = JunPenLocation.Coerce_(aPoint);
		JunPenTransformation aTransformation = Unity();
		aTransformation.setL_(thePoint.x());
		aTransformation.setM_(thePoint.y());
		aTransformation.setN_(thePoint.z());

		return aTransformation;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenTransformation Unity() {
		JunPenTransformation transformation = new JunPenTransformation();
		transformation.setA_(1);
		transformation.setB_(0);
		transformation.setC_(0);
		transformation.setP_(0);
		transformation.setD_(0);
		transformation.setE_(1);
		transformation.setF_(0);
		transformation.setQ_(0);
		transformation.setG_(0);
		transformation.setH_(0);
		transformation.setI_(1);
		transformation.setR_(0);
		transformation.setL_(0);
		transformation.setM_(0);
		transformation.setN_(0);
		transformation.setS_(1);

		return transformation;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenTransformation Zero() {
		JunPenTransformation transformation = new JunPenTransformation();
		transformation.setA_(0);
		transformation.setB_(0);
		transformation.setC_(0);
		transformation.setP_(0);
		transformation.setD_(0);
		transformation.setE_(0);
		transformation.setF_(0);
		transformation.setQ_(0);
		transformation.setG_(0);
		transformation.setH_(0);
		transformation.setI_(0);
		transformation.setR_(0);
		transformation.setL_(0);
		transformation.setM_(0);
		transformation.setN_(0);
		transformation.setS_(0);

		return transformation;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double a() {
		return this.a;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aLocation DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation applyToLocation_(JunPenLocation aLocation) {
		JunPenLocation location = JunPenLocation.Coerce_(aLocation);
		double nx = (location.x() * this.a) + (location.y() * this.d) + (location.z() * this.g) + l;
		double ny = (location.x() * this.b) + (location.y() * this.e) + (location.z() * this.h) + m;
		double nz = (location.x() * this.c) + (location.y() * this.f) + (location.z() * this.i) + n;
		double scale = (location.x() * this.p) + (location.y() * this.q) + (location.z() * this.r) + s;

		if (scale == 0.0d) {
			scale = Accuracy();
		}

		return JunPenLocation.X_y_z_(nx / scale, ny / scale, nz / scale);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double b() {
		return this.b;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double c() {
		return this.c;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double d() {
		return this.d;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double e() {
		return this.e;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double f() {
		return this.f;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double g() {
		return this.g;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double h() {
		return this.h;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double i() {
		return this.i;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double l() {
		return this.l;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double m() {
		return this.m;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double n() {
		return this.n;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double p() {
		return this.p;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aTransformation DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenTransformation product_(JunPenTransformation aTransformation) {
		JunPenTransformation transformation = new JunPenTransformation();
		transformation.setA_((this.a * aTransformation.a()) + (this.b * aTransformation.d()) + (this.c * aTransformation.g()) + (this.p * aTransformation.l()));
		transformation.setB_((this.a * aTransformation.b()) + (this.b * aTransformation.e()) + (this.c * aTransformation.h()) + (this.p * aTransformation.m()));
		transformation.setC_((this.a * aTransformation.c()) + (this.b * aTransformation.f()) + (this.c * aTransformation.i()) + (this.p * aTransformation.n()));
		transformation.setP_((this.a * aTransformation.p()) + (this.b * aTransformation.q()) + (this.c * aTransformation.r()) + (this.p * aTransformation.s()));
		transformation.setD_((this.d * aTransformation.a()) + (this.e * aTransformation.d()) + (this.f * aTransformation.g()) + (this.q * aTransformation.l()));
		transformation.setE_((this.d * aTransformation.b()) + (this.e * aTransformation.e()) + (this.f * aTransformation.h()) + (this.q * aTransformation.m()));
		transformation.setF_((this.d * aTransformation.c()) + (this.e * aTransformation.f()) + (this.f * aTransformation.i()) + (this.q * aTransformation.n()));
		transformation.setQ_((this.d * aTransformation.p()) + (this.e * aTransformation.q()) + (this.f * aTransformation.r()) + (this.q * aTransformation.s()));
		transformation.setG_((this.g * aTransformation.a()) + (this.h * aTransformation.d()) + (this.i * aTransformation.g()) + (this.r * aTransformation.l()));
		transformation.setH_((this.g * aTransformation.b()) + (this.h * aTransformation.e()) + (this.i * aTransformation.h()) + (this.r * aTransformation.m()));
		transformation.setI_((this.g * aTransformation.c()) + (this.h * aTransformation.f()) + (this.i * aTransformation.i()) + (this.r * aTransformation.n()));
		transformation.setR_((this.g * aTransformation.p()) + (this.h * aTransformation.q()) + (this.i * aTransformation.r()) + (this.r * aTransformation.s()));
		transformation.setL_((this.l * aTransformation.a()) + (this.m * aTransformation.d()) + (this.n * aTransformation.g()) + (this.s * aTransformation.l()));
		transformation.setM_((this.l * aTransformation.b()) + (this.m * aTransformation.e()) + (this.n * aTransformation.h()) + (this.s * aTransformation.m()));
		transformation.setN_((this.l * aTransformation.c()) + (this.m * aTransformation.f()) + (this.n * aTransformation.i()) + (this.s * aTransformation.n()));
		transformation.setS_((this.l * aTransformation.p()) + (this.m * aTransformation.q()) + (this.n * aTransformation.r()) + (this.s * aTransformation.s()));

		return transformation;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double q() {
		return this.q;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double r() {
		return this.r;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double s() {
		return this.s;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setA_(double aNumber) {
		this.a = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setB_(double aNumber) {
		this.b = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setC_(double aNumber) {
		this.c = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setD_(double aNumber) {
		this.d = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setE_(double aNumber) {
		this.e = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setF_(double aNumber) {
		this.f = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setG_(double aNumber) {
		this.g = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setH_(double aNumber) {
		this.h = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setI_(double aNumber) {
		this.i = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setL_(double aNumber) {
		this.l = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setM_(double aNumber) {
		this.m = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setN_(double aNumber) {
		this.n = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setP_(double aNumber) {
		this.p = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setQ_(double aNumber) {
		this.q = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setR_(double aNumber) {
		this.r = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setS_(double aNumber) {
		this.s = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aTransformation DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenTransformation transform_(JunPenTransformation aTransformation) {
		return this.product_(aTransformation);
	}
}
