package jp.co.sra.jun.goodies.pen;

import java.util.Vector;

/**
 * JunPenDirection class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1999/1/5 (by Hirotsugu Kondo)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPenDirection.java,v 8.10 2008/02/20 06:32:01 nisinaka Exp $
 */
public class JunPenDirection extends JunPenGeometry {
	private JunPenAngle longitude;
	private JunPenAngle latitude;

	/**
	 * Construsctor.
	 */
	public JunPenDirection() {
		super();
		this.longitude = JunPenAngle.Zero();
		this.latitude = JunPenAngle.Zero();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anObject DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenDirection Coerce_(double[] anObject) {
		int length = anObject.length;

		if (length < 1) {
			return null;
		}

		if (length < 2) {
			return Longitude_(anObject[0]);
		}

		return Longitude_latitude_(anObject[0], anObject[length - 1]);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aValue DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenDirection Coerce_(double aValue) {
		return Longitude_(aValue);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anObject JunPenDirection or Vector of Double or Double
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenDirection Coerce_(Object anObject) {
		if (anObject.getClass() == JunPenDirection.class) {
			return (JunPenDirection) anObject;
		}

		if (anObject.getClass() == Vector.class) {
			return Longitude_latitude_(((Double) ((Vector) anObject).firstElement()).doubleValue(), ((Double) ((Vector) anObject).lastElement()).doubleValue());
		}

		return Longitude_(((Double) anObject).doubleValue());
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param longitudeDegrees DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenDirection Longitude_(double longitudeDegrees) {
		return Longitude_latitude_(longitudeDegrees, 0.0d);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param longitudeDegrees DOCUMENT ME!
	 * @param latitudeDegrees DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenDirection Longitude_latitude_(double longitudeDegrees, double latitudeDegrees) {
		JunPenDirection direction = new JunPenDirection();
		direction.setLongitude_(longitudeDegrees);
		direction.setLatitude_(latitudeDegrees);

		return direction;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static final JunPenDirection Zero() {
		return new JunPenDirection();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenAngle latitude() {
		return this.latitude;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenAngle longitude() {
		return this.longitude;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param latitudeDegrees DOCUMENT ME!
	 */
	private void setLatitude_(double latitudeDegrees) {
		this.latitude = JunPenAngle.Coerce_(new Double(latitudeDegrees));
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param longitudeDegrees DOCUMENT ME!
	 */
	private void setLongitude_(double longitudeDegrees) {
		this.longitude = JunPenAngle.Coerce_(new Double(longitudeDegrees));
	}
}
