package jp.co.sra.jun.goodies.parameter;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunParametersViewSwing class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/06/02 (by MATSUDA Ryouichi)
 *  @updated   2003/01/17 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunParametersViewSwing.java,v 8.10 2008/02/20 06:32:01 nisinaka Exp $
 */
public class JunParametersViewSwing extends JunAbstractViewJPanel implements JunParametersView {

	protected JunParameterViewSwing[] _parameterViews;
	protected JPanel _panel;

	/**
	 * Create a new instance of JunParametersViewSwing and initialize it.
	 *
	 * @param aModel jp.co.sra.jun.goodies.parameter.JunParametersModel
	 */
	public JunParametersViewSwing(JunParametersModel aModel) {
		super(aModel);
	}

	/**
	 * Answer my model as a JunParametersModel.
	 * 
	 * @return jp.co.sra.jun.goodies.parameter.JunParametersModel
	 */
	public JunParametersModel getParametersModel() {
		return (JunParametersModel) this.model();
	}

	/**
	 * Update the components of the parameters if changed.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (evt.getAspect() == $("build")) {
			this.buildComposite();
			this._layoutComponents(_panel.getWidth(), _panel.getHeight());
		} else {
			super.update_(evt);
		}
	}

	/**
	 * Layout my components.
	 *
	 * @return int
	 * @param width int
	 * @param height int
	 */
	protected int _layoutComponents(int width, int height) {
		if (_parameterViews == null) {
			return -1;
		}

		int y = 4;
		for (int i = 0; i < _parameterViews.length; i++) {
			int viewHeight = _parameterViews[i].getParameterModel().preferredHeight();
			_parameterViews[i].setBounds(4, y, width - 4, viewHeight);
			y += viewHeight + 4;
		}
		return y;
	}

	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		_panel = new JPanel() {
			public void setBounds(int x, int y, int width, int height) {
				int bottom = _layoutComponents(width, height);
				if (bottom < 0) {
					bottom = height;
				}
				super.setBounds(x, y, width, bottom);
			}
		};
		_panel.setLayout(null);

		JScrollPane aScrollPane = new JScrollPane(_panel, ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS, ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER) {
			public void setBounds(int x, int y, int width, int height) {
				super.setBounds(x, y, width, height);
				_panel.setBounds(0, 0, width - this.getVerticalScrollBar().getPreferredSize().width - 4, height);
			}
		};
		aScrollPane.setPreferredSize(new Dimension(200, 200));

		this.setLayout(new BorderLayout());
		this.add(aScrollPane, BorderLayout.CENTER);

		this.buildComposite();
	}

	/**
	 * Build the composite.
	 */
	protected void buildComposite() {
		_panel.removeAll();

		JunParameter[] parameters = this.getParametersModel().parameters();
		_parameterViews = new JunParameterViewSwing[parameters.length];
		for (int i = 0; i < parameters.length; i++) {
			_parameterViews[i] = new JunParameterViewSwing(new JunParameterModel(parameters[i]));
			_panel.add(_parameterViews[i]);
		}
	}

	/**
	 * Answer a default model.
	 * 
	 * @return jp.co.sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new JunParametersModel();
	}

}
