package jp.co.sra.jun.goodies.nib;

import java.awt.Dialog;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSimpleDialog;
import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunNibChoiceDialog class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2004/03/23 (By Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun492 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunNibChoiceDialog.java,v 8.11 2008/02/20 06:31:51 nisinaka Exp $
 */
public class JunNibChoiceDialog extends StSimpleDialog {

	protected JunNibChoice nibChoiceModel;
	protected StBlockClosure acceptBlock;
	protected StBlockClosure cancelBlock;

	/**
	 * Open a nib choice dialog and let a user to choose.
	 * 
	 * @return Object
	 * @category Utilities
	 */
	public static Object Request() {
		return Request(JunSystem.$String("Nib Choice Dialog"));
	}

	/**
	 * Open a nib choice dialog and let a user to choose.
	 * 
	 * @param messageString java.lang.String
	 * @return Object
	 * @category Utilities
	 */
	public static Object Request(String messageString) {
		return Request(messageString, new JunNibChoice());
	}

	/**
	 * Open a nib choice dialog and let a user to choose.
	 * 
	 * @param messageString java.lang.String
	 * @param nibChoiceModel jp.co.sra.jun.goodies.nib.JunNibChoice
	 * @return Object
	 * @category Utilities
	 */
	public static Object Request(String messageString, JunNibChoice nibChoiceModel) {
		return Request(messageString, nibChoiceModel, null, null);
	}

	/**
	 * Open a nib choice dialog and let a user to choose.
	 * 
	 * @param messageString java.lang.String
	 * @param nibChoiceModel jp.co.sra.jun.goodies.nib.JunNibChoice
	 * @param acceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param cancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return Object
	 * @category Utilities
	 */
	public static Object Request(String messageString, JunNibChoice nibChoiceModel, StBlockClosure acceptBlock, StBlockClosure cancelBlock) {
		JunNibChoiceDialog nibChoiceDialog = new JunNibChoiceDialog();
		if (nibChoiceModel != null) {
			nibChoiceDialog.nibChoiceModel_(nibChoiceModel);
		}
		Dialog dialog = nibChoiceDialog.allButOpenDialog();
		if (messageString != null) {
			dialog.setTitle(messageString);
		}
		if (acceptBlock != null) {
			nibChoiceDialog.acceptBlock_(acceptBlock);
		}
		if (cancelBlock != null) {
			nibChoiceDialog.cancelBlock_(cancelBlock);
		}
		_ShowAtMousePoint(dialog);
		if (nibChoiceDialog.accept()._booleanValue()) {
			return nibChoiceDialog.nibChoiceModel().value();
		} else {
			return null;
		}
	}

	/**
	 * Open a nib choice dialog and let a user to choose.
	 * 
	 * @param messageString java.lang.String
	 * @param valueArray Object[]
	 * @return Object
	 * @category Utilities
	 */
	public static Object Request(String messageString, Object[] valueArray) {
		return Request(messageString, new JunNibChoice(valueArray), null, null);
	}

	/**
	 * Answer the current nib choice model.
	 * 
	 * @return jp.co.sra.jun.goodies.nib.JunNibChoice
	 * @category accessing
	 */
	public JunNibChoice nibChoiceModel() {
		if (nibChoiceModel == null) {
			nibChoiceModel = new JunNibChoice();
		}
		return nibChoiceModel;
	}

	/**
	 * Set the new nib choice model.
	 * 
	 * @param aModel jp.co.sra.jun.goodies.nib.JunNibChoice
	 * @category accessing
	 */
	public void nibChoiceModel_(JunNibChoice aModel) {
		nibChoiceModel = aModel;
	}

	/**
	 * Set the new accept block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public void acceptBlock_(StBlockClosure aBlock) {
		acceptBlock = aBlock;
	}

	/**
	 * Set the new cancel block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public void cancelBlock_(StBlockClosure aBlock) {
		cancelBlock = aBlock;
	}

	/**
	 * Called when an accept button is pressed.
	 * 
	 * @return boolean
	 * @category actions
	 */
	public boolean acceptButtonPressed() {
		if (acceptBlock != null) {
			return ((Boolean) acceptBlock.value_(this.nibChoiceModel())).booleanValue();
		}
		return true;
	}

	/**
	 * Called when an cancel button is pressed.
	 * 
	 * @return boolean
	 * @category actions
	 */
	public boolean cancelButtonPressed() {
		if (cancelBlock != null) {
			return ((Boolean) cancelBlock.value_(this.nibChoiceModel())).booleanValue();
		}
		return true;
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunNibChoiceDialogViewAwt(this);
		} else {
			return new JunNibChoiceDialogViewSwing(this);
		}
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Nib Choice Dialog");
	}

}
