package jp.co.sra.jun.goodies.multimedia;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.TextArea;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunMultiMediaTextViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2003/03/18 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMultiMediaTextViewAwt.java,v 8.12 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunMultiMediaTextViewAwt extends JunAbstractViewPanel implements JunMultiMediaTextView {

	protected TextArea textArea;

	/**
	 * Create a new instance of <code>JunMultiMediaTextViewAwt</code> and initialize it.
	 * 
	 * @param aMultiMediaTextModel jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextModel
	 * @category Instance creation
	 */
	public JunMultiMediaTextViewAwt(JunMultiMediaTextModel aMultiMediaTextModel) {
		super(aMultiMediaTextModel);
	}

	/**
	 * Answer my model as JunMultiMediaTextModel.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextModel
	 * @see jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextView#getTextModel()
	 * @category model accessing
	 */
	public JunMultiMediaTextModel getTextModel() {
		return (JunMultiMediaTextModel) this.model();
	}

	/**
	 * Answer my text area.
	 *
	 * @return java.awt.TextArea
	 * @category user interface
	 */
	public TextArea textArea() {
		if (textArea == null) {
			textArea = new TextArea((String) this.getTextModel().textHolder().value()) {
				public Dimension getPreferredSize() {
					return new Dimension(200, 150);
				}
			};
			textArea.setEditable(false);
			textArea.setBackground(Color.white);

			this.getTextModel().textHolder().compute_(new StBlockClosure() {
				public Object value_(Object newValue) {
					textArea.setText((String) newValue);
					return null;
				}
			});
		}
		return textArea;
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new BorderLayout());
		this.add(this.textArea(), BorderLayout.CENTER);
		// this.setSize(200, 150);
	}
}
