package jp.co.sra.jun.goodies.multimedia;

import java.io.File;

import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.files.JunFileModel.FileType;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunMultiMediaBodyModelTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/03/14 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun646 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMultiMediaBodyModelTestExamples.java,v 8.7 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunMultiMediaBodyModelTestExamples extends JunTestExamples {
	/**
	 * Example1: Open a <code>JunMultiMediaBodyModelTestExamples</code> with file.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		FileType[] fileTypes = new FileType[] {
				new JunFileModel.FileType($String("Body files"), JunSystem.DefaultBodyExtensionPatterns() ),
				JunFileModel.FileType.All($String("All files"))
		};
		File aFile = JunFileRequesterDialog.RequestFile($String("Select a <1p> file.", null, $String("Body files")), fileTypes, fileTypes[0]);
		if (aFile == null || aFile.isDirectory() || aFile.canRead() == false) {
			return false;
		}
		
		JunMultiMediaBodyModel bodyModel = new JunMultiMediaBodyModel(aFile);
		if (bodyModel == null) {
			return false;
		}
		bodyModel.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunMultiMediaBodyModelTestExamples();
	}
}
