package jp.co.sra.jun.goodies.movie.support;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.menu.StPopupMenuViewAwt;

import jp.co.sra.jun.system.framework.JunAbstractViewPanel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunScreenRecorderViewAwt class
 * 
 *  @author    Hoshi Takanori
 *  @created   2002/10/18 (by Hoshi Takanori)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2005/03/03 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunScreenRecorderViewAwt.java,v 8.11 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunScreenRecorderViewAwt extends JunAbstractViewPanel implements JunScreenRecorderView, ActionListener {

	protected Button recordButton;
	protected Button areaButton;
	protected Button sizeButton;
	protected Button speedButton;
	protected Button snapButton;
	protected PopupMenu areaPopupMenu;
	protected PopupMenu sizePopupMenu;
	protected PopupMenu speedPopupMenu;

	/**
	 * Create a new instance of <code>JunScreenRecorderViewAwt</code> and initialize it.
	 * 
	 * @param aScreenRecorder jp.co.sra.jun.goodies.movie.framework.JunScreenRecorder
	 * @category Instance creation
	 */
	public JunScreenRecorderViewAwt(JunScreenRecorder aScreenRecorder) {
		super(aScreenRecorder);
	}

	/**
	 * Actions for the event.
	 * 
	 * @param e java.awt.event.ActionEvent
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 * @category actions
	 */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == recordButton) {
			getScreenRecorder().recordButtonPressed();
		} else if (e.getSource() == areaButton) {
			if (areaPopupMenu == null) {
				areaPopupMenu = new StPopupMenuViewAwt(this.getScreenRecorder()._createAreaPopupMenu()).toPopupMenu();
				this.add(areaPopupMenu);
			}
			areaPopupMenu.show(areaButton, 10, 10);
		} else if (e.getSource() == sizeButton) {
			if (sizePopupMenu == null) {
				sizePopupMenu = new StPopupMenuViewAwt(this.getScreenRecorder()._createSizePopupMenu()).toPopupMenu();
				this.add(sizePopupMenu);
			}
			sizePopupMenu.show(sizeButton, 10, 10);
		} else if (e.getSource() == speedButton) {
			if (speedPopupMenu == null) {
				speedPopupMenu = new StPopupMenuViewAwt(this.getScreenRecorder()._createSpeedPopupMenu()).toPopupMenu();
				this.add(speedPopupMenu);
			}
			speedPopupMenu.show(speedButton, 10, 10);
		} else if (e.getSource() == snapButton) {
			getScreenRecorder().snapButtonPressed();
		}
	}

	/**
	 * Answer insets.
	 * 
	 * @return java.awt.Insets
	 * @see java.awt.Container#getInsets()
	 * @category bounds accessing
	 */
	public Insets getInsets() {
		return new Insets(6, 6, 6, 6);
	}

	/**
	 * Answer the preferred size of this component.
	 * 
	 * @return java.awt.Dimension
	 * @see java.awt.Container#getPreferredSize()
	 * @category bounds accessing
	 */
	public Dimension getPreferredSize() {
		return new Dimension(250, 150);
	}

	/**
	 * Answer my model as JunScreenRecorder.
	 *
	 * @return jp.co.sra.jun.goodies.movie.framework.JunScreenRecorder
	 * @see jp.co.sra.jun.goodies.movie.support.JunScreenRecorderView#getScreenRecorder()
	 * @category model accessing
	 */
	public JunScreenRecorder getScreenRecorder() {
		return (JunScreenRecorder) this.model();
	}

	/**
	 * Receive a change notice from an object of whom the receiver is a
	 * dependent.  The argument anAspectSymbol is typically a Symbol that
	 * indicates what change has occurred.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		StSymbol anAspect = evt.getAspect();

		if (anAspect == $("watchState")) {
			this.updateRecordButtonLabel();
		} else if (anAspect == $("movieArea")) {
			this.updateAreaButtonLabel();
		} else if (anAspect == $("movieExtent")) {
			this.updateSizeButtonLabel();
		} else if (anAspect == $("watchTick")) {
			this.updateSpeedButtonLabel();
		} else {
			super.update_(evt);
		}
	}

	/**
	 * Update area button label.
	 * 
	 * @category updating
	 */
	public void updateAreaButtonLabel() {
		areaButton.setLabel(getScreenRecorder().getAreaButtonLabel());
	}

	/**
	 * Update record/stop button label.
	 * 
	 * @category updating
	 */
	public void updateRecordButtonLabel() {
		recordButton.setLabel(getScreenRecorder().getRecordButtonLabel());

		areaButton.setEnabled(!getScreenRecorder().getWatchState());
		sizeButton.setEnabled(!getScreenRecorder().getWatchState());
		speedButton.setEnabled(!getScreenRecorder().getWatchState());
		snapButton.setEnabled(!getScreenRecorder().getWatchState());
	}

	/**
	 * Update size button label.
	 * 
	 * @category updating
	 */
	public void updateSizeButtonLabel() {
		sizeButton.setLabel(getScreenRecorder().getSizeButtonLabel());
	}

	/**
	 * Update speed button label.
	 * 
	 * @category updating
	 */
	public void updateSpeedButtonLabel() {
		speedButton.setLabel(getScreenRecorder().getSpeedButtonLabel());
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setBackground(new Color(0xff, 0xff, 0xbf));
		this.setLayout(new GridLayout(0, 1, 2, 2));

		recordButton = new Button(JunSystem.$String("Record"));
		recordButton.setBackground(new Color(0xff, 0xbf, 0xbf));
		recordButton.addActionListener(this);
		this.add(recordButton);

		areaButton = new Button(JunSystem.$String("Snap Area"));
		areaButton.setBackground(new Color(0xbf, 0xff, 0xbf));
		areaButton.addActionListener(this);
		this.add(areaButton);

		sizeButton = new Button(JunSystem.$String("Snap Size"));
		sizeButton.setBackground(new Color(0xbf, 0xff, 0xbf));
		sizeButton.addActionListener(this);
		this.add(sizeButton);

		speedButton = new Button(JunSystem.$String("Recording Speed"));
		speedButton.setBackground(new Color(0xbf, 0xff, 0xbf));
		speedButton.addActionListener(this);
		this.add(speedButton);

		snapButton = new Button(JunSystem.$String("Snap"));
		snapButton.setBackground(new Color(0xbf, 0xbf, 0xff));
		snapButton.addActionListener(this);
		this.add(snapButton);

		this.updateRecordButtonLabel();
		this.updateAreaButtonLabel();
		this.updateSizeButtonLabel();
		this.updateSpeedButtonLabel();
	}

}