package jp.co.sra.jun.goodies.movie.framework;

import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunMovieView interface
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2001/01/24 (by NISHIHARA Satoshi)
 *  @updated   2003/03/24 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMovieView.java,v 8.11 2008/02/20 06:31:49 nisinaka Exp $
 */
public interface JunMovieView extends JunAbstractView {

	/**
	 * Answer my model as a JunMoviePlayer.
	 * 
	 * @return jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer
	 * @category accessing
	 */
	public JunMoviePlayer getMoviePlayer();

	/**
	 * Answer my movie handle.
	 * 
	 * @return jp.co.sra.jun.goodies.JunMovieHandle
	 * @category accessing
	 */
	public JunMovieHandle movieHandle();

	/**
	 * Answer true if the view has a movie, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean hasMovie();

	/**
	 * Answer true if the view has a tracker, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean hasTracker();

	/**
	 * Answer true if the view has a second tracker, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean hasTracker2();

	/**
	 * Set the movie view.
	 * 
	 * @category private
	 */
	public void setMovieView();

}
