package jp.co.sra.jun.goodies.milliseconds;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import jp.co.sra.smalltalk.StSimpleDialogViewSwing;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunMillisecondDialogViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2003/05/28 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun433 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMillisecondDialogViewSwing.java,v 8.10 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunMillisecondDialogViewSwing extends StSimpleDialogViewSwing implements JunMillisecondDialogView {

	protected JunMillisecondViewSwing millisecondView;
	protected JButton acceptButton;
	protected JButton cancelButton;

	/**
	 * Create a new instance of JunMillisecondDialogViewSwing and initialize it.
	 *
	 * @param aMillisecondDialog jp.co.sra.jun.goodies.milliseconds.JunMillisecondDialog
	 */
	public JunMillisecondDialogViewSwing(JunMillisecondDialog aMillisecondDialog) {
		super(aMillisecondDialog);
	}

	/**
	 * Answer my model as a JunMillisecondDialog.
	 *
	 * @return jp.co.sra.jun.goodies.milliseconds.JunMillisecondDialog
	 */
	public JunMillisecondDialog getMillisecondDialog() {
		return (JunMillisecondDialog) this.model();
	}

	/**
	 * Answer my accpet button.
	 *
	 * @return javax.swing.JButton
	 */
	protected JButton acceptButton() {
		if (acceptButton == null) {
			acceptButton = new JButton(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getMillisecondDialog().acceptButtonPressed()) {
						getMillisecondDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.millisecondView()._onBorderedPanel(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -102, 1f, -1));
		this.add(this.acceptButton(), WindowSpecLayout.Position(1f, -96, 0f, 16, 1f, -8, 0f, 48));
		this.add(this.cancelButton(), WindowSpecLayout.Position(1f, -96, 0f, 56, 1f, -8, 0f, 88));
		this.setPreferredSize(new Dimension(250, 100));

		defaultButton = this.acceptButton();
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return javax.swing.JButton
	 */
	protected JButton cancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getMillisecondDialog().cancelButtonPressed()) {
						getMillisecondDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Answer my millisecond view.
	 *
	 * @return jp.co.sra.jun.goodies.milliseconds.JunMillisecondViewSwing
	 */
	protected JunMillisecondViewSwing millisecondView() {
		if (millisecondView == null) {
			millisecondView = new JunMillisecondViewSwing(this.getMillisecondDialog().millisecondModel());
		}
		return millisecondView;
	}
}
