package jp.co.sra.jun.goodies.meter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JPanel;

import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.WindowSpecLayout;

/**
 * JunStereoLevelMeterViewSwing class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/04/04 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun652 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunStereoLevelMeterViewSwing.java,v 8.6 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunStereoLevelMeterViewSwing extends JunAbstractGaugeMeterViewSwing implements JunStereoLevelMeterView {
	protected JPanel leftView;
	protected JPanel rightView;

	/**
	 * Create a new instance of <code>JunStereoLevelMeterViewSwing</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunStereoLevelMeterViewSwing() {
		super();
	}

	/**
	 * Create a new instance of <code>JunStereoLevelMeterViewSwing</code> and initialize it.
	 * 
	 * @param aMeter jp.co.sra.jun.goodies.meter.JunStereoLevelMeter
	 * @category Instance creation
	 */
	public JunStereoLevelMeterViewSwing(JunStereoLevelMeter aMeter) {
		super(aMeter);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		leftView = null;
		rightView = null;
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.leftView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 0.5f, -1, 1f, -1));
		this.add(this.rightView(), WindowSpecLayout.Position(0.5f, 1, 0f, 1, 1f, -1, 1f, -1));
		this.setPreferredSize(new Dimension(200, 200));
	}

	/**
	 * Answer the receiver's left view.
	 * 
	 * @return java.awt.Component
	 * @category interface opening
	 */
	protected Component leftView() {
		if (leftView == null) {
			leftView = StApplicationModel._JPanelWithBorder();
			leftView.setLayout(new BorderLayout());
			leftView.add(this.meterView_(this.getStereoLevelMeter().leftGauges()), BorderLayout.CENTER);
		}
		return leftView;
	}

	/**
	 * Answer the receiver's right view.
	 * 
	 * @return java.awt.Component
	 * @category interface opening
	 */
	protected Component rightView() {
		if (rightView == null) {
			rightView = StApplicationModel._JPanelWithBorder();
			rightView.setLayout(new BorderLayout());
			rightView.add(this.meterView_(this.getStereoLevelMeter().rightGauges()), BorderLayout.CENTER);
		}
		return rightView;
	}

	/**
	 * Answer the receiver's model as JunStereoLevelMeter
	 * 
	 * @return jp.co.sra.jun.goodies.meter.JunStereoLevelMeter
	 * @see jp.co.sra.jun.goodies.meter.JunStereoLevelMeterView#getStereoLevelMeter()
	 * @category model accessing
	 */
	public JunStereoLevelMeter getStereoLevelMeter() {
		return (JunStereoLevelMeter) this.model();
	}
}
