package jp.co.sra.jun.goodies.meter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JPanel;

import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.WindowSpecLayout;

/**
 * JunLevelGaugeMeterViewSwing class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/04/05 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun652 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLevelGaugeMeterViewSwing.java,v 8.6 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunLevelGaugeMeterViewSwing extends JunAbstractGaugeMeterViewSwing implements JunLevelGaugeMeterView {
	protected JPanel subView;

	/**
	 * Create a new instance of <code>JunLevelGaugeMeterViewSwing</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunLevelGaugeMeterViewSwing() {
		super();
	}

	/**
	 * Create a new instance of <code>JunLevelGaugeMeterViewSwing</code> and initialize it.
	 * 
	 * @param aMeter jp.co.sra.jun.goodies.meter.JunLevelGaugeMeter
	 * @category Instance creation
	 */
	public JunLevelGaugeMeterViewSwing(JunLevelGaugeMeter aMeter) {
		super(aMeter);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		subView = null;
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.subView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -1));
		this.setPreferredSize(new Dimension(200, 200));
	}

	/**
	 * Answer the receiver's subview.
	 * 
	 * @return java.awt.Component
	 * @category interface opening
	 */
	protected Component subView() {
		if (subView == null) {
			subView = StApplicationModel._JPanelWithBorder();
			subView.setLayout(new BorderLayout());
			subView.add(this.meterView_(this.getModel().gauges()), BorderLayout.CENTER);
		}
		return subView;
	}

}
