package jp.co.sra.jun.goodies.lisp;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;

import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

/**
 * JunLispNil class
 * 
 *  @author    ASTI Beijing
 *  @created   1998/12/09 (by ASTI Beijing)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun394 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLispNil.java,v 8.10 2008/02/20 06:31:49 nisinaka Exp $
 */
public final class JunLispNil extends JunLispList {

	/** The single object of the class. */
	public static final JunLispNil NullList = new JunLispNil();

	/**
	 * Should not allow to create an instance of JunLispNil.
	 * 
	 * @category Instance creation
	 */
	private JunLispNil() {
	}

	/**
	 * Create a new instance of JunLispNil.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param head java.lang.Object
	 * @category Instance creation 
	 */
	public static JunLispList Head_(Object head) {
		throw SmalltalkException.ShouldNotImplement();
	}

	/**
	 * Create a new instance of JunLispNil.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param head java.lang.Object
	 * @param tail java.lang.Object
	 * @category Instance creation
	 */
	public static JunLispList Head_tail_(Object head, Object tail) {
		throw SmalltalkException.ShouldNotImplement();
	}

	/**
	 * Answer the single object of the JunLispNil.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispNil
	 * @category Instance creation
	 */
	public static JunLispNil NullList() {
		return NullList;
	}

	/**
	 * Add anObject to the receiver.
	 * 
	 * @return java.lang.Object
	 * @param newObject java.lang.Object
	 * @category adding
	 */
	public Object add_(Object newObject) {
		return JunLispCons.Head_tail_(newObject, JunLispNil.NullList());
	}

	/**
	 * Do nothing and just return the receiver.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param list jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category functions 
	 */
	public JunLispList append_(JunLispList list) {
		return list;
	}

	/**
	 * Convert the receiver as an array of Object.
	 * 
	 * @return java.lang.Object[]
	 * @category converting
	 */
	public Object[] asArray() {
		return new Object[0];
	}

	/**
	 * Evaluate the Block with each of the receiver's elements and answer the
	 * first element for which the Block evaluates to true.
	 * 
	 * @return java.lang.Object
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param exceptionBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating 
	 */
	public Object detect_ifNone_(StBlockClosure aBlock, StBlockClosure exceptionBlock) {
		return exceptionBlock.value();
	}

	/**
	 * Do nothing.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating
	 */
	public void do_(StBlockClosure aBlock) {
	}

	/**
	 * Enumerate the sublists and return one with the specified head.
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.SySymbol
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @see jp.co.sra.jun.goodies.lisp.JunLispList#_findSublistWithHead(jp.co.sra.smalltalk.StSymbol)
	 * @category enumerating
	 */
	public JunLispCons _findSublistWithHead(StSymbol aSymbol) {
		return null;
	}

	/**
	 * Answer the receiver as for a head object.
	 * 
	 * @return java.lang.Object
	 * @category accessing
	 */
	public Object head() {
		return this;
	}

	/**
	 * Answer the last object.
	 * 
	 * @return java.lang.Object
	 * @category functions
	 */
	public Object last() {
		return this;
	}

	/**
	 * Answer the length of the receiver.
	 * 
	 * @return int
	 * @category functions
	 */
	public int length() {
		return 0;
	}

	/**
	 * Do nothing and just return the receiver..
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category functions
	 */
	public void mapcdr_(StBlockClosure aBlock) {
		return;
	}

	/**
	 * Do nothing and just return the receiver.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param anObject java.lang.Object
	 * @category functions 
	 */
	public JunLispList member_(Object anObject) {
		return this;
	}

	/**
	 * Do nothing and just return the receiver.
	 * 
	 * @param anObject java.lang.Object
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category functions
	 */
	public JunLispList memq_(Object anObject) {
		return this;
	}

	/**
	 * Do nothing.
	 * 
	 * @param list jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category functions
	 */
	public void nconc_(JunLispList list) {
		return;
	}

	/**
	 * Do nothing and just return the receiver.
	 * 
	 * @return java.lang.Object
	 * @param nth int
	 * @category functions 
	 */
	public Object nth_(int nth) {
		return this;
	}

	/**
	 * Answer true if the receiver is a null list, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean nullList() {
		return true;
	}

	/**
	 * Pretty print my string representation on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @exception jva.io.IOException 
	 * @category pretty printing
	 */
	public void ppOn_(Writer aWriter) throws IOException {
		BufferedWriter bw = (aWriter instanceof BufferedWriter) ? (BufferedWriter) aWriter : new BufferedWriter(aWriter);
		bw.write("nil");
		bw.newLine();
		bw.flush();
	}

	/**
	 * Answer the pretty print string of the receiver.
	 * 
	 * @return jp.co.sra.smalltalk.String
	 * @throws jp.co.sra.smalltalk.SmalltalkException 
	 * @category pretty printing
	 */
	public String ppString() {
		StringWriter sw = new StringWriter();
		BufferedWriter bw = new BufferedWriter(sw);
		try {
			bw.write("nil");
			bw.newLine();
			bw.flush();
		} catch (IOException e) {
			throw new SmalltalkException(e);
		}

		return sw.toString();
	}

	/**
	 * Print my string representation on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @exception java.io.IOException
	 * @category printing 
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write("nil");
	}

	/**
	 * Reverse the order of the receiver..
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category functions
	 */
	public JunLispList reverse() {
		return this;
	}

	/**
	 * Generate a string for saving the receiver.
	 * 
	 * @param aWriter java.io.Writer
	 * @exception java.io.IOException
	 * @category saving 
	 */
	public void saveOn_(Writer aWriter) throws IOException {
		aWriter.write("nil");
	}

	/**
	 * Answer the string for saving receiver.
	 * 
	 * @return java.lang.String
	 * @category saving
	 */
	public String saveString() {
		return new String("nil");
	}

	/**
	 * Answer the receiver as for a tail object.
	 * 
	 * @return java.lang.Object
	 * @category accessing
	 */
	public Object tail() {
		return this;
	}

	/**
	 * Convert the receiver as a Vector.
	 * 
	 * @return java.util.Vector
	 * @category converting
	 */
	public Vector toVector() {
		return new Vector(0);
	}

}
