package jp.co.sra.jun.goodies.lisp;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunLispInterpreterTestExamples class
 * 
 *  @author    ASTI Beijing
 *  @created   1998/12/09 (by ASTI Beijing)
 *  @updated   2003/05/07 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLispInterpreterTestExamples.java,v 8.10 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunLispInterpreterTestExamples extends JunTestExamples {

	/**
	 * Open a JunLispInterpreter.
	 * 
	 * @return boolean
	 */
	public static boolean Example() {
		(new JunLispInterpreter()).open();

		return true;
	}

	/**
	 * Example01:
	 * 
	 * @return boolean
	 */
	public static boolean Example01() {
		Object aList = JunLispInterpreter.EvaluateFrom_("nil");
		System.out.println(aList);

		return aList == JunLispNil.NullList();
	}

	/**
	 * Example02:
	 * 
	 * @return boolean
	 */
	public static boolean Example02() {
		Object aList = JunLispInterpreter.EvaluateFrom_("123");
		System.out.println(aList);

		return aList instanceof Number && ((Number) aList).intValue() == 123;
	}

	/**
	 * Example03:
	 * 
	 * @return boolean
	 */
	public static boolean Example03() {
		Object aList = JunLispInterpreter.EvaluateFrom_("\"abc\"");
		System.out.println(aList);

		return aList instanceof String && "abc".equals(aList);
	}

	/**
	 * Example04:
	 * 
	 * @return boolean
	 */
	public static boolean Example04() {
		Object aList = JunLispInterpreter.EvaluateFrom_("(cons 3 4)");
		System.out.println(aList.toString());

		return aList instanceof JunLispCons
			&& ((JunLispCons) aList).head() instanceof Integer
			&& ((Integer) ((JunLispCons) aList).head()).intValue() == 3
			&& ((JunLispCons) aList).tail() instanceof Integer
			&& ((Integer) ((JunLispCons) aList).tail()).intValue() == 4;
	}

	/**
	 * Example05:
	 * 
	 * @return boolean
	 */
	public static boolean Example05() {
		Object aList = JunLispInterpreter.EvaluateFrom_("(quote (3 4))");
		System.out.println(aList);

		return aList instanceof JunLispCons
			&& ((JunLispCons) aList).head() instanceof Integer
			&& ((Integer) ((JunLispCons) aList).head()).intValue() == 3
			&& ((JunLispCons) aList).tail() instanceof JunLispCons
			&& ((JunLispCons) ((JunLispCons) aList).tail()).head() instanceof Integer
			&& ((Integer) ((JunLispCons) ((JunLispCons) aList).tail()).head()).intValue() == 4
			&& ((JunLispCons) ((JunLispCons) aList).tail()).tail() == JunLispNil.NullList();
	}

	/**
	 * Example06:
	 * 
	 * @return boolean
	 */
	public static boolean Example06() {
		Object aList = JunLispInterpreter.EvaluateFrom_("(car (quote (3 4)))");
		System.out.println(aList.toString());

		return aList instanceof Integer && ((Integer) aList).intValue() == 3;
	}

	/**
	 * Example07:
	 * 
	 * @return boolean
	 */
	public static boolean Example07() {
		Object aList = JunLispInterpreter.EvaluateFrom_("(cdr (quote (3 4)))");
		System.out.println(aList.toString());

		return aList instanceof JunLispCons && ((JunLispCons) aList).head() instanceof Integer && ((Integer) ((JunLispCons) aList).head()).intValue() == 4 && ((JunLispCons) aList).tail() == JunLispNil.NullList();
	}

	/**
	 * Example08:
	 * 
	 * @return boolean
	 */
	public static boolean Example08() {
		Object aList = JunLispInterpreter.EvaluateFrom_("(cons (car `(1 2 3)) `(3 4))");
		System.out.println(aList.toString());

		return aList instanceof JunLispCons
			&& ((JunLispCons) aList).head() instanceof Integer
			&& ((Integer) ((JunLispCons) aList).head()).intValue() == 1
			&& ((JunLispCons) aList).tail() instanceof JunLispCons
			&& ((JunLispCons) ((JunLispCons) aList).tail()).head() instanceof Integer
			&& ((Integer) ((JunLispCons) ((JunLispCons) aList).tail()).head()).intValue() == 3
			&& ((JunLispCons) ((JunLispCons) aList).tail()).tail() instanceof JunLispCons
			&& ((JunLispCons) ((JunLispCons) ((JunLispCons) aList).tail()).tail()).head() instanceof Integer
			&& ((Integer) ((JunLispCons) ((JunLispCons) ((JunLispCons) aList).tail()).tail()).head()).intValue() == 4
			&& ((JunLispCons) ((JunLispCons) ((JunLispCons) aList).tail()).tail()).tail() == JunLispNil.NullList();
	}

	/**
	 * Example09:
	 * 
	 * @return boolean
	 */
	public static boolean Example09() {
		Object aList = JunLispInterpreter.EvaluateFrom_("(+ 1 2 3 4 5 6 7 8 9 10)");
		System.out.println(aList.toString());

		return aList instanceof Integer && ((Integer) aList).intValue() == 55;
	}

	/**
	 * Example10:
	 * 
	 * @return boolean
	 */
	public static boolean Example10() {
		String aString = "";
		aString += "	(progn ";
		aString += "		(setq x 100) ";
		aString += "		(setq y 200 z 300) ";
		aString += "		(+ x y z)) ";

		Object aList = JunLispInterpreter.EvaluateFrom_(aString);
		System.out.println(aList.toString());

		return aList instanceof Integer && ((Integer) aList).intValue() == 600;
	}

	/**
	 * Example11:
	 * 
	 * @return boolean
	 */
	public static boolean Example11() {
		String aString = "";
		aString += "	(progn ";
		aString += "		(defun plus (x y) (+ x y)) ";
		aString += "		(plus 3 4)) ";

		Object aList = JunLispInterpreter.EvaluateFrom_(aString);
		System.out.println(aList.toString());

		return aList instanceof Integer && ((Integer) aList).intValue() == 7;
	}

	/**
	 * Example12:
	 * 
	 * @return boolean
	 */
	public static boolean Example12() {
		String aString = "";
		aString += "	(progn ";
		aString += "		(defun concat (x y)  ";
		aString += "			(cond ";
		aString += "				((atom x) y) ";
		aString += "				(t (cons ";
		aString += "						(car x) ";
		aString += "						(concat (cdr x) y))))) ";
		aString += "		(concat `(1 2 3) `(4 5))) ";

		Object aList = JunLispInterpreter.EvaluateFrom_(aString);
		System.out.println(aList.toString());

		return aList instanceof JunLispCons
			&& ((JunLispCons) aList).size() == 5
			&& ((JunLispCons) aList).nth_(1) instanceof Integer
			&& ((Integer) ((JunLispCons) aList).nth_(1)).intValue() == 1
			&& ((JunLispCons) aList).nth_(2) instanceof Integer
			&& ((Integer) ((JunLispCons) aList).nth_(2)).intValue() == 2
			&& ((JunLispCons) aList).nth_(3) instanceof Integer
			&& ((Integer) ((JunLispCons) aList).nth_(3)).intValue() == 3
			&& ((JunLispCons) aList).nth_(4) instanceof Integer
			&& ((Integer) ((JunLispCons) aList).nth_(4)).intValue() == 4
			&& ((JunLispCons) aList).nth_(5) instanceof Integer
			&& ((Integer) ((JunLispCons) aList).nth_(5)).intValue() == 5;
	}

	/**
	 * Example14:
	 * 
	 * @return boolean
	 */
	public static boolean Example14() {
		String aString = "";
		aString += "	(progn ";
		aString += "		(defun plus nlambda (x) (plus1 x)) ";
		aString += "		(defun plus1 lambda (x) ";
		aString += "			(cond ";
		aString += "				((null x) 0) ";
		aString += "				(t (+ (car x) (plus1 (cdr x)))))) ";
		aString += "		(plus 1 2 3 4 5 6 7 8 9 10)) ";

		Object aList = JunLispInterpreter.EvaluateFrom_(aString);
		System.out.println(aList.toString());

		return aList instanceof Integer && (((Integer) aList).intValue() == 55);
	}

	/**
	 * Example15:
	 * 
	 * @return boolean
	 */
	public static boolean Example15() {
		Object aList = JunLispInterpreter.EvaluateFrom_("((lambda (x y) (cons x (cons y nil))) 3 4)");
		System.out.println(aList.toString());

		return aList instanceof JunLispCons
			&& ((JunLispCons) aList).head() instanceof Integer
			&& ((Integer) ((JunLispCons) aList).head()).intValue() == 3
			&& ((JunLispCons) aList).tail() instanceof JunLispCons
			&& ((JunLispCons) ((JunLispCons) aList).tail()).head() instanceof Integer
			&& ((Integer) ((JunLispCons) ((JunLispCons) aList).tail()).head()).intValue() == 4
			&& ((JunLispCons) ((JunLispCons) aList).tail()).tail() == JunLispNil.NullList();
	}

	/**
	 * Example16:
	 * 
	 * @return boolean
	 */
	public static boolean Example16() {
		Object aList = JunLispInterpreter.EvaluateFrom_("((nlambda (x) x) 1 2 3 4 5 6 7 8 9 10)");
		System.out.println(aList.toString());

		return aList instanceof JunLispCons
			&& ((JunLispCons) aList).size() == 10
			&& ((JunLispCons) aList).nth_(1) instanceof Integer
			&& ((Integer) ((JunLispCons) aList).nth_(1)).intValue() == 1
			&& ((JunLispCons) aList).nth_(2) instanceof Integer
			&& ((Integer) ((JunLispCons) aList).nth_(2)).intValue() == 2
			&& ((JunLispCons) aList).nth_(3) instanceof Integer
			&& ((Integer) ((JunLispCons) aList).nth_(3)).intValue() == 3
			&& ((JunLispCons) aList).nth_(4) instanceof Integer
			&& ((Integer) ((JunLispCons) aList).nth_(4)).intValue() == 4
			&& ((JunLispCons) aList).nth_(5) instanceof Integer
			&& ((Integer) ((JunLispCons) aList).nth_(5)).intValue() == 5
			&& ((JunLispCons) aList).nth_(6) instanceof Integer
			&& ((Integer) ((JunLispCons) aList).nth_(6)).intValue() == 6
			&& ((JunLispCons) aList).nth_(7) instanceof Integer
			&& ((Integer) ((JunLispCons) aList).nth_(7)).intValue() == 7
			&& ((JunLispCons) aList).nth_(8) instanceof Integer
			&& ((Integer) ((JunLispCons) aList).nth_(8)).intValue() == 8
			&& ((JunLispCons) aList).nth_(9) instanceof Integer
			&& ((Integer) ((JunLispCons) aList).nth_(9)).intValue() == 9
			&& ((JunLispCons) aList).nth_(10) instanceof Integer
			&& ((Integer) ((JunLispCons) aList).nth_(10)).intValue() == 10;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunLispInterpreterTestExamples();
	}
}
