package jp.co.sra.jun.goodies.itemlist;

import java.io.IOException;
import java.io.Writer;

import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunOrderListObject class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/09 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOrderListObject.java,v 8.11 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunOrderListObject extends JunAbstractObject {
	protected String itemString;
	
	/**
	 * Create a new instance of <code>JunOrderListObject</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunOrderListObject() {
		super();
	}
	
	/**
	 * Create a new instance of <code>JunOrderListObject</code> and initialize it.
	 * 
	 * @param aString java.lang.String
	 * @category Instance creation
	 */
	public JunOrderListObject(String aString) {
		this();
		this.itemString_(aString);
	}
	
	/**
	 * Initialize this object.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		itemString = "";
	}

	/**
	 * Get the label string.
	 * 
	 * @return java.lang.String
	 * @category accessing
	 */
	public String itemString() {
		return itemString;
	}

	/**
	 * Set the label string.
	 * 
	 * @param aString java.lang.String
	 * @category accessing
	 */
	public void itemString_(String aString) {
		itemString = aString;
	}

	/**
	 * Print my string representation on aWriter.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws IOException if failed.
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write(this.getClass().getName());
		aWriter.write(" (");
		aWriter.write(this.itemString());
		aWriter.write(")");
	}
}
