package jp.co.sra.jun.goodies.itemlist;

import java.awt.*;
import java.awt.event.*;
import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunOrderListDialogViewAwt class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/12 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOrderListDialogViewAwt.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunOrderListDialogViewAwt extends StSimpleDialogViewAwt implements JunOrderListDialogView {
	protected StView orderListView;
	protected Button acceptButton;
	protected Button cancelButton;

	/**
	 * Create a new instance of JunOrderListDialogViewAwt and initialize it.
	 *
	 * @param aOrderListDialog jp.co.sra.jun.goodies.itemlist.JunOrderListDialog
	 * @category Instance creation
	 */
	public JunOrderListDialogViewAwt(JunOrderListDialog aOrderListDialog) {
		super(aOrderListDialog);
	}

	/**
	 * Answer my model as a JunOrderListDialog.
	 *
	 * @return jp.co.sra.jun.goodies.itemlist.JunOrderListDialog
	 * @see jp.co.sra.jun.goodies.itemlist.JunOrderListDialogView#getOrderListDialog()
	 * @category model accessing
	 */
	public JunOrderListDialog getOrderListDialog() {
		return (JunOrderListDialog) this.model();
	}

	/**
	 * Build this component.
	 * 
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.orderListView().toComponent(), WindowSpecLayout.Position(0f, 8, 0f, 8, 1f, -8, 1f, -48));
		this.add(this.acceptButton(), WindowSpecLayout.Position(0.3f, -48, 1f, -40, 0.3f, 48, 1f, -8));
		this.add(this.cancelButton(), WindowSpecLayout.Position(0.7f, -48, 1f, -40, 0.7f, 48, 1f, -8));
		this.setSize(300, 200);

		defaultButton = this.acceptButton();
	}

	/**
	 * Answer my accpet button.
	 *
	 * @return java.awt.Button
	 * @category interface opening
	 */
	protected Button acceptButton() {
		if (acceptButton == null) {
			acceptButton = new Button(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunOrderListDialogViewAwt.this.getOrderListDialog().acceptButtonPressed()) {
						JunOrderListDialogViewAwt.this.getOrderListDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return java.awt.Button
	 * @category interface opening
	 */
	protected Button cancelButton() {
		if (cancelButton == null) {
			cancelButton = new Button(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunOrderListDialogViewAwt.this.getOrderListDialog().cancelButtonPressed()) {
						JunOrderListDialogViewAwt.this.getOrderListDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Answer my order list view.
	 *
	 * @return jp.co.sra.smalltalk.StView
	 * @category interface opening
	 */
	protected StView orderListView() {
		if (orderListView == null) {
			orderListView = JunOrderListViewAwt.OnScrollPaneWithButtons(this.getOrderListDialog().itemListModel());
		}
		return orderListView;
	}
}
