package jp.co.sra.jun.goodies.itemlist;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import jp.co.sra.jun.system.framework.JunAbstractController;

/**
 * JunOrderListController class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/09 (by Mitsuhiro Asada)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOrderListController.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunOrderListController extends JunAbstractController {

	/**
	 * Answer the model as JunOrderListModel.
	 * 
	 * @return jp.co.sra.jun.goodies.itemlist.JunOrderListModel
	 * @category model accessing
	 */
	public JunOrderListModel getModel() {
		return (JunOrderListModel) this.model();
	}

	/**
	 * Answer the view as a JunOrderListView.
	 * 
	 * @return jp.co.sra.jun.goodies.itemlist.JunOrderListView
	 * @category view accessing
	 */
	public JunOrderListView getView() {
		return (JunOrderListView) this.view();
	}

	/**
	 * Invoked when a mouse button has been pressed on the view.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mousePressed(MouseEvent)
	 * @category events
	 */
	public void mousePressed(MouseEvent event) {
		Point aPoint = event.getPoint();
		int anIndex = this.getView().whichOfItemRowsAt_(aPoint);
		if (event.isShiftDown()) {
			this.selectWithShiftDownAt_(anIndex);
		} else {
			if (event.isControlDown()) {
				this.selectWithCtrlDownAt_(anIndex);
			} else {
				this.selectAt_(anIndex);
			}
		}
	}

	/**
	 * Select the item object specified an index position.
	 * 
	 * @param anIndex
	 * @category selecting
	 */
	protected void selectAt_(int anIndex) {
		if (anIndex > -1) {
			if (this.getModel().isSelected_(anIndex)) {
				this.getModel().selectedIndexes_(new Vector());
			} else {
				Vector indexes = new Vector();
				indexes.add(new Integer(anIndex));
				this.getModel().selectedIndexes_(indexes);
			}
		} else {
			this.getModel().selectedIndexes_(new Vector());
		}
	}

	/**
	 * Select the item object specified an index position with ctrl down.
	 * 
	 * @param anIndex
	 * @category selecting
	 */
	protected void selectWithCtrlDownAt_(int anIndex) {
		if (anIndex > -1) {
			Vector selectedIndexes = (Vector) this.getModel().selectedIndexes().clone();
			if (this.getModel().isSelected_(anIndex)) {
				selectedIndexes.remove(new Integer(anIndex));
			} else {
				selectedIndexes.add(new Integer(anIndex));
			}
			this.getModel().selectedIndexes_(selectedIndexes);
		}
	}

	/**
	 * Select the item object specified an index position with shift down.
	 * 
	 * @param anIndex
	 * @category selecting
	 */
	protected void selectWithShiftDownAt_(int anIndex) {
		if (anIndex > -1) {
			Vector selectedIndexes = (Vector) this.getModel().selectedIndexes().clone();
			if (selectedIndexes.isEmpty()) {
			} else {
				Vector newSelectedIndexes = new Vector();
				int firstIndex = ((Integer) selectedIndexes.firstElement()).intValue();
				if (firstIndex < anIndex) {
					for (int index = firstIndex; index <= anIndex; index++) {
						newSelectedIndexes.add(new Integer(index));
					}
				} else {
					for (int index = firstIndex; index >= anIndex; index--) {
						newSelectedIndexes.add(new Integer(index));
					}
				}
				selectedIndexes = newSelectedIndexes;
			}
			this.getModel().selectedIndexes_(selectedIndexes);
		}
	}

}
