package jp.co.sra.jun.goodies.itemlist;

import java.util.Vector;
import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunItemListModel class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/12 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunItemListModel.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunItemListModel extends JunOrderListModel {
	/**
	 * Create a new instance of JunItemListModel.
	 * 
	 * @category Instance creation
	 */
	public JunItemListModel() {
		super();
	}

	/**
	 * Create a new instance of JunItemListModel.
	 * 
	 * @param stringCollection java.lang.String[]
	 * @category Instance creation
	 */
	public JunItemListModel(String[] stringCollection) {
		super(stringCollection);
	}

	/**
	 * Create a new instance of JunItemListModel.
	 * 
	 * @param stringCollection java.lang.String[]
	 * @param booleanCollection boolean[]
	 * @category Instance creation
	 */
	public JunItemListModel(String[] stringCollection, boolean[] booleanCollection) {
		this(stringCollection, booleanCollection, null);
	}

	/**
	 * Create a new instance of JunItemListModel.
	 * 
	 * @param stringCollection java.lang.String[]
	 * @param checkBooleanCollection boolean[]
	 * @param lockBooleanCollection boolean[]
	 * @category Instance creation
	 */
	public JunItemListModel(String[] stringCollection, boolean[] checkBooleanCollection, boolean[] lockBooleanCollection) {
		this();

		if (checkBooleanCollection == null) {
			checkBooleanCollection = new boolean[stringCollection.length];
			for (int i = 0; i < checkBooleanCollection.length; i++) {
				checkBooleanCollection[i] = false;
			}
		}
		if (lockBooleanCollection == null) {
			lockBooleanCollection = new boolean[stringCollection.length];
			for (int i = 0; i < lockBooleanCollection.length; i++) {
				lockBooleanCollection[i] = false;
			}
		}
		
		for (int index = 0; index < stringCollection.length; index++) {
			String aString;
			if (stringCollection[index] == null) {
				aString = "";
			} else {
				aString = stringCollection[index];
			}
			boolean checkBoolean = checkBooleanCollection[index];
			boolean lockBoolean = lockBooleanCollection[index];
			JunItemListObject itemObject = (JunItemListObject) this.defaultObject();
			itemObject.itemString_(aString);
			itemObject.checkMark_(checkBoolean);
			itemObject.checkLock_(lockBoolean);
			this.addItemObject_(itemObject);
		}
	}

	/**
	 * Answer the value in this item objects.
	 * 
	 * @return java.lang.Object[]
	 * @category accessing
	 */
	public Object[] value() {
		StAssociation[] value = new StAssociation[this.size()];
		for (int i = 0; i < value.length; i++) {
			JunItemListObject itemObject = (JunItemListObject) this.itemObjectAt_(i);
			value[i] = new StAssociation(itemObject.itemString(), new Boolean(itemObject.checkMark()));
		}
		return value;
	}

	/**
	 * Answer a view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @category accessing
	 */
	public StView getView() {
		Object[] dependents = this.dependents();
		for (int i = 0; i < dependents.length; i++) {
			Object each = dependents[i];
			if (each instanceof JunItemListView && ((JunItemListView) each).model() == this) {
				return (StView) each;
			}
		}
		return null;
	}

	/**
	 * Answer the default item object.
	 * 
	 * @return jp.co.sra.jun.goodies.itemlist.JunOrderListObject
	 * @category defaults
	 */
	public JunOrderListObject defaultObject() {
		return new JunItemListObject();
	}

	/**
	 * Answer the default view.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return JunItemListViewAwt.OnScrollPaneWithButtons(this);
		} else {
			return JunItemListViewSwing.OnScrollPaneWithButtons(this);
		}
	}

	/**
	 * Answer the window title.
	 * 
	 * @return java.lang.String
	 * @category viewing
	 */
	protected String windowTitle() {
		return JunSystem.$String("Item List");
	}

	/**
	 * Answer the check off button model.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonModel
	 * @category buttons
	 */
	public JunButtonModel checkOffButton() {
		JunButtonModel button = new JunButtonModel(false, JunCursors.CheckOffCursorImage(), new StBlockClosure() {
			public Object value_(Object obj) {
				JunItemListModel.this.checkOffButtonAction();
				return null;
			}
		});
		return button;
	}

	/**
	 * The action of check off button.
	 * 
	 * @category buttons
	 */
	public void checkOffButtonAction() {
		if (this.selectedIndexes().isEmpty()) {
			return;
		}
		JunOrderListObject[] selectedItemObjects = this.selectedItemObjects();
		for (int i = 0; i < selectedItemObjects.length; i++) {
			((JunItemListObject) selectedItemObjects[i]).checkMark_(false);
		}
		this.changed_with_($("marks"), new Object[] {this.selectedIndexes(), new Vector()});
	}

	/**
	 * Answer the check off button model.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonModel
	 * @category buttons
	 */
	public JunButtonModel checkOnButton() {
		JunButtonModel button = new JunButtonModel(false, JunCursors.CheckOnCursorImage(), new StBlockClosure() {
			public Object value_(Object obj) {
				JunItemListModel.this.checkOnButtonAction();
				return null;
			}
		});
		return button;
	}

	/**
	 * The action of check on button.
	 * 
	 * @category buttons
	 */
	public void checkOnButtonAction() {
		if (this.selectedIndexes().isEmpty()) {
			return;
		}
		if (this.selectedIndexes().isEmpty()) {
			return;
		}
		JunOrderListObject[] selectedItemObjects = this.selectedItemObjects();
		for (int i = 0; i < selectedItemObjects.length; i++) {
			((JunItemListObject) selectedItemObjects[i]).checkMark_(true);
		}
		this.changed_with_($("marks"), new Object[] {this.selectedIndexes(), new Vector()});
	}
}
