package jp.co.sra.jun.goodies.itemlist;

import java.awt.*;
import java.awt.event.MouseEvent;

/**
 * JunItemListController class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/12 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunItemListController.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunItemListController extends JunOrderListController {
	/**
	 * Answer the view as a JunItemListView.
	 * 
	 * @return jp.co.sra.jun.goodies.itemlist.JunItemListView
	 * @category view accessing
	 */
	public JunItemListView getItemListView() {
		return (JunItemListView) this.view();
	}

	/**
	 * Invoked when a mouse button has been pressed on the view.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mousePressed(MouseEvent)
	 * @category events
	 */
	public void mousePressed(MouseEvent event) {
		Point aPoint = event.getPoint();
		int anIndex = this.getItemListView().whichOfCheckMarksAt_(aPoint);
		if (anIndex >= 0) {
			JunItemListObject itemObject = (JunItemListObject) this.getView().itemObjectAt_(anIndex);
			itemObject.checkMark_(!itemObject.checkMark());
			Rectangle invalidRect = this.getView().rowBoundsAt_(anIndex);
			this.getView().toComponent().repaint(0, invalidRect.x, invalidRect.y, invalidRect.width, invalidRect.height);
		} else {
			super.mousePressed(event);
		}
	}
}
