package jp.co.sra.jun.goodies.itemlist;

import java.awt.ScrollPane;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.StViewPanel;
import jp.co.sra.smalltalk.WindowSpecLayout;

/**
 * JunChoiceListViewAwt class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/15 (by Mitsuhiro Asada)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChoiceListViewAwt.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunChoiceListViewAwt extends JunItemListViewAwt implements JunChoiceListView {

	/**
	 * Create a new instance of JunChoiceListViewAwt.
	 * 
	 * @param newModel jp.co.sra.jun.goodies.itemlist.JunChoiceListModel
	 * @category Instance creation
	 */
	public JunChoiceListViewAwt(JunChoiceListModel newModel) {
		super(newModel);
	}

	/**
	 * Create a new view for the JunChoiceListViewAwt.
	 * The view consists of a JunChoiceListViewAwt on a ScrollPane.
	 * The view having up/down buttons.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @param newModel jp.co.sra.jun.goodies.itemlist.JunChoiceListModel
	 * @category Instance creation
	 */
	public static StView OnScrollPaneWithButtons(JunChoiceListModel newModel) {
		return new StViewPanel(newModel) {
			protected JunChoiceListViewAwt itemListView;

			protected void buildComponent() {
				itemListView = new JunChoiceListViewAwt((JunChoiceListModel) this.model());
				ScrollPane scrollPane = new ScrollPane(ScrollPane.SCROLLBARS_ALWAYS) {
					public void setBounds(int x, int y, int width, int height) {
						super.setBounds(x, y, width, height);
						itemListView.setSize(this.getViewportSize().width, this.getViewportSize().height);
					}
				};
				scrollPane.add(itemListView);

				this.setLayout(new WindowSpecLayout());
				this.add(scrollPane, WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -20, 1f, -1));
				this.add(itemListView.checkOnButtonView(), WindowSpecLayout.Position(1f, -19, 0.5f, -19, 1f, -1, 0.5f, -1));
				this.add(itemListView.checkOffButtonView(), WindowSpecLayout.Position(1f, -19, 0.5f, 1, 1f, -1, 0.5f, 19));
				this.setSize(150, 150);
			}
		};
	}
}
