package jp.co.sra.jun.goodies.image.streams;

import com.sun.jimi.core.*;
import java.io.*;
import jp.co.sra.smalltalk.*;

/**
 * JunJimiPngImageStream class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2000/11/16 (by Mitsuhiro Asada)
 *  @updated   2005/08/15 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunJimiPngImageStream.java,v 8.11 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunJimiPngImageStream extends JunPngImageStream {
	/**
	 * Constructor with an input stream.
	 * 
	 * @return jp.co.sra.jun.goodies.image.streams.JunImageStream
	 * @param stream java.io.InputStream
	 * @exception java.io.IOException
	 * @category Instance creation
	 */
	public static JunImageStream On_(InputStream stream) throws IOException {
		return On_(new JunJimiPngImageStream(), stream);
	}

	/**
	 * Constructor with an output stream.
	 * 
	 * @return jp.co.sra.jun.goodies.image.streams.JunImageStream
	 * @param stream java.io.OutputStream
	 * @exception java.io.IOException
	 * @category Instance creation
	 */
	public static JunImageStream On_(OutputStream stream) throws IOException {
		return On_(new JunJimiPngImageStream(), stream);
	}

	/**
	 * Read the image from the input stream. (used JIMI Software Development Kit)
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @exception java.io.IOException
	 * @category accessing
	 */
	public StImage nextImage() throws IOException {
		if (inStream != null) {
			imageObject = new StImage(Jimi.getImage(inStream, "image/png"));
		}
		return imageObject;
	}

	/**
	 * Write the image on output stream. (used JIMI Software Development Kit)
	 * 
	 * @param newImage jp.co.sra.smalltalk.StImage
	 * @exception java.io.IOException
	 * @category accessing
	 */
	public void nextPutImage_(StImage newImage) throws IOException {
		if (outStream != null) {
			imageObject = newImage;
			try {
				Jimi.putImage("image/png", newImage.image(), outStream);
			} catch (JimiException e) {
				e.printStackTrace();
				throw new IOException(e.getMessage());
			}
		}
	}
}
