package jp.co.sra.jun.goodies.image.streams;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.goodies.animation.JunCartoonMovie;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.utilities.JunImageUtility;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunGifAnimationStreamTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2007/10/04 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGifAnimationStreamTestExamples.java,v 8.4 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunGifAnimationStreamTestExamples extends JunTestExamples {

	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @throws java.io.IOException
	 * @category Examples
	 */
	public static boolean Example1() throws IOException {
		File file = new File("zzz.gif");

		JunGifAnimationStream stream = null;
		try {
			stream = (JunGifAnimationStream) JunGifAnimationStream.On_(new FileOutputStream(file));
			stream.tick_(100);
			stream.loop_(0);
			Rectangle box = new Rectangle(0, 0, 320, 240);
			Point offset = new Point(10, 10);

			JunCursors cursor = new JunCursors(JunCursors.WriteCursor());
			try {
				cursor._show();

				for (int i = 0; i < 20; i++) {
					Image image = JunImageUtility.FromDisplay_(box);
					stream.nextPutImage_(new StImage(image));
					box.translate(offset.x, offset.y);
				}
				for (int i = 0; i < 20; i++) {
					box.translate(-offset.x, -offset.y);
					Image image = JunImageUtility.FromDisplay_(box);
					stream.nextPutImage_(new StImage(image));
				}

			} finally {
				cursor._restore();
			}
		} finally {
			if (stream != null) {
				stream.close();
			}
		}

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 * @throws java.io.IOException
	 * @category Examples
	 */
	public static boolean Example2() throws IOException {
		File file = new File("zzz.gif");
		ArrayList images = new ArrayList();

		JunGifAnimationStream stream = null;
		try {
			stream = (JunGifAnimationStream) JunGifAnimationStream.On_(new FileInputStream(file));

			JunCursors cursor = new JunCursors(JunCursors.ReadCursor());
			try {
				cursor._show();

				StImage image = null;
				while ((image = stream.nextImage()) != null) {
					int tick = stream.tick();
					images.add(new Object[] { image, new Integer(tick) });
				}

			} finally {
				cursor._restore();
			}
		} finally {
			if (stream != null) {
				stream.close();
			}
		}

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 * @throws java.io.IOException
	 * @category Examples
	 */
	public static boolean Example3() throws IOException {
		File file = new File("zzz.gif");
		JunCartoonMovie cartoon = new JunCartoonMovie();

		JunGifAnimationStream stream = null;
		try {
			stream = (JunGifAnimationStream) JunGifAnimationStream.On_(new FileInputStream(file));

			JunCursors cursor = new JunCursors(JunCursors.ReadCursor());
			try {
				cursor._show();

				StImage image = null;
				while ((image = stream.nextImage()) != null) {
					int tick = stream.tick();
					cartoon.addImage_keepTime_(image, tick);
				}

			} finally {
				cursor._restore();
			}
		} finally {
			if (stream != null) {
				stream.close();
			}
		}

		if (stream.loop() == 0) {
			cartoon.loopPlay();
		}
		cartoon.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunGifAnimationStreamTestExamples();
	}

}
