package jp.co.sra.jun.goodies.image.framework;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Toolkit;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StViewPanel;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunImageDisplayViewAwt class
 * 
 *  @author    m-asada
 *  @created   2006/04/07 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun632 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImageDisplayViewAwt.java,v 8.11 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunImageDisplayViewAwt extends JunAbstractViewPanel implements JunImageDisplayView {
	protected boolean _scrollable;
	protected StViewPanel canvas;
	protected ScrollPane scrollPane;

	/**
	 * Create a new instance of <code>JunImageDisplayViewAwt</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunImageDisplayViewAwt() {
		super();
	}

	/**
	 * Create a new instance of <code>JunImageDisplayViewAwt</code> and initialize it.
	 * 
	 * @param newModel jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Instance creation
	 */
	public JunImageDisplayViewAwt(JunImageDisplayModel newModel) {
		super(newModel);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		canvas = null;
		scrollPane = null;
		this._scrollable(false);
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.scrollPane(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, 0));

		Dimension imageSize = this.getModel().bounds().getSize();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		screenSize.setSize(screenSize.width - 50 * 2, screenSize.height - 60 * 2);
		Insets insets = this.scrollPane().getInsets();
		if (imageSize.width > screenSize.width || imageSize.height > screenSize.height) {
			this._scrollable(true);
			this.setSize(new Dimension(Math.min(imageSize.width, screenSize.width) + insets.left + insets.right, Math.min(imageSize.height, screenSize.height) + insets.top + insets.bottom));
		} else {
			this._scrollable(false);
			this.setSize(new Dimension(imageSize.width + insets.left + insets.right, imageSize.height + insets.top + insets.bottom));
		}
	}

	/**
	 * Answer whether the view is opened with scrollbars or not.
	 *
	 * @return boolean
	 * @category accessing
	 */
	public boolean _isScrollable() {
		return _scrollable;
	}

	/**
	 * Set whether the view is opened with scrollbars or not.
	 *
	 * @param aBoolean boolean
	 * @see jp.co.sra.jun.goodies.image.framework.JunImageDisplayView#_scrollable(boolean)
	 * @category accessing
	 */
	public void _scrollable(boolean aBoolean) {
		_scrollable = aBoolean;
		if (_scrollable) {
			this.remove(scrollPane);
			scrollPane = null;
			canvas.removeMouseMotionListener(this.controller());
			canvas.removeMouseListener(this.controller());
			canvas = null;

			this.add(this.scrollPane(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, 0));
			this.addNotify();
			((JunImageDisplayController) this.controller()).buildListener(this);
		}
	}

	/**
	 * Do the layout on the scroll pane.
	 * 
	 * @see java.awt.Component#addNotify()
	 * @category actions
	 */
	public void addNotify() {
		super.addNotify();
		this.doLayout();
		this.scrollPane().doLayout();
	}

	/**
	 * Gets the preferred size of this component.
	 * 
	 * @return java.awt.Dimension
	 * @see java.awt.Component#getPreferredSize()
	 * @category bounds accessing
	 */
	public Dimension getPreferredSize() {
		Point location = this.scrollPane().getLocation();
		Dimension size = this.scrollPane().getPreferredSize();
		return new Dimension(size.width + location.x * 2, size.height + location.y * 2);
	}

	/**
	 * Answer the viewport bounds at the recevier's scroll pane.
	 * 
	 * @return java.awt.Rectangle
	 * @see jp.co.sra.jun.goodies.image.framework.JunImageDisplayView#_getViewportBounds()
	 * @category bounds accessing
	 */
	public Rectangle _getViewportBounds() {
		return new Rectangle(this.scrollPane().getScrollPosition(), this.scrollPane().getViewportSize());
	}

	/**
	 * Answer a default controller.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @see jp.co.sra.smalltalk.StViewJPanel#defaultController()
	 * @category controller accessing
	 * 
	 */
	protected StController defaultController() {
		return new JunImageDisplayController();
	}

	/**
	 * Answer the receiver's model as JunImageDisplayModel.
	 * 
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @see jp.co.sra.jun.goodies.image.framework.JunImageDisplayView#getModel()
	 * @category model accessing
	 */
	public JunImageDisplayModel getModel() {
		return (JunImageDisplayModel) this.model();
	}

	/**
	 * Receive a change notice from an object of whom the receiver is a dependent.
	 * The argument anAspectSymbol is typically a Symbol that indicates what change has occurred.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		if (this.topComponent().isShowing() == false) {
			return;
		}
		if (evt.getAspect() == $("redisplay")) {
			this.canvas().repaint();
		} else {
			super.update_(evt);
		}
	}

	/**
	 * Answer my canvas.
	 *
	 * @return jp.co.sra.smalltalk.StViewPanel
	 * @category user interface
	 */
	public StViewPanel canvas() {
		if (canvas == null) {
			canvas = new StViewPanel() {
				public StModel model() {
					return JunImageDisplayViewAwt.this.model();
				}

				public Dimension getPreferredSize() {
					return JunImageDisplayViewAwt.this.getModel() == null ? Toolkit.getDefaultToolkit().getScreenSize() : JunImageDisplayViewAwt.this.getModel().bounds().getSize();
				}

				public void displayOn_(Graphics aGraphics) {
					if (JunImageDisplayViewAwt.this.getModel().displayImage() == null) {
						return;
					}
					JunImageDisplayViewAwt.this.getModel().displayImage().displayOn_(aGraphics);
				}

				public void _showPopupMenu(int x, int y) {
					PopupMenu popupMenu = JunImageDisplayViewAwt.this.popupMenuView();
					if (popupMenu != null) {
						popupMenu.show(this, x, y);
					}
				}
			};
		}
		return canvas;
	}

	/**
	 * Answer the receiver's canvas as Component.
	 * 
	 * @return java.awt.Component
	 * @see jp.co.sra.jun.goodies.image.framework.JunImageDisplayView#_canvasComponent()
	 * @category user interface
	 */
	public Component _canvasComponent() {
		return this.canvas().toComponent();
	}

	/**
	 * Answer my scroll pane, which already contains the canvas.
	 *
	 * @return java.awt.ScrollPane
	 * @category user interface
	 */
	public ScrollPane scrollPane() {
		if (scrollPane == null) {
			scrollPane = new ScrollPane(this._isScrollable() ? ScrollPane.SCROLLBARS_ALWAYS : ScrollPane.SCROLLBARS_NEVER) {
				public Dimension getPreferredSize() {
					Dimension size = JunImageDisplayViewAwt.this.getModel().bounds().getSize();
					Insets insets = this.getInsets();
					return new Dimension(size.width + insets.left + insets.right, size.height + insets.top + insets.bottom);
				}
			};
			scrollPane.add(this.canvas());
		}
		return scrollPane;
	}
}
