package jp.co.sra.jun.goodies.icon;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StOpaqueImage;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpaqueImageIconsTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/01/14 (by nisinaka)
 *  @updated   2007/03/19 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun653 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpaqueImageIconsTestExamples.java,v 8.12 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunOpaqueImageIconsTestExamples extends JunTestExamples {

	/**
	 * Show all drive icons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_DriveIcons() {
		StOpaqueImage[] icons = new StOpaqueImage[] { JunOpaqueImageIcons.Drive16x16(), JunOpaqueImageIcons.Drive32x32(), JunOpaqueImageIcons.Drive64x64() };
		IconImages(icons)._display();
		return true;
	}

	/**
	 * Show all close folder icons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_CloseFolderIcons() {
		StOpaqueImage[] icons = new StOpaqueImage[] { JunOpaqueImageIcons.FolderClose16x16(), JunOpaqueImageIcons.FolderClose32x32(), JunOpaqueImageIcons.FolderClose64x64() };
		IconImages(icons)._display();
		return true;
	}

	/**
	 * Show all open folder icons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_OpenFolderIcons() {
		StOpaqueImage[] icons = new StOpaqueImage[] { JunOpaqueImageIcons.FolderOpen16x16(), JunOpaqueImageIcons.FolderOpen32x32(), JunOpaqueImageIcons.FolderOpen64x64() };
		IconImages(icons)._display();
		return true;
	}

	/**
	 * Show all image icons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_ImageIcons() {
		StOpaqueImage[] icons = new StOpaqueImage[] { JunOpaqueImageIcons.Image16x16(), JunOpaqueImageIcons.Image32x32(), JunOpaqueImageIcons.Image64x64() };
		IconImages(icons)._display();
		return true;
	}

	/**
	 * Show all movie icons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_MovieIcons() {
		StOpaqueImage[] icons = new StOpaqueImage[] { JunOpaqueImageIcons.Movie16x16(), JunOpaqueImageIcons.Movie32x32(), JunOpaqueImageIcons.Movie64x64() };
		IconImages(icons)._display();
		return true;
	}

	/**
	 * Show all sound icons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_SoundIcons() {
		StOpaqueImage[] icons = new StOpaqueImage[] { JunOpaqueImageIcons.Sound16x16(), JunOpaqueImageIcons.Sound32x32(), JunOpaqueImageIcons.Sound64x64() };
		IconImages(icons)._display();
		return true;
	}

	/**
	 * Show all text icons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_TextIcons() {
		StOpaqueImage[] icons = new StOpaqueImage[] { JunOpaqueImageIcons.Text16x16(), JunOpaqueImageIcons.Text32x32(), JunOpaqueImageIcons.Text64x64() };
		IconImages(icons)._display();
		return true;
	}

	/**
	 * Show all body icons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_BodyIcons() {
		StOpaqueImage[] icons = new StOpaqueImage[] { JunOpaqueImageIcons.Body16x16(), JunOpaqueImageIcons.Body32x32(), JunOpaqueImageIcons.Body64x64() };
		IconImages(icons)._display();
		return true;
	}

	/**
	 * Show all other icons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_OtherIcons() {
		StOpaqueImage[] icons = new StOpaqueImage[] { JunOpaqueImageIcons.Other16x16(), JunOpaqueImageIcons.Other32x32(), JunOpaqueImageIcons.Other64x64() };
		IconImages(icons)._display();
		return true;
	}

	/**
	 * Show all empty icons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_EmptyIcons() {
		StOpaqueImage[] icons = new StOpaqueImage[] { JunOpaqueImageIcons.Empty16x16(), JunOpaqueImageIcons.Empty32x32(), JunOpaqueImageIcons.Empty64x64() };
		IconImages(icons)._display();
		return true;
	}

	/**
	 * Show all triangle icons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_TriangleIcons() {
		StOpaqueImage[] icons = new StOpaqueImage[] { JunOpaqueImageIcons.Triangle16x16() };
		IconImages(icons)._display();
		return true;
	}

	/**
	 * Show all arrangement icons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_ArrangementIcons() {
		StOpaqueImage[] icons = new StOpaqueImage[] { JunOpaqueImageIcons.ConcentricArrangement32x32(), JunOpaqueImageIcons.OriginalArrangement32x32(), JunOpaqueImageIcons.TreeArrangement32x32() };
		IconImages(icons)._display();
		return true;
	}

	/**
	 * Show all dictionary icons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_DictionaryIcons() {
		StOpaqueImage[] icons = new StOpaqueImage[] { JunOpaqueImageIcons.DictionaryBlack32x32(), JunOpaqueImageIcons.DictionaryWhite32x32() };
		IconImages(icons)._display();
		return true;
	}

	/**
	 * Show all pencil icons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_PencilIcons() {
		StOpaqueImage[] icons = new StOpaqueImage[] { JunOpaqueImageIcons.PencilBold32x32(), JunOpaqueImageIcons.PencilBlack32x32(), JunOpaqueImageIcons.PencilWhite32x32() };
		IconImages(icons)._display();
		return true;
	}

	/**
	 * Show all operation icons.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_OperationIcons() {
		StOpaqueImage[] icons = new StOpaqueImage[] { JunOpaqueImageIcons.Freehand32x32(), JunOpaqueImageIcons.TextAcceptOK32x32(), JunOpaqueImageIcons.TextAcceptThumbUp32x32() };
		IconImages(icons)._display();
		return true;
	}

	/**
	 * Execute all test examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpaqueImageIconsTestExamples();
	}

	/**
	 * Create icons images.
	 * 
	 * @param icons jp.co.sra.smalltalk.StOpqaueImage[]
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Examples
	 */
	protected static StImage IconImages(StOpaqueImage[] icons) {
		int gap = 10;
		int width = gap;
		int height = 0;
		for (int i = 0; i < icons.length; i++) {
			width = width + icons[i].asImage().width() + gap;
			height = Math.max(height, icons[i].asImage().height());
		}
		height = height + gap * 2;

		StImage anImage = new StImage(width, height);
		Graphics aGraphics = null;
		try {
			aGraphics = anImage.image().getGraphics();
			aGraphics.setColor(Color.pink);
			aGraphics.fillRect(0, 0, anImage.width(), anImage.height());

			int x = gap;
			for (int i = 0; i < icons.length; i++) {
				icons[i].asImage().displayOn_at_(aGraphics, new Point(x, gap));
				x = x + icons[i].asImage().width() + gap;
			}
			anImage.image().flush();
		} finally {
			if (aGraphics != null) {
				aGraphics.dispose();
				aGraphics = null;
			}
		}

		return anImage;
	}

}