package jp.co.sra.jun.goodies.gauge;

import java.awt.Dimension;

import javax.swing.JLabel;
import javax.swing.SwingConstants;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.track.JunSimpleSliderViewSwing;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunSimpleGaugeViewSwing class
 * 
 *  @author    Hoshi Takanori
 *  @created   2003/08/28 (by Hoshi Takanori)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun519 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSimpleGaugeViewSwing.java,v 8.10 2008/02/20 06:31:34 nisinaka Exp $
 */
public class JunSimpleGaugeViewSwing extends JunAbstractViewJPanel implements JunSimpleGaugeView {

	protected JLabel valueView;
	protected JunSimpleSliderViewSwing sliderView;

	/**
	 * Create a new instance of JunSimpleGaugeViewSwing and initialize it.
	 *
	 * @param aSimpleGaugeModel jp.co.sra.jun.goodies.gauge.JunSimpleGaugeViewSwing
	 */
	public JunSimpleGaugeViewSwing(JunSimpleGaugeModel aSimpleGaugeModel) {
		super(aSimpleGaugeModel);
	}

	/**
	 * Answer my model as JunSimpleGaugeModel.
	 *
	 * @return jp.co.sra.jun.goodies.gauge.JunSimpleGaugeModel
	 */
	public JunSimpleGaugeModel getSimpleGaugeModel() {
		return (JunSimpleGaugeModel) this.model();
	}

	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.valueView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -20));
		this.add(this.sliderView(), WindowSpecLayout.Position(0f, 1, 1f, -19, 1f, -1, 1f, -1));
		this.setPreferredSize(new Dimension(124, 45));

		// postBuildWith:
		this.updateValueView();
	}

	/**
	 * Answer the slider view.
	 *
	 * @return jp.co.sra.jun.goodies.track.JunSimpleSliderViewSwing
	 */
	protected JunSimpleSliderViewSwing sliderView() {
		if (sliderView == null) {
			sliderView = new JunSimpleSliderViewSwing(this.getSimpleGaugeModel().simpleSlider());
		}
		return sliderView;
	}

	/**
	 * Answer the value view.
	 *
	 * @return javax.swing.JLabel
	 */
	protected JLabel valueView() {
		if (valueView == null) {
			valueView = new JLabel();
			valueView.setHorizontalAlignment(SwingConstants.CENTER);
		}
		return valueView;
	}

	/**
	 * Action for the update notification.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (this.isShowing() == false) {
			return;
		}

		StSymbol aSymbol = evt.getAspect();
		if (aSymbol == $("value")) {
			this.updateValueView();
		} else {
			super.update_(evt);
		}
	}

	/**
	 * Update the value view.
	 */
	public void updateValueView() {
		this.valueView().setText(this.getSimpleGaugeModel().valueString());
	}
}
