package jp.co.sra.jun.goodies.gauge;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunGaugeDialogTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/04/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun492 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGaugeDialogTestExamples.java,v 8.10 2008/02/20 06:31:34 nisinaka Exp $
 */
public class JunGaugeDialogTestExamples extends JunTestExamples {

	/**
	 * Example1: Request a value with JunGaugeDialog.
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		Object value = JunGaugeDialog.Request();
		System.out.println(value);

		return true;
	}

	/**
	 * Example2: Request a value with JunGaugeDialog.
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		Object value = JunGaugeDialog.Request(JunSystem.$String("Select a value."));
		System.out.println(value);

		return true;
	}

	/**
	 * Example3: Request a value with JunGaugeDialog.
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		Object value = JunGaugeDialog.Request(JunSystem.$String("Select a value."), 50);
		System.out.println(value);

		return true;
	}

	/**
	 * Example4: Request a value with JunGaugeDialog.
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		Object value = JunGaugeDialog.Request(JunSystem.$String("Select a value."), 33, 0, 100, 1);
		System.out.println(value);

		return true;
	}

	/**
	 * Example5: Request a value with JunGaugeDialog.
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		Object value = JunGaugeDialog.Request(JunSystem.$String("Select a value."), new JunGaugeModel(33, 0, 100, 1), new StBlockClosure() {
			public Object value_(Object model) {
				System.out.println(JunSystem.$String("Accept button was pressed."));
				System.out.println("\t" + ((JunGaugeModel) model).value());
				return Boolean.TRUE;
			}
		}, new StBlockClosure() {
			public Object value_(Object model) {
				System.out.println(JunSystem.$String("Cancel button was pressed."));
				System.out.println("\t" + ((JunGaugeModel) model).value());
				return Boolean.TRUE;
			}
		});
		System.out.println(value);

		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunGaugeDialogTestExamples();
	}

}
