package jp.co.sra.jun.goodies.gauge;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.system.framework.JunAbstractController;

/**
 * JunGaugeController class
 * 
 *  @author    nisinaka
 *  @created   2004/04/13 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGaugeController.java,v 8.10 2008/02/20 06:31:34 nisinaka Exp $
 */
public class JunGaugeController extends JunAbstractController {

	protected boolean _adjusting;

	/**
	 * Answer my view as JunGaugeView.
	 * 
	 * @return jp.co.sra.jun.goodies.gauge.JunGaugeView
	 * @category view accessing
	 */
	public JunGaugeView getGaugeView() {
		return (JunGaugeView) this.view();
	}

	/**
	 * Setup the listeners.
	 * 
	 * @param aView jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StController#buildListener(jp.co.sra.smalltalk.StView)
	 * @category user interface
	 */
	protected void buildListener(StView aView) {
		aView.toComponent().addMouseListener(this);
		aView.toComponent().addMouseMotionListener(this);
	}

	/**
	 * Invoked when a mouse button has been pressed on a component.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 * @category mouse listener
	 */
	public void mousePressed(MouseEvent event) {
		Point aPoint = event.getPoint();
		_adjusting = this.getGaugeView().gaugeBorder().containsPoint_(aPoint);
		if (_adjusting) {
			this.setValueAt(aPoint);
		}
	}

	/**
	 * Invoked when a mouse button has been released on a component.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 * @category mouse listener
	 */
	public void mouseReleased(MouseEvent event) {
		_adjusting = false;
	}

	/**
	 * Invoked when the mouse enters a component.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
	 * @category mouse listener
	 */
	public void mouseEntered(MouseEvent event) {
		this.setCursorAt(event.getPoint());
	}

	/**
	 * Invoked when the mouse cursor has been moved onto a component but no buttons have been pushed.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
	 * @category mouse motion listener
	 */
	public void mouseMoved(MouseEvent event) {
		this.setCursorAt(event.getPoint());
	}

	/**
	 * Invoked when a mouse button is pressed on a component and then dragged.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
	 * @category mouse motion listener
	 */
	public void mouseDragged(MouseEvent event) {
		this.setValueAt(event.getPoint());
		Thread.yield();
	}

	/**
	 * Set the mouse cursor for the specified point.
	 * 
	 * @param aPoint java.awt.Point
	 * @category private
	 */
	protected void setCursorAt(Point aPoint) {
		StRectangle box = this.getGaugeView().gaugeBorder();
		if (box.containsPoint_(aPoint)) {
			this.getGaugeView().toComponent().setCursor(JunCursors.CrossCursor());
		} else {
			this.getGaugeView().toComponent().setCursor(Cursor.getDefaultCursor());
		}
	}

	/**
	 * Set the value at the specified point.
	 * 
	 * @param aPoint java.awt.Point
	 * @category private
	 */
	protected void setValueAt(Point aPoint) {
		StRectangle box = this.getGaugeView().gaugeBorder();
		double value = aPoint.y - box.originY();
		value = 1 - value / box.height();
		this.getGaugeView().getGaugeModel().normalizedValue_(value);
	}

}
