package jp.co.sra.jun.goodies.freehand;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StRectangle;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunFreehandViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2002/07/08 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun634 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFreehandViewSwing.java,v 8.12 2008/02/20 06:31:34 nisinaka Exp $
 */
public class JunFreehandViewSwing extends JunAbstractViewJPanel implements JunFreehandView {

	/**
	 * Create a new instance of JunFreehandViewSwing and initialize it.
	 *
	 * @param aFreehandPage jp.co.sra.jun.goodies.freehand.JunFreehandPage
	 * @category Instance creation
	 */
	public JunFreehandViewSwing(JunFreehandPage aFreehandPage) {
		super(aFreehandPage);
	}

	/**
	 * Build this component.
	 * 
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setPreferredSize(new Dimension(300, 300));
		this.setBackground(Color.white);
	}

	/**
	 * Answer my model as JunFreehandPage.
	 * 
	 * @return jp.co.sra.jun.goodies.freehand.JunFreehandPage
	 * @see jp.co.sra.jun.goodies.freehand.JunFreehandView#getFreehandPage()
	 * @category model accessing
	 */
	public JunFreehandPage getFreehandPage() {
		return (JunFreehandPage) this.model();
	}

	/**
	 * Answer the model as a JunFreehandPage.
	 * 
	 * @return jp.co.sra.jun.goodies.freehand.JunFreehandPage
	 * @deprecated since Jun633, use getFreehandPage()
	 * @category model accessing
	 */
	public JunFreehandPage getModel() {
		return (JunFreehandPage) this.model();
	}

	/**
	 * Answer the default controller.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @category controller accessing
	 */
	protected StController defaultController() {
		return new JunFreehandController();
	}

	/**
	 * Display on the graphics.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	public void displayOn_(Graphics aGraphics) {
		if (this.isShowing() == false) {
			return;
		}

		Vector locusCollection = this.getFreehandPage().locusCollection();

		if (locusCollection.isEmpty()) {
			return;
		}

		Vector scalarCollection = this.getFreehandPage().scalarCollection();
		Vector nibCollection = this.getFreehandPage().nibCollection();
		Rectangle bounds = this.getBounds();
		Point originPoint = new Point(bounds.x + (bounds.width / 2), bounds.y + (bounds.height / 2));

		for (int index = 0; index < this.getFreehandPage().currentIndex(); index++) {
			Jun3dPoint[] normalizedPoints = (Jun3dPoint[]) locusCollection.get(index);
			Jun3dPoint scalar = (Jun3dPoint) scalarCollection.get(index);
			Object[] nib = (Object[]) nibCollection.get(index);
			Color color = (Color) nib[0];
			float dot = ((Number) nib[1]).floatValue();
			((Graphics2D) aGraphics).setPaint(color);
			((Graphics2D) aGraphics).setStroke(this.getFreehandPage()._stroke(dot));

			Point[] points = new Point[normalizedPoints.length];

			for (int i = 0; i < points.length; i++) {
				int x = (int) Math.round(normalizedPoints[i].x() * scalar.x());
				int y = (int) Math.round(normalizedPoints[i].y() * scalar.y());
				points[i] = new Point(originPoint.x + x, originPoint.y - y);
			}

			Point fp = points[0], lp = points[points.length - 1];
			this.getFreehandPage()._drawDotbox(aGraphics, (new StRectangle(fp.x, fp.y, fp.x + 1, fp.y + 1)).expandedBy_((int) Math.max(dot / 2, 0)));
			this.getFreehandPage()._drawPolyline(aGraphics, points);
			this.getFreehandPage()._drawDotbox(aGraphics, (new StRectangle(lp.x, lp.y, lp.x + 1, lp.y + 1)).expandedBy_((int) Math.max(dot / 2, 0)));
		}
	}

}
