package jp.co.sra.jun.goodies.font;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

import jp.co.sra.smalltalk.StSimpleDialogViewSwing;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunFontDialogViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2003/02/28 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun433 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFontDialogViewSwing.java,v 8.11 2008/02/20 06:31:33 nisinaka Exp $
 */
public class JunFontDialogViewSwing extends StSimpleDialogViewSwing implements JunFontDialogView {

	protected JunFontViewSwing fontView;
	protected JButton acceptButton;
	protected JButton cancelButton;

	/**
	 * Create a new instance of JunFontDialogViewSwing and initialize it with the JunFontDialog.
	 *
	 * @param newFontDialog jp.co.sra.jun.goodies.font.JunFontDialog
	 * @category Instance creation
	 */
	public JunFontDialogViewSwing(JunFontDialog newFontDialog) {
		super(newFontDialog);
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.fontView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -50));
		this.add(this.acceptButton(), WindowSpecLayout.Position(0.3f, -44, 1f, -40, 0.3f, 44, 1f, -8));
		this.add(this.cancelButton(), WindowSpecLayout.Position(0.7f, -44, 1f, -40, 0.7f, 44, 1f, -8));
		this.setPreferredSize(new Dimension(350, 250));

		defaultButton = this.acceptButton();
	}

	/**
	 * Answer my model as a JunFontDialog.
	 *
	 * @return jp.co.sra.jun.goodies.font.JunFontDialog
	 * @see jp.co.sra.jun.goodies.font.JunFontDialogView#getFontDialog()
	 * @category model accessing
	 */
	public JunFontDialog getFontDialog() {
		return (JunFontDialog) this.model();
	}

	/**
	 * Answer my font view.
	 *
	 * @return jp.co.sra.jun.goodies.font.JunFontViewSwing
	 * @category user interface
	 */
	protected JunFontViewSwing fontView() {
		if (fontView == null) {
			fontView = new JunFontViewSwing(this.getFontDialog().fontModel());
		}
		return fontView;
	}

	/**
	 * Answer my accpet button.
	 *
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton acceptButton() {
		if (acceptButton == null) {
			acceptButton = new JButton(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getFontDialog().acceptButtonPressed()) {
						getFontDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton cancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getFontDialog().cancelButtonPressed()) {
						getFontDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

}
