package jp.co.sra.jun.goodies.files;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

import jp.co.sra.smalltalk.StSimpleDialogViewSwing;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunFileDialogViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2003/03/12 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun433 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFileDialogViewSwing.java,v 8.11 2008/02/20 06:31:33 nisinaka Exp $
 */
public class JunFileDialogViewSwing extends StSimpleDialogViewSwing implements JunFileDialogView {

	protected JunFileViewSwing fileView;
	protected JButton acceptButton;
	protected JButton cancelButton;

	/**
	 * Create a new instance of JunFileDialogViewSwing and initialize it.
	 *
	 * @param aFileDialog jp.co.sra.jun.goodies.files.JunFileDialog
	 * @category Instance creation
	 */
	public JunFileDialogViewSwing(JunFileDialog aFileDialog) {
		super(aFileDialog);
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.fileView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -97, 1f, -1));
		this.add(this.acceptButton(), WindowSpecLayout.Position(1f, -96, 0f, 16, 1f, -8, 0f, 48));
		this.add(this.cancelButton(), WindowSpecLayout.Position(1f, -96, 0f, 56, 1f, -8, 0f, 88));
		this.setPreferredSize(new Dimension(540, 300));

		defaultButton = this.acceptButton();
	}

	/**
	 * Answer my model as JunFileDialog.
	 *
	 * @return jp.co.sra.jun.goodies.files.JunFileDialog
	 * @see jp.co.sra.jun.goodies.files.JunFileDialogView#getFileDialog()
	 * @category model accessing
	 */
	public JunFileDialog getFileDialog() {
		return (JunFileDialog) this.model();
	}

	/**
	 * Answer my file view.
	 *
	 * @return jp.co.sra.jun.goodies.files.JunFileViewSwing
	 * @category user interface
	 */
	protected JunFileViewSwing fileView() {
		if (fileView == null) {
			fileView = new JunFileViewSwing(this.getFileDialog().fileModel());
		}
		return fileView;
	}

	/**
	 * Answer my accept button.
	 *
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton acceptButton() {
		if (acceptButton == null) {
			acceptButton = new JButton(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getFileDialog().acceptButtonPressed()) {
						getFileDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton cancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getFileDialog().cancelButtonPressed()) {
						getFileDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

}
