package jp.co.sra.jun.goodies.dump;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.TextArea;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunDumpViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2003/03/18 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun436 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDumpViewAwt.java,v 8.12 2008/02/20 06:31:33 nisinaka Exp $
 */
public class JunDumpViewAwt extends JunAbstractViewPanel implements JunDumpView {
	protected TextArea textView;

	/**
	 * Create a new instance of <code>JunDumpViewAwt</code> and initialize it.
	 *
	 * @param aDumpModel jp.co.sra.jun.goodies.dump.JunDumpModel
	 * @category Instance creation
	 */
	public JunDumpViewAwt(JunDumpModel aDumpModel) {
		super(aDumpModel);
	}

	/**
	 * Answer my model as <code>JunDumpModel</code>.
	 *
	 * @return jp.co.sra.jun.goodies.dump.JunDumpModel
	 * @see jp.co.sra.jun.goodies.dump.JunDumpView#getDumpModel()
	 * @category model accessing
	 */
	public JunDumpModel getDumpModel() {
		return (JunDumpModel) this.model();
	}

	/**
	 * Answer my text view.
	 *
	 * @return java.awt.TextArea
	 * @category interface opening
	 */
	public TextArea textView() {
		if (textView == null) {
			textView = new TextArea((String) this.getDumpModel().textModel().value()) {
				public Dimension getPreferredSize() {
					return new Dimension(520, 250);
				}
			};
		}
		return textView;
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new BorderLayout());
		this.add(this.textView(), BorderLayout.CENTER);
	}
}
