package jp.co.sra.jun.goodies.drawing.properties;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.goodies.drawing.element.JunTextboxElement;

/**
 * JunTextboxPropertiesModel class
 * 
 *  @author    m-asada
 *  @created   2005/05/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTextboxPropertiesModel.java,v 8.10 2008/02/20 06:31:24 nisinaka Exp $
 */
public class JunTextboxPropertiesModel extends JunDrawingElementPropertiesModel {
	protected JunTextPropertiesModel textPropertiesModel;
	protected JunRectangularShapePropertiesModel borderPropertiesModel;

	/**
	 * Create a new instance of <code>JunTextboxPropertiesModel</code> and initialize it.
	 * 
	 * @param textboxElement jp.co.sra.jun.goodies.drawing.element.JunTextboxElement
	 * @category Instance creation
	 */
	public JunTextboxPropertiesModel(JunTextboxElement textboxElement) {
		super(textboxElement);
	}

	/**
	 * Initialize the ApplicationModel when created.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		textPropertiesModel = null;
		borderPropertiesModel = null;
	}

	/**
	 * Release the resources of the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StObject#release()
	 * @category initialize-release
	 */
	public void release() {
		super.release();

		this.textPropertiesModel().release();
		this.borderPropertiesModel().release();
	}

	/**
	 * Answer the receiver's textbox element.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.element.JunTextboxElement
	 * @category accessing
	 */
	public JunTextboxElement textboxElement() {
		return (JunTextboxElement) this.drawingElement();
	}

	/**
	 * Answer the receiver's text properties model.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.properties.JunTextPropertiesModel
	 * @category aspects
	 */
	public JunTextPropertiesModel textPropertiesModel() {
		if (textPropertiesModel == null) {
			textPropertiesModel = new JunTextPropertiesModel(this.textboxElement().textElement());
		}
		return textPropertiesModel;
	}

	/**
	 * Answer the receiver's border properties model.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.properties.JunRectangularShapePropertiesModel
	 * @category aspects
	 */
	public JunRectangularShapePropertiesModel borderPropertiesModel() {
		if (borderPropertiesModel == null) {
			borderPropertiesModel = new JunRectangularShapePropertiesModel(this.textboxElement().borderElement()) {
				public void update_(DependentEvent event) {
					if (event.getAspect() == $("value")) {
						JunTextboxPropertiesModel.this.updateLineWidth();
					}
				}
			};
		}
		return borderPropertiesModel;
	}

	/**
	 * Answer the default view of the model.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunTextboxPropertiesViewAwt(this);
		} else {
			return new JunTextboxPropertiesViewSwing(this);
		}
	}

	/**
	 * Answer a view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#getView()
	 * @category view accessing
	 */
	public StView getView() {
		Object[] dependents = this.dependents();
		for (int i = 0; i < dependents.length; i++) {
			if (dependents[i] instanceof JunTextPropertiesView && ((JunTextboxPropertiesView) dependents[i]).model() == this) {
				return (JunTextboxPropertiesView) dependents[i];
			}
		}
		return null;
	}

	/**
	 * Answer the view as JunTextPropertiesView.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.properties.JunTextboxPropertiesView
	 * @category view accessing
	 */
	public JunTextboxPropertiesView getTextboxPropertiesView() {
		return (JunTextboxPropertiesView) this.getView();
	}

	/**
	 * Get the text.
	 * 
	 * @return java.lang.String
	 * @category accessing
	 */
	public String text() {
		return this.textboxElement().text();
	}

	/**
	 * Called when the line width is changed.
	 * 
	 * @category updating
	 */
	protected void updateLineWidth() {
		int value = (int) this.borderPropertiesModel().lineWidthParameterModel().parameter().value();
		if (this.textboxElement().lineWidth() != value) {
			this.textboxElement().lineWidth_(value);
			this.textboxElement().map().changed_with_($("redisplay"), this.textboxElement().bounds());
			this.changed_($("lineWidth"));
		}
	}
}
