package jp.co.sra.jun.goodies.drawing.properties;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.goodies.colors.JunColorChoiceViewSwing;
import jp.co.sra.jun.goodies.parameter.JunParameterViewSwing;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunRectangularShapePropertiesViewSwing class
 * 
 *  @author    m-asada
 *  @created   2005/05/23 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunRectangularShapePropertiesViewSwing.java,v 8.10 2008/02/20 06:31:24 nisinaka Exp $
 */
public class JunRectangularShapePropertiesViewSwing extends JunAbstractViewJPanel implements JunRectangularShapePropertiesView {
	protected JunColorChoiceViewSwing foregroundColorChoiceView;
	protected JunColorChoiceViewSwing backgroundColorChoiceView;
	protected JunParameterViewSwing lineWidthParameterView;
	protected JCheckBox fillView;

	/**
	 * Create a new instance of <code>JunRectangularShapePropertiesViewSwing</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunRectangularShapePropertiesViewSwing() {
		super();
	}

	/**
	 * Create a new instance of <code>JunRectangularShapePropertiesViewSwing</code> and initialize it.
	 * 
	 * @param newModel jp.co.sra.jun.goodies.drawing.properties.JunRectangularShapePropertiesModel
	 * @category Instance creation
	 */
	public JunRectangularShapePropertiesViewSwing(JunRectangularShapePropertiesModel newModel) {
		super(newModel);
	}

	/**
	 * Answer the model as JunRectangularShapePropertiesModel.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.properties.JunRectangularShapePropertiesModel
	 * @see jp.co.sra.jun.goodies.drawing.properties.JunRectangularShapePropertiesView#getModel()
	 * @category model accessing
	 */
	public JunRectangularShapePropertiesModel getModel() {
		return (JunRectangularShapePropertiesModel) this.model();
	}

	/**
	 * Initialize the JunRectangularShapePropertiesViewAwt.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		foregroundColorChoiceView = null;
		backgroundColorChoiceView = null;
		lineWidthParameterView = null;
		fillView = null;
	}

	/**
	 * Release the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StView#release()
	 * @category initialize-release
	 */
	public void release() {
		super.release();

		this.foregroundColorChoiceView().release();
		this.backgroundColorChoiceView().release();
		this.lineWidthParameterView().release();
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());

		JLabel label = new JLabel(JunSystem.$String("Border color") + " :");
		label.setFont(this.font());
		this.add(label, WindowSpecLayout.Position(0f, 0, 0f, 0, 0f, 120, 0f, 30));
		this.add(this.foregroundColorChoiceView(), WindowSpecLayout.Position(0f, 121, 0f, 0, 1f, 0, 0f, 123));
		this.add(this.lineWidthParameterView(), WindowSpecLayout.Position(0f, 0, 0f, 124, 0f, 339, 0f, 165));

		this.add(this.fillView(), WindowSpecLayout.Position(0f, 0, 0f, 180, 0f, 325, 0f, 195));
		JLabel label2 = new JLabel(JunSystem.$String("Background color") + " :");
		label2.setFont(this.font());
		this.add(label2, WindowSpecLayout.Position(0f, 0, 0f, 196, 0f, 120, 0f, 196 + 30));
		this.add(this.backgroundColorChoiceView(), WindowSpecLayout.Position(0f, 121, 0f, 196, 1f, 0, 0f, 196 + 123));

		this.setPreferredSize(new Dimension(340, 320));
	}

	/**
	 * Answer the receiver's foreground color choice view.
	 *
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceViewSwing
	 * @category interface opening
	 */
	public JunColorChoiceViewSwing foregroundColorChoiceView() {
		if (foregroundColorChoiceView == null) {
			foregroundColorChoiceView = new JunColorChoiceViewSwing(this.getModel().foregroundColorChoiceModel());
		}
		return foregroundColorChoiceView;
	}

	/**
	 * Answer the receiver's background color choice view.
	 *
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceViewSwing
	 * @category interface opening
	 */
	public JunColorChoiceViewSwing backgroundColorChoiceView() {
		if (backgroundColorChoiceView == null) {
			backgroundColorChoiceView = new JunColorChoiceViewSwing(this.getModel().backgroundColorChoiceModel());
		}
		return backgroundColorChoiceView;
	}

	/**
	 * Answer the receiver's line width view.
	 *
	 * @return jp.co.sra.jun.goodies.parameter.JunParameterViewSwing
	 * @category interface opening
	 */
	public JunParameterViewSwing lineWidthParameterView() {
		if (lineWidthParameterView == null) {
			lineWidthParameterView = new JunParameterViewSwing(this.getModel().lineWidthParameterModel());
		}
		return lineWidthParameterView;
	}

	/**
	 * Answer the receiver's fill view.
	 *
	 * @return javax.swing.JCheckBox
	 * @category interface opening
	 */
	public JCheckBox fillView() {
		if (fillView == null) {
			final JunRectangularShapePropertiesModel theModel = this.getModel();
			fillView = new JCheckBox(JunSystem.$String("Fill?"), theModel.isFill());
			fillView.setFont(this.font());
			fillView.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					if (fillView.isSelected() != theModel.isFill()) {
						theModel.fill_(fillView.isSelected());
						theModel.updateFill();
					}
				}
			});
		}
		return fillView;
	}

	/**
	 * Answer the receiver's font.
	 * 
	 * @return java.awt.Font
	 * @category fonts
	 */
	protected Font font() {
		return new Font("dialog", Font.BOLD, 12);
	}
}
