package jp.co.sra.jun.goodies.drawing.properties;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.goodies.drawing.element.JunPathElement;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunPathPropertiesViewAwt class
 * 
 *  @author    m-asada
 *  @created   2005/05/23 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPathPropertiesViewAwt.java,v 8.10 2008/02/20 06:31:24 nisinaka Exp $
 */
public class JunPathPropertiesViewAwt extends JunVertexesPropertiesViewAwt implements JunPathPropertiesView {
	protected CheckboxGroup beginArrowStyle;
	protected Checkbox beginArrowStyleSquare;
	protected Checkbox beginArrowStyleArrow;
	protected Checkbox beginArrowStyleDiamond;
	protected Checkbox beginArrowStyleCircle;
	protected CheckboxGroup endArrowStyle;
	protected Checkbox endArrowStyleSquare;
	protected Checkbox endArrowStyleArrow;
	protected Checkbox endArrowStyleDiamond;
	protected Checkbox endArrowStyleCircle;

	/**
	 * Create a new instance of <code>JunPathPropertiesViewAwt</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunPathPropertiesViewAwt() {
		super();
	}

	/**
	 * Create a new instance of <code>JunPathPropertiesViewAwt</code> and initialize it.
	 * 
	 * @param newModel jp.co.sra.jun.goodies.drawing.properties.JunPathPropertiesModel
	 * @category Instance creation
	 */
	public JunPathPropertiesViewAwt(JunPathPropertiesModel newModel) {
		super(newModel);
	}

	/**
	 * Answer the model as JunPathPropertiesModel.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.properties.JunPathPropertiesModel
	 * @see jp.co.sra.jun.goodies.drawing.properties.JunPathPropertiesView#getPathModel()
	 * @category model accessing
	 */
	public JunPathPropertiesModel getPathModel() {
		return (JunPathPropertiesModel) this.model();
	}

	/**
	 * Initialize the JunRectangularShapePropertiesViewAwt.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		beginArrowStyle = null;
		beginArrowStyleSquare = null;
		beginArrowStyleArrow = null;
		beginArrowStyleDiamond = null;
		beginArrowStyleCircle = null;
		endArrowStyle = null;
		endArrowStyleSquare = null;
		endArrowStyleArrow = null;
		endArrowStyleDiamond = null;
		endArrowStyleCircle = null;
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());

		Label label = new Label(JunSystem.$String("Line color") + " :");
		label.setFont(this.font());
		this.add(label, WindowSpecLayout.Position(0f, 0, 0f, 0, 0f, 70, 0f, 30));
		this.add(this.foregroundColorChoiceView(), WindowSpecLayout.Position(0f, 71, 0f, 0, 1f, 0, 0f, 123));
		this.add(this.lineWidthParameterView(), WindowSpecLayout.Position(0f, 0, 0f, 124, 0f, 289, 0f, 165));

		int lineHeight = this.getFontMetrics(this.font()).getHeight() + 4;
		label = new Label(JunSystem.$String("Begin style") + " :");
		label.setFont(this.font());
		this.add(label, WindowSpecLayout.Position(0f, 1, 0f, 173, 0.5f, -1, 0f, 173 + lineHeight));
		this.add(this.beginStyleSquare(),  WindowSpecLayout.Position(0f, 20, 0f, 173 + lineHeight, 0.5f, -1, 0f, 173 + lineHeight * 2));
		this.add(this.beginStyleArrow(),   WindowSpecLayout.Position(0f, 20, 0f, 173 + lineHeight * 2, 0.5f, -1, 0f, 173 + lineHeight * 3));
		this.add(this.beginStyleDiamond(), WindowSpecLayout.Position(0f, 20, 0f, 173 + lineHeight * 3, 0.5f, -1, 0f, 173 + lineHeight * 4));
		this.add(this.beginStyleCircle(),  WindowSpecLayout.Position(0f, 20, 0f, 173 + lineHeight * 4, 0.5f, -1, 0f, 173 + lineHeight * 5));

		label = new Label(JunSystem.$String("End style") + " :");
		label.setFont(this.font());
		this.add(label, WindowSpecLayout.Position(0.5f, 1, 0f, 173, 1f, 0, 0f, 173 + lineHeight));
		this.add(this.endStyleSquare(), WindowSpecLayout.Position(0.5f, 20, 0f, 173 + lineHeight, 1f, 0, 0f, 173 + lineHeight * 2));
		this.add(this.endStyleArrow(), WindowSpecLayout.Position(0.5f, 20, 0f, 173 + lineHeight * 2, 1f, 0, 0f, 173 + lineHeight * 3));
		this.add(this.endStyleDiamond(), WindowSpecLayout.Position(0.5f, 20, 0f, 173 + lineHeight * 3, 1f, 0, 0f, 173 + lineHeight * 4));
		this.add(this.endStyleCircle(), WindowSpecLayout.Position(0.5f, 20, 0f, 173 + lineHeight * 4, 1f, 0, 0f, 173 + lineHeight * 5));

		this.setSize(new Dimension(290, 173 + lineHeight * 5 + 5));
	}

	/**
	 * Answer the checkbox group of the begin style.
	 *
	 * @return java.awt.CheckboxGroup
	 * @category interface opening
	 */
	public CheckboxGroup beginStyle() {
		if (beginArrowStyle == null) {
			beginArrowStyle = new CheckboxGroup();
		}
		return beginArrowStyle;
	}

	/**
	 * Answer the checkbox for the begin style as Square.
	 *
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox beginStyleSquare() {
		if (beginArrowStyleSquare == null) {
			beginArrowStyleSquare = new Checkbox(JunSystem.$String("Square"), this.beginStyle(), this.getPathModel().pathElement().beginStyle() == JunPathElement.ARROW_STYLE_SQUARE);
			beginArrowStyleSquare.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewAwt.this.getPathModel().updateBeginStyle_(JunPathElement.ARROW_STYLE_SQUARE);
				}
			});
		}
		return beginArrowStyleSquare;
	}

	/**
	 * Answer the checkbox for the begin style as Arrow.
	 *
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox beginStyleArrow() {
		if (beginArrowStyleArrow == null) {
			beginArrowStyleArrow = new Checkbox(JunSystem.$String("Arrow"), this.beginStyle(), this.getPathModel().pathElement().beginStyle() == JunPathElement.ARROW_STYLE_ARROW);
			beginArrowStyleArrow.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewAwt.this.getPathModel().updateBeginStyle_(JunPathElement.ARROW_STYLE_ARROW);
				}
			});
		}
		return beginArrowStyleArrow;
	}

	/**
	 * Answer the checkbox for the begin style as Diamond.
	 *
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox beginStyleDiamond() {
		if (beginArrowStyleDiamond == null) {
			beginArrowStyleDiamond = new Checkbox(JunSystem.$String("Diamond"), this.beginStyle(), this.getPathModel().pathElement().beginStyle() == JunPathElement.ARROW_STYLE_DIAMOND);
			beginArrowStyleDiamond.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewAwt.this.getPathModel().updateBeginStyle_(JunPathElement.ARROW_STYLE_DIAMOND);
				}
			});
		}
		return beginArrowStyleDiamond;
	}

	/**
	 * Answer the checkbox for the begin style as Circle.
	 *
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox beginStyleCircle() {
		if (beginArrowStyleCircle == null) {
			beginArrowStyleCircle = new Checkbox(JunSystem.$String("Circle"), this.beginStyle(), this.getPathModel().pathElement().beginStyle() == JunPathElement.ARROW_STYLE_CIRCLE);
			beginArrowStyleCircle.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewAwt.this.getPathModel().updateBeginStyle_(JunPathElement.ARROW_STYLE_CIRCLE);
				}
			});
		}
		return beginArrowStyleCircle;
	}

	/**
	 * Answer the checkbox group of the end style.
	 *
	 * @return java.awt.CheckboxGroup
	 * @category interface opening
	 */
	public CheckboxGroup endStyle() {
		if (endArrowStyle == null) {
			endArrowStyle = new CheckboxGroup();
		}
		return endArrowStyle;
	}

	/**
	 * Answer the checkbox for the end style as Square.
	 *
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox endStyleSquare() {
		if (endArrowStyleSquare == null) {
			endArrowStyleSquare = new Checkbox(JunSystem.$String("Square"), this.endStyle(), this.getPathModel().pathElement().endStyle() == JunPathElement.ARROW_STYLE_SQUARE);
			endArrowStyleSquare.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewAwt.this.getPathModel().updateEndStyle_(JunPathElement.ARROW_STYLE_SQUARE);
				}
			});
		}
		return endArrowStyleSquare;
	}

	/**
	 * Answer the checkbox for the end style as Arrow.
	 *
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox endStyleArrow() {
		if (endArrowStyleArrow == null) {
			endArrowStyleArrow = new Checkbox(JunSystem.$String("Arrow"), this.endStyle(), this.getPathModel().pathElement().endStyle() == JunPathElement.ARROW_STYLE_ARROW);
			endArrowStyleArrow.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewAwt.this.getPathModel().updateEndStyle_(JunPathElement.ARROW_STYLE_ARROW);
				}
			});
		}
		return endArrowStyleArrow;
	}

	/**
	 * Answer the checkbox for the end style as Diamond.
	 *
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox endStyleDiamond() {
		if (endArrowStyleDiamond == null) {
			endArrowStyleDiamond = new Checkbox(JunSystem.$String("Diamond"), this.endStyle(), this.getPathModel().pathElement().endStyle() == JunPathElement.ARROW_STYLE_DIAMOND);
			endArrowStyleDiamond.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewAwt.this.getPathModel().updateEndStyle_(JunPathElement.ARROW_STYLE_DIAMOND);
				}
			});
		}
		return endArrowStyleDiamond;
	}

	/**
	 * Answer the checkbox for the end style as Diamond.
	 *
	 * @return java.awt.Checkbox
	 * @category interface opening
	 */
	public Checkbox endStyleCircle() {
		if (endArrowStyleCircle == null) {
			endArrowStyleCircle = new Checkbox(JunSystem.$String("Circle"), this.endStyle(), this.getPathModel().pathElement().endStyle() == JunPathElement.ARROW_STYLE_CIRCLE);
			endArrowStyleCircle.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					JunPathPropertiesViewAwt.this.getPathModel().updateEndStyle_(JunPathElement.ARROW_STYLE_CIRCLE);
				}
			});
		}
		return endArrowStyleCircle;
	}

	/**
	 * Answer the receiver's font.
	 * 
	 * @return java.awt.Font
	 * @category fonts
	 */
	protected Font font() {
		return new Font("dialog", Font.BOLD, 12);
	}

	/**
	 * Update the receiver according to the change notification from the model.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		if (this.isShowing() == false) {
			return;
		}

		StSymbol aSymbol = evt.getAspect();
		if (aSymbol == $("beginStyle")) {
			switch (this.getPathModel().pathElement().beginStyle()) {
				case JunPathElement.ARROW_STYLE_SQUARE:
					if (this.beginStyleSquare().getState() == false) {
						this.beginStyleSquare().setState(true);
					}
					break;
				case JunPathElement.ARROW_STYLE_ARROW:
					if (this.beginStyleArrow().getState() == false) {
						this.beginStyleArrow().setState(true);
					}
					break;
				case JunPathElement.ARROW_STYLE_DIAMOND:
					if (this.beginStyleDiamond().getState() == false) {
						this.beginStyleDiamond().setState(true);
					}
					break;
				case JunPathElement.ARROW_STYLE_CIRCLE:
					if (this.beginStyleCircle().getState() == false) {
						this.beginStyleCircle().setState(true);
					}
					break;
			}
			return;
		}
		if (aSymbol == $("endStyle")) {
			switch (this.getPathModel().pathElement().endStyle()) {
				case JunPathElement.ARROW_STYLE_SQUARE:
					if (this.endStyleSquare().getState() == false) {
						this.endStyleSquare().setState(true);
					}
					break;
				case JunPathElement.ARROW_STYLE_ARROW:
					if (this.endStyleArrow().getState() == false) {
						this.endStyleArrow().setState(true);
					}
					break;
				case JunPathElement.ARROW_STYLE_DIAMOND:
					if (this.endStyleDiamond().getState() == false) {
						this.endStyleDiamond().setState(true);
					}
					break;
				case JunPathElement.ARROW_STYLE_CIRCLE:
					if (this.endStyleCircle().getState() == false) {
						this.endStyleCircle().setState(true);
					}
					break;
			}
			return;
		}

		super.update_(evt);
	}
}
