package jp.co.sra.jun.goodies.drawing.properties;

import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.goodies.drawing.element.JunPathElement;

/**
 * JunPathPropertiesModel class
 * 
 *  @author    m-asada
 *  @created   2005/05/23 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPathPropertiesModel.java,v 8.10 2008/02/20 06:31:24 nisinaka Exp $
 */
public class JunPathPropertiesModel extends JunVertexesPropertiesModel {
	/**
	 * Create a new instance of <code>JunPathPropertiesModel</code> and initialize it.
	 * 
	 * @param pathElement jp.co.sra.jun.goodies.drawing.element.JunPathElement
	 * @category Instance creation
	 */
	public JunPathPropertiesModel(JunPathElement pathElement) {
		super(pathElement);
	}

	/**
	 * Answer the receiver's path element.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.element.JunPathElement
	 * @category accessing
	 */
	public JunPathElement pathElement() {
		return (JunPathElement) this.drawingElement();
	}

	/**
	 * Answer the default view of the model.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunPathPropertiesViewAwt(this);
		} else {
			return new JunPathPropertiesViewSwing(this);
		}
	}

	/**
	 * Called when the begin style is changed.
	 * 
	 * @param aNumber int
	 * @category updating
	 */
	protected void updateBeginStyle_(int aNumber) {
		if (this.pathElement().beginStyle() != aNumber) {
			this.pathElement().beginStyle_(aNumber);
			this.pathElement().map().changed_with_($("redisplay"), this.pathElement().bounds());
			this.changed_($("beginStyle"));
		}
	}

	/**
	 * Called when the end style is changed.
	 * 
	 * @param aNumber int
	 * @category updating
	 */
	protected void updateEndStyle_(int aNumber) {
		if (this.pathElement().endStyle() != aNumber) {
			this.pathElement().endStyle_(aNumber);
			this.pathElement().map().changed_with_($("redisplay"), this.pathElement().bounds());
			this.changed_($("endStyle"));
		}
	}
}
