package jp.co.sra.jun.goodies.drawing.element;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import jp.co.sra.jun.goodies.lisp.JunLispList;

/**
 * JunRectangleElement class
 * 
 *  @author    m-asada
 *  @created   2005/03/01 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunRectangleElement.java,v 8.10 2008/02/20 06:31:23 nisinaka Exp $
 */
public class JunRectangleElement extends JunRectangularShapeElement {
	public static DataFlavor DataFlavor = new DataFlavor(JunRectangleElement.class, "JunRectangleElement");

	/**
	 * Create a new instance of JunRectangleElement and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunRectangleElement() {
		super();
	}

	/**
	 * Create a new instance of JunRectangleElement and initialize it.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Instance creation
	 */
	public JunRectangleElement(JunLispList aList) {
		super(aList);
	}

	/**
	 * Returns an array of DataFlavor objects indicating the flavors the data can be provided in. The array should be
	 * ordered according to preference for providing the data (from most richly descriptive to least descriptive).
	 * 
	 * @return java.awt.datatransfer.DataFlavor[]
	 * @see java.awt.datatransfer.Transferable#getTransferDataFlavors()
	 * @see jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual#getTransferDataFlavors()
	 * @category transfering
	 */
	public DataFlavor[] getTransferDataFlavors() {
		return new DataFlavor[] { JunRectangleElement.DataFlavor };
	}

	/**
	 * Answer the receiver's shape.
	 * 
	 * @return java.awt.Shape
	 * @see jp.co.sra.jun.goodies.drawing.element.JunRectangularShapeElement#shape()
	 * @category private
	 */
	protected Shape shape() {
		if (shape == null) {
			shape = new Rectangle(this.x() + this.lineWidth() / 2, this.y() + this.lineWidth() / 2, this.width() - this.lineWidth(), this.height() - this.lineWidth());
		}
		return shape;
	}
}
