package jp.co.sra.jun.goodies.drawing.element;

import jp.co.sra.jun.goodies.lisp.JunLispList;

/**
 * JunNodeElement class
 * 
 *  @author    m-asada
 *  @created   2005/03/01 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunNodeElement.java,v 8.10 2008/02/20 06:31:23 nisinaka Exp $
 */
public abstract class JunNodeElement extends JunDrawingElement {
	/**
	 * Create a new instance of JunNodeElement and initialize it.
	 *
	 * @category Instance creation
	 */
	public JunNodeElement() {
		super();
	}

	/**
	 * Create a new instance of JunNodeElement and initialize it.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Instance creation
	 */
	public JunNodeElement(JunLispList aList) {
		super(aList);
	}

	/**
	 * Answer true if receiver is node element, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual#isNode()
	 * @category testing
	 */
	public boolean isNode() {
		return true;
	}
}