package jp.co.sra.jun.goodies.cursors;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.goodies.progress.JunCursorAnimator;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCursorsTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2002/11/27 (by nisinaka)
 *  @updated   2007/04/12 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun699 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCursorsTestExamples.java,v 8.14 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunCursorsTestExamples extends JunTestExamples {

	/**
	 * Example1: show and restore
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunCursors cursor = new JunCursors(JunCursors.ClockCursor());
		try {
			// Set the cursor for all frames.
			cursor._show();

			// Do something while showing the cursor.
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			System.err.println(e.getMessage());
			e.printStackTrace();
			return false;
		} finally {
			// Restore the cursor for all frames.
			cursor._restore();
		}
		return true;
	}

	/**
	 * Example2: all cursors shows.
	 * 
	 * @return boolean
	 * @throws java.lang.reflect.InvocationTargetException 
	 * @throws java.lang.IllegalAccessException 
	 * @throws java.lang.IllegalArgumentException 
	 * @category Examples
	 */
	public static boolean Example2_AllCursorImages() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
		ArrayList images = new ArrayList();

		Method[] methods = JunCursors.class.getDeclaredMethods();
		for (int i = 0; i < methods.length; i++) {
			int modifiers = methods[i].getModifiers();
			if (Modifier.isStatic(modifiers) == false) {
				continue;
			}
			if (Modifier.isPublic(modifiers) == false) {
				continue;
			}
			if (methods[i].getReturnType() != BufferedImage.class) {
				continue;
			}
			if (methods[i].getParameterTypes().length > 0) {
				continue;
			}

			BufferedImage image = (BufferedImage) methods[i].invoke(null, (Object[]) null);
			images.add(image);
		}

		int size = images.size();
		int width = 10;
		int height = size / width + 1;
		StImage anImage = new StImage(JunCursors.WIDTH * width, JunCursors.HEIGHT * height);
		for (int i = 0; i < size; i++) {
			int y = i / width;
			int x = i % width;
			Rectangle bounds = new Rectangle(x * JunCursors.WIDTH, y * JunCursors.HEIGHT, JunCursors.WIDTH, JunCursors.HEIGHT);
			anImage.copy_from_in_rule_(bounds, new Point(0, 0), new StImage((BufferedImage) images.get(i)), StImage.Over);
		}
		anImage._display();

		return true;
	}

	/**
	 * Example3: all cursors shows.
	 * 
	 * @return boolean
	 * @throws java.lang.reflect.InvocationTargetException 
	 * @throws java.lang.IllegalAccessException 
	 * @throws java.lang.IllegalArgumentException 
	 * @category Examples
	 */
	public static boolean Example3() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
		ArrayList aCollection = new ArrayList();

		Method[] methods = JunCursors.class.getDeclaredMethods();
		for (int i = 0; i < methods.length; i++) {
			int modifiers = methods[i].getModifiers();
			if (Modifier.isStatic(modifiers) == false) {
				continue;
			}
			if (Modifier.isPublic(modifiers) == false) {
				continue;
			}
			if (methods[i].getReturnType() != Cursor.class) {
				continue;
			}
			if (methods[i].getParameterTypes().length > 0) {
				continue;
			}

			String cursorName = methods[i].getName();
			cursorName = cursorName.substring(0, cursorName.length() - "Cursor".length());
			Cursor aCursor = (Cursor) methods[i].invoke(null, (Object[]) null);
			aCollection.add(new Object[] { cursorName, aCursor });
		}

		Iterator iterator = aCollection.iterator();
		while (iterator.hasNext()) {
			Object[] objects = (Object[]) iterator.next();
			JunCursors cursor = new JunCursors((Cursor) objects[1]);
			try {
				cursor._show();
				System.out.println((String) objects[0]);
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				System.err.println(e.getMessage());
				e.printStackTrace();
				return false;
			} finally {
				cursor._restore();
			}

		}

		return true;
	}

	/**
	 * Example2: stop watch cursors shows.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleStopwatchCursors() {
		Collection cursorCollection = new ArrayList();
		Cursor[] stopwatchCursors = JunCursorAnimator.StopwatchCursors().cursors();
		cursorCollection.add(JunCursors.StopwatchCursor());
		cursorCollection.add(JunCursors.StopwatchPushCursor());
		cursorCollection.add(stopwatchCursors[1]);
		cursorCollection.add(stopwatchCursors[2]);
		cursorCollection.add(stopwatchCursors[3]);
		cursorCollection.add(stopwatchCursors[4]);
		cursorCollection.add(stopwatchCursors[5]);
		cursorCollection.add(stopwatchCursors[6]);
		cursorCollection.add(stopwatchCursors[7]);
		cursorCollection.add(JunCursors.StopwatchCursor());
		cursorCollection.add(stopwatchCursors[1]);
		cursorCollection.add(stopwatchCursors[2]);
		cursorCollection.add(stopwatchCursors[3]);
		cursorCollection.add(stopwatchCursors[4]);
		cursorCollection.add(stopwatchCursors[5]);
		cursorCollection.add(stopwatchCursors[6]);
		cursorCollection.add(stopwatchCursors[7]);
		cursorCollection.add(JunCursors.StopwatchPushCursor());
		cursorCollection.add(JunCursors.StopwatchCursor());
		cursorCollection.add(JunCursors.StopwatchMemoryCursor());
		cursorCollection.add(JunCursors.StopwatchCursor());
		cursorCollection.add(JunCursors.StopwatchPushCursor());
		cursorCollection.add(stopwatchCursors[1]);
		cursorCollection.add(stopwatchCursors[2]);
		cursorCollection.add(stopwatchCursors[3]);
		cursorCollection.add(stopwatchCursors[4]);
		cursorCollection.add(stopwatchCursors[5]);
		cursorCollection.add(stopwatchCursors[6]);
		cursorCollection.add(stopwatchCursors[7]);
		cursorCollection.add(JunCursors.StopwatchCursor());
		cursorCollection.add(stopwatchCursors[1]);
		cursorCollection.add(stopwatchCursors[2]);
		cursorCollection.add(stopwatchCursors[3]);
		cursorCollection.add(JunCursors.StopwatchPush4Cursor());
		cursorCollection.add(stopwatchCursors[4]);
		cursorCollection.add(JunCursors.StopwatchMemory4Cursor());
		cursorCollection.add(stopwatchCursors[4]);
		cursorCollection.add(JunCursors.StopwatchResetCursor());
		cursorCollection.add(JunCursors.StopwatchCursor());
		Cursor[] cursors = (Cursor[]) cursorCollection.toArray(new Cursor[cursorCollection.size()]);

		final JunCursorAnimator cursorAnimator = new JunCursorAnimator(cursors);
		cursorAnimator.tick_(300);
		cursorAnimator.showWhile_(new StBlockClosure() {
			public Object value() {
				JunControlUtility.HoldForMilliseconds_(cursorAnimator.tick() * (cursorAnimator.cursors().length * 2 + 1));
				return null;
			}
		});
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunCursorsTestExamples();
	}

}
