package jp.co.sra.jun.goodies.cursors;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.HashMap;

import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunCursors class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/11/24 (by MATSUDA Ryouichi)
 *  @updated   1999/08/04 (by nisinaka)
 *  @updated   2001/11/20 (by nisinaka)
 *  @updated   2002/04/04 (by nisinaka)
 *  @updated   2002/11/27 (by nisinaka)
 *  @updated   2003/03/04 (by nisinaka)
 *  @updated   2007/04/12 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun699 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCursors.java,v 8.15 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunCursors extends JunAbstractObject {

	public static final int WIDTH = 16;
	public static final int HEIGHT = 16;

	protected static final HashMap images = new HashMap();
	protected static final HashMap cursors = new HashMap();

	protected Cursor _cursor;
	protected Frame[] _frames = null;
	protected Cursor[] _savedCursors = null;

	/**
	 * Create a new instance of JunCursor.
	 *
	 * @param aCursor java.awt.Cursor
	 * @category Instance creation
	 */
	public JunCursors(Cursor aCursor) {
		_cursor = aCursor;
	}

	/**
	 * Create an image from the array of pixels.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @param pixels int[]
	 * @category Image utilities
	 */
	public static BufferedImage _CreateImage(int[] pixels) {
		BufferedImage image = new BufferedImage(WIDTH, HEIGHT, BufferedImage.TYPE_INT_ARGB);
		image.setRGB(0, 0, WIDTH, HEIGHT, pixels, 0, WIDTH);
		return image;
	}

	/**
	 * Create an array of pixels from an image string and a mask string.
	 * 
	 * @return int[]
	 * @param imageString java.lang.String
	 * @param maskString java.lang.String
	 * @category Image utilities
	 */
	public static int[] _Pixels(String imageString, String maskString) {
		int[] pixels = new int[WIDTH * HEIGHT];
		for (int i = 0; i < (WIDTH * HEIGHT); i++) {
			int pixel = 0x00FFFFFF;
			if (imageString.charAt(i) != '0') {
				pixel = Color.black.getRGB();
			} else if (maskString.charAt(i) != '0') {
				pixel = Color.white.getRGB();
			}
			pixels[i] = pixel;
		}
		return pixels;
	}

	/**
	 * Resize the image to fit as a cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @param anImage java.awt.image.BufferedImage
	 * @category Image utilities
	 */
	public static BufferedImage _ResizeToFit(BufferedImage anImage) {
		Dimension size = Toolkit.getDefaultToolkit().getBestCursorSize(WIDTH, HEIGHT);
		BufferedImage cursorImage = new BufferedImage(size.width, size.height, BufferedImage.TYPE_INT_ARGB);
		cursorImage.setData(anImage.getRaster());
		return cursorImage;
	}

	/**
	 * Answer an angstrom cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor AngstromCursor() {
		if (cursors.containsKey($("angstrom")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(AngstromCursorImage()), new Point(7, 7), "angstrom");
			cursors.put($("angstrom"), cursor);
		}
		return (Cursor) cursors.get($("angstrom"));
	}

	/**
	 * Answer an image of angstrom cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage AngstromCursorImage() {
		if (images.containsKey($("angstrom")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000110000000";
			imageString += "0000001001000000";
			imageString += "0000000110000000";
			imageString += "0000000000000000";
			imageString += "0000000110000000";
			imageString += "0000000110000000";
			imageString += "0000001001000000";
			imageString += "0000001001000000";
			imageString += "0000011111100000";
			imageString += "0000010000100000";
			imageString += "0000010000100000";
			imageString += "0000111001110000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000110000000";
			maskString += "0000001111000000";
			maskString += "0000011111100000";
			maskString += "0000001111000000";
			maskString += "0000000110000000";
			maskString += "0000001111000000";
			maskString += "0000001111000000";
			maskString += "0000011111100000";
			maskString += "0000011111100000";
			maskString += "0000111111110000";
			maskString += "0000111111110000";
			maskString += "0000111001110000";
			maskString += "0001111111111000";
			maskString += "0000111001110000";
			maskString += "0000000000000000";

			images.put($("angstrom"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("angstrom"));
	}

	/**
	 * Answer an anti oblique cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Arrow cursors
	 */
	public static final Cursor AntiObliqueCursor() {
		if (cursors.containsKey($("antiOblique")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(AntiObliqueCursorImage()), new Point(7, 7), "antiOblique");
			cursors.put($("antiOblique"), cursor);
		}
		return (Cursor) cursors.get($("antiOblique"));
	}

	/**
	 * Answer an image of anti oblique cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage AntiObliqueCursorImage() {
		if (images.containsKey($("antiOblique")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0001111000000000";
			imageString += "0001100000000000";
			imageString += "0001010000000000";
			imageString += "0001001000000000";
			imageString += "0000000100000000";
			imageString += "0000000010000000";
			imageString += "0000000001001000";
			imageString += "0000000000101000";
			imageString += "0000000000011000";
			imageString += "0000000001111000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0001111000000000";
			maskString += "0011111100000000";
			maskString += "0011111000000000";
			maskString += "0011111000000000";
			maskString += "0011111100000000";
			maskString += "0001001110000000";
			maskString += "0000000111001000";
			maskString += "0000000011111100";
			maskString += "0000000001111100";
			maskString += "0000000001111100";
			maskString += "0000000011111100";
			maskString += "0000000001111000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("antiOblique"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("antiOblique"));
	}

	/**
	 * Answer an apple cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Plant cursors
	 */
	public static final Cursor AppleCursor() {
		if (cursors.containsKey($("apple")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(AppleCursorImage()), new Point(7, 7), "apple");
			cursors.put($("apple"), cursor);
		}
		return (Cursor) cursors.get($("apple"));
	}

	/**
	 * Answer an image of apple cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage AppleCursorImage() {
		if (images.containsKey($("apple")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000001000000";
			imageString += "0000000011000000";
			imageString += "0000000110000000";
			imageString += "0001111001111000";
			imageString += "0011111111111100";
			imageString += "0111111111111110";
			imageString += "0111111111111110";
			imageString += "0111111111111110";
			imageString += "0111111111110110";
			imageString += "0111111111100110";
			imageString += "0011111111101100";
			imageString += "0011111111001100";
			imageString += "0001111111111000";
			imageString += "0000111001110000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000001000000";
			maskString += "0000000011100000";
			maskString += "0000000111100000";
			maskString += "0001111111111000";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001111111111000";
			maskString += "0000111001110000";

			images.put($("apple"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("apple"));
	}

	/**
	 * Answer an arrow cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Arrow cursors
	 */
	public static final Cursor ArrowCursor() {
		if (cursors.containsKey($("arrow")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(ArrowCursorImage()), new Point(7, 7), "arrow");
			cursors.put($("arrow"), cursor);
		}
		return (Cursor) cursors.get($("arrow"));
	}

	/**
	 * Answer an image of arrow cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage ArrowCursorImage() {
		if (images.containsKey($("arrow")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000010000";
			imageString += "0000000000011000";
			imageString += "0011111111111100";
			imageString += "0000000000011000";
			imageString += "0000000000010000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000010000";
			maskString += "0000000000111000";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0000000000111000";
			maskString += "0000000000010000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("arrow"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("arrow"));
	}

	/**
	 * Answer a between cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Arrow cursors
	 */
	public static final Cursor BetweenCursor() {
		if (cursors.containsKey($("between")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(BetweenCursorImage()), new Point(7, 7), "between");
			cursors.put($("between"), cursor);
		}
		return (Cursor) cursors.get($("between"));
	}

	/**
	 * Answer an image of between cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage BetweenCursorImage() {
		if (images.containsKey($("between")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000100000010000";
			imageString += "0001100000011000";
			imageString += "0011111111111100";
			imageString += "0001100000011000";
			imageString += "0000100000010000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000100000010000";
			maskString += "0001110000111000";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001110000111000";
			maskString += "0000100000010000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("between"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("between"));
	}

	/**
	 * Answer a bited apple cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Plant cursors
	 */
	public static final Cursor BitedAppleCursor() {
		if (cursors.containsKey($("bitedApple")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(BitedAppleCursorImage()), new Point(7, 7), "bitedApple");
			cursors.put($("bitedApple"), cursor);
		}
		return (Cursor) cursors.get($("bitedApple"));
	}

	/**
	 * Answer an image of bited apple cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage BitedAppleCursorImage() {
		if (images.containsKey($("bitedApple")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000001000000";
			imageString += "0000000011000000";
			imageString += "0000000110000000";
			imageString += "0001111001111000";
			imageString += "0011111111111000";
			imageString += "0111111111110000";
			imageString += "0111111111110000";
			imageString += "0111111111110000";
			imageString += "0111111111110000";
			imageString += "0111111111111000";
			imageString += "0011111111111100";
			imageString += "0011111111111100";
			imageString += "0001111111111000";
			imageString += "0000111001110000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000001000000";
			maskString += "0000000011100000";
			maskString += "0000000111100000";
			maskString += "0001111111111000";
			maskString += "0011111111111100";
			maskString += "0111111111111100";
			maskString += "1111111111111000";
			maskString += "1111111111111000";
			maskString += "1111111111111000";
			maskString += "1111111111111000";
			maskString += "1111111111111100";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001111111111000";
			maskString += "0000111001110000";

			images.put($("bitedApple"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("bitedApple"));
	}

	/**
	 * Answer a bounds cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Region cursors
	 */
	public static final Cursor BoundsCursor() {
		if (cursors.containsKey($("bounds")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(BoundsCursorImage()), new Point(13, 13), "bounds");
			cursors.put($("bounds"), cursor);
		}
		return (Cursor) cursors.get($("bounds"));
	}

	/**
	 * Answer an image of bounds cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage BoundsCursorImage() {
		if (images.containsKey($("bounds")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0011111111111000";
			imageString += "0010000000001000";
			imageString += "0010000000001000";
			imageString += "0010000000001000";
			imageString += "0010000000001000";
			imageString += "0010000000001000";
			imageString += "0010000000001000";
			imageString += "0010000000000000";
			imageString += "0010000000001000";
			imageString += "0010000000001000";
			imageString += "0011111110111110";
			imageString += "0000000000001000";
			imageString += "0000000000001000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0011111111111000";
			maskString += "0111111111111100";
			maskString += "0111111111111100";
			maskString += "0111000000011100";
			maskString += "0111000000011100";
			maskString += "0111000000011100";
			maskString += "0111000000011100";
			maskString += "0111000000011100";
			maskString += "0111000000001000";
			maskString += "0111000000011100";
			maskString += "0111111110111110";
			maskString += "0111111111111111";
			maskString += "0011111110111110";
			maskString += "0000000000011100";
			maskString += "0000000000001000";

			images.put($("bounds"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("bounds"));
	}

	/**
	 * Answer a brush cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Stationery cursors
	 */
	public static final Cursor BrushCursor() {
		if (cursors.containsKey($("brush")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(BrushCursorImage()), new Point(2, 14), "brush");
			cursors.put($("brush"), cursor);
		}
		return (Cursor) cursors.get($("brush"));
	}

	/**
	 * Answer an image of brush cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage BrushCursorImage() {
		if (images.containsKey($("brush")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000001001000";
			imageString += "0000000001001000";
			imageString += "0000000010010000";
			imageString += "0000000010010000";
			imageString += "0000000100100000";
			imageString += "0000000100100000";
			imageString += "0000001111000000";
			imageString += "0000010011000000";
			imageString += "0000100011000000";
			imageString += "0000100111000000";
			imageString += "0001001110000000";
			imageString += "0001011100000000";
			imageString += "0010111000000000";
			imageString += "0111100000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000001001000";
			maskString += "0000000011111100";
			maskString += "0000000011111100";
			maskString += "0000000111111000";
			maskString += "0000000111111000";
			maskString += "0000001111110000";
			maskString += "0000001111110000";
			maskString += "0000011111100000";
			maskString += "0000111111100000";
			maskString += "0001111111100000";
			maskString += "0001111111100000";
			maskString += "0011111111000000";
			maskString += "0011111110000000";
			maskString += "0111111100000000";
			maskString += "1111111000000000";
			maskString += "0111100000000000";

			images.put($("brush"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("brush"));
	}

	/**
	 * Answer a bull cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Smalltalk cursors
	 */
	public static final Cursor BullCursor() {
		if (cursors.containsKey($("bull")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(BullCursorImage()), new Point(7, 7), "bull");
			cursors.put($("bull"), cursor);
		}
		return (Cursor) cursors.get($("bull"));
	}

	/**
	 * Answer an image of bull cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage BullCursorImage() {
		if (images.containsKey($("bull")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000011111000000";
			imageString += "0001100100110000";
			imageString += "0010000100001000";
			imageString += "0100000100000100";
			imageString += "0100000100000100";
			imageString += "1000000100000010";
			imageString += "1000000100000010";
			imageString += "1111111111111110";
			imageString += "1000000100000010";
			imageString += "1000000100000010";
			imageString += "0100000100000100";
			imageString += "0100000100000100";
			imageString += "0010000100001000";
			imageString += "0001100100110000";
			imageString += "0000011111000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000111111100000";
			maskString += "0011111111111000";
			maskString += "0111001110011100";
			maskString += "1110001110001110";
			maskString += "1110001110001110";
			maskString += "1100001110000110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1100001110000110";
			maskString += "1110001110001110";
			maskString += "1110001110001110";
			maskString += "0111001110011100";
			maskString += "0011111111111000";
			maskString += "0000111111100000";

			images.put($("bull"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("bull"));
	}

	/**
	 * Answer a camera cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor CameraCursor() {
		if (cursors.containsKey($("camera")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(CameraCursorImage()), new Point(7, 7), "camera");
			cursors.put($("camera"), cursor);
		}
		return (Cursor) cursors.get($("camera"));
	}

	/**
	 * Answer an image of camera cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage CameraCursorImage() {
		if (images.containsKey($("camera")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0011100000000000";
			imageString += "0010100000111100";
			imageString += "0111111111111110";
			imageString += "0100000000000010";
			imageString += "0100001111000010";
			imageString += "0100011001100010";
			imageString += "0100110000110010";
			imageString += "0100100000010010";
			imageString += "0100100001010010";
			imageString += "0100110010110010";
			imageString += "0100011001100010";
			imageString += "0100001111000010";
			imageString += "0100000000000010";
			imageString += "0111111111111110";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0011100000000000";
			maskString += "0111110000111100";
			maskString += "0111111111111110";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "0111111111111110";

			images.put($("camera"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("camera"));
	}

	/**
	 * Answer a cat cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Animal cursors
	 */
	public static final Cursor CatCursor() {
		if (cursors.containsKey($("cat")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(CatCursorImage()), new Point(7, 7), "cat");
			cursors.put($("cat"), cursor);
		}
		return (Cursor) cursors.get($("cat"));
	}

	/**
	 * Answer an image of cat cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage CatCursorImage() {
		if (images.containsKey($("cat")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0001000000001000";
			imageString += "0001100000011000";
			imageString += "0001110000111000";
			imageString += "0011111111111100";
			imageString += "0011111111111100";
			imageString += "0011111111111100";
			imageString += "0111111111111110";
			imageString += "0111000110001110";
			imageString += "0111010110101110";
			imageString += "0111010110101110";
			imageString += "0111000110001110";
			imageString += "0011111111111100";
			imageString += "0001111111111000";
			imageString += "0000111111110000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0001000000001000";
			maskString += "0011100000011100";
			maskString += "0011110000111100";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001111111111000";
			maskString += "0000111111110000";

			images.put($("cat"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("cat"));
	}

	/**
	 * Answer a centralize cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Arrow cursors
	 */
	public static final Cursor CentralizeCursor() {
		if (cursors.containsKey($("centralize")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(CentralizeCursorImage()), new Point(7, 7), "centralize");
			cursors.put($("centralize"), cursor);
		}
		return (Cursor) cursors.get($("centralize"));
	}

	/**
	 * Answer an image of centralize cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage CentralizeCursorImage() {
		if (images.containsKey($("centralize")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000010101000000";
			imageString += "0000001110000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0011110001111000";
			imageString += "0000110001100000";
			imageString += "0001010001010000";
			imageString += "0010010001001000";
			imageString += "0100000000000100";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000011111000000";
			maskString += "0000111111100000";
			maskString += "0000011111000000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";
			maskString += "0000000000000000";
			maskString += "0011110001111000";
			maskString += "0111111011111100";
			maskString += "0011111011111000";
			maskString += "0011111011111000";
			maskString += "0111111011111100";
			maskString += "1110010001001110";
			maskString += "0100000000000100";

			images.put($("centralize"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("centralize"));
	}

	/**
	 * Answer a check off cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor CheckOffCursor() {
		if (cursors.containsKey($("checkOff")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(CheckOffCursorImage()), new Point(7, 7), "checkOff");
			cursors.put($("checkOff"), cursor);
		}
		return (Cursor) cursors.get($("checkOff"));
	}

	/**
	 * Answer an image of check off cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage CheckOffCursorImage() {
		if (images.containsKey($("checkOff")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0011111111111100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0011111111111100";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111000000001110";
			maskString += "0111000000001110";
			maskString += "0111000000001110";
			maskString += "0111000000001110";
			maskString += "0111000000001110";
			maskString += "0111000000001110";
			maskString += "0111000000001110";
			maskString += "0111000000001110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0000000000000000";

			images.put($("checkOff"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("checkOff"));
	}

	/**
	 * Answer a check on cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor CheckOnCursor() {
		if (cursors.containsKey($("checkOn")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(CheckOnCursorImage()), new Point(7, 7), "checkOn");
			cursors.put($("checkOn"), cursor);
		}
		return (Cursor) cursors.get($("checkOn"));
	}

	/**
	 * Answer an image of check on cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage CheckOnCursorImage() {
		if (images.containsKey($("checkOn")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0011111111111100";
			imageString += "0010000000000100";
			imageString += "0010000000010100";
			imageString += "0010000000110100";
			imageString += "0010100001110100";
			imageString += "0010110011100100";
			imageString += "0010110111000100";
			imageString += "0010011110000100";
			imageString += "0010011100000100";
			imageString += "0010001000000100";
			imageString += "0010000000000100";
			imageString += "0011111111111100";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111000000111110";
			maskString += "0111100001111110";
			maskString += "0111110011111110";
			maskString += "0111111111111110";
			maskString += "0111111111101110";
			maskString += "0111111111001110";
			maskString += "0111111110001110";
			maskString += "0111011100001110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0000000000000000";

			images.put($("checkOn"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("checkOn"));
	}

	/**
	 * Answer a clock cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor ClockCursor() {
		if (cursors.containsKey($("clock")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(ClockCursorImage()), new Point(5, 8), "clock");
			cursors.put($("clock"), cursor);
		}
		return (Cursor) cursors.get($("clock"));
	}

	/**
	 * Answer an image of clock cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage ClockCursorImage() {
		if (images.containsKey($("clock")) == false) {
			String imageString = "";
			imageString += "0011111100000000";
			imageString += "0011111100000000";
			imageString += "0011111100000000";
			imageString += "0011111100000000";
			imageString += "0100000010000000";
			imageString += "1000010001000000";
			imageString += "1000010001000000";
			imageString += "1000010001100000";
			imageString += "1001110001100000";
			imageString += "1000000001000000";
			imageString += "1000000001000000";
			imageString += "0100000010000000";
			imageString += "0011111100000000";
			imageString += "0011111100000000";
			imageString += "0011111100000000";
			imageString += "0011111100000000";

			String maskString = "";
			maskString += "0011111100000000";
			maskString += "0011111100000000";
			maskString += "0011111100000000";
			maskString += "0011111100000000";
			maskString += "0111111110000000";
			maskString += "1111111111000000";
			maskString += "1111111111000000";
			maskString += "1111111111100000";
			maskString += "1111111111100000";
			maskString += "1111111111000000";
			maskString += "1111111111000000";
			maskString += "0111111110000000";
			maskString += "0011111100000000";
			maskString += "0011111100000000";
			maskString += "0011111100000000";
			maskString += "0011111100000000";

			images.put($("clock"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("clock"));
	}

	/**
	 * Answer a corner1 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Corner cursors
	 */
	public static final Cursor Corner1Cursor() {
		if (cursors.containsKey($("corner1")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Corner1CursorImage()), new Point(7, 7), "corner1");
			cursors.put($("corner1"), cursor);
		}
		return (Cursor) cursors.get($("corner1"));
	}

	/**
	 * Answer an image of corner1 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Corner1CursorImage() {
		if (images.containsKey($("corner1")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000011111100";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001111111100";
			maskString += "0000001011111110";
			maskString += "0000001111111100";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("corner1"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("corner1"));
	}

	/**
	 * Answer a corner2 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Corner cursors
	 */
	public static final Cursor Corner2Cursor() {
		if (cursors.containsKey($("corner2")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Corner2CursorImage()), new Point(7, 7), "corner2");
			cursors.put($("corner2"), cursor);
		}
		return (Cursor) cursors.get($("corner2"));
	}

	/**
	 * Answer an image of corner2 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Corner2CursorImage() {
		if (images.containsKey($("corner2")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0111111000000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0111111110000000";
			maskString += "1111111010000000";
			maskString += "0111111110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";
			maskString += "0000000000000000";

			images.put($("corner2"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("corner2"));
	}

	/**
	 * Answer a corner3 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Corner cursors
	 */
	public static final Cursor Corner3Cursor() {
		if (cursors.containsKey($("corner3")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Corner3CursorImage()), new Point(7, 7), "corner3");
			cursors.put($("corner3"), cursor);
		}
		return (Cursor) cursors.get($("corner3"));
	}

	/**
	 * Answer an image of corner3 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Corner3CursorImage() {
		if (images.containsKey($("corner3")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0111111000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0111111110000000";
			maskString += "1111111010000000";
			maskString += "0111111110000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("corner3"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("corner3"));
	}

	/**
	 * Answer a corner4 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Corner cursors
	 */
	public static final Cursor Corner4Cursor() {
		if (cursors.containsKey($("corner4")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Corner4CursorImage()), new Point(7, 7), "corner4");
			cursors.put($("corner4"), cursor);
		}
		return (Cursor) cursors.get($("corner4"));
	}

	/**
	 * Answer an image of corner4 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Corner4CursorImage() {
		if (images.containsKey($("corner4")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000011111100";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000001111111100";
			maskString += "0000001011111110";
			maskString += "0000001111111100";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";
			maskString += "0000000000000000";

			images.put($("corner4"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("corner4"));
	}

	/**
	 * Answer a cow cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Animal cursors
	 */
	public static final Cursor CowCursor() {
		if (cursors.containsKey($("cow")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(CowCursorImage()), new Point(7, 7), "cow");
			cursors.put($("cow"), cursor);
		}
		return (Cursor) cursors.get($("cow"));
	}

	/**
	 * Answer an image of cow cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage CowCursorImage() {
		if (images.containsKey($("cow")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000100000010000";
			imageString += "0001110000111000";
			imageString += "0001011111101000";
			imageString += "0111110011111110";
			imageString += "0111000111001110";
			imageString += "0010110110110100";
			imageString += "0010100111010100";
			imageString += "0010000011101100";
			imageString += "0010000001111100";
			imageString += "0010000000111100";
			imageString += "0011000000011100";
			imageString += "0001101001011000";
			imageString += "0000111001110000";
			imageString += "0000001111000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000100000010000";
			maskString += "0001110000111000";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001111111111000";
			maskString += "0000111111110000";
			maskString += "0000001111000000";

			images.put($("cow"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("cow"));
	}

	/**
	 * Answer a cross cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor CrossCursor() {
		if (cursors.containsKey($("cross")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(CrossCursorImage()), new Point(7, 7), "cross");
			cursors.put($("cross"), cursor);
		}
		return (Cursor) cursors.get($("cross"));
	}

	/**
	 * Answer an image of cross cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage CrossCursorImage() {
		if (images.containsKey($("cross")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";
			imageString += "0111110001111100";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0111111011111100";
			maskString += "1111110001111110";
			maskString += "0111111011111100";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";
			maskString += "0000000000000000";

			images.put($("cross"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("cross"));
	}

	/**
	 * Answer a cross minus cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor CrossMinusCursor() {
		if (cursors.containsKey($("crossMinus")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(CrossMinusCursorImage()), new Point(7, 7), "crossMinus");
			cursors.put($("crossMinus"), cursor);
		}
		return (Cursor) cursors.get($("crossMinus"));
	}

	/**
	 * Answer an image of cross minus cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage CrossMinusCursorImage() {
		if (images.containsKey($("crossMinus")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";
			imageString += "0111110001111100";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100111110";
			imageString += "0000000100000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0111110101111100";
			maskString += "1111111011111110";
			maskString += "0111110101111100";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110111110";
			maskString += "0000001111111111";
			maskString += "0000001110111110";
			maskString += "0000000100000000";
			maskString += "0000000000000000";

			images.put($("crossMinus"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("crossMinus"));
	}

	/**
	 * Answer a cross plus cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor CrossPlusCursor() {
		if (cursors.containsKey($("crossPlus")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(CrossPlusCursorImage()), new Point(7, 7), "crossPlus");
			cursors.put($("crossPlus"), cursor);
		}
		return (Cursor) cursors.get($("crossPlus"));
	}

	/**
	 * Answer an image of cross plus cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage CrossPlusCursorImage() {
		if (images.containsKey($("crossPlus")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";
			imageString += "0111110001111100";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000000100001000";
			imageString += "0000000100001000";
			imageString += "0000000100111110";
			imageString += "0000000100001000";
			imageString += "0000000000001000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0111110101111100";
			maskString += "1111111011111110";
			maskString += "0111110101111100";
			maskString += "0000001110001000";
			maskString += "0000001110011100";
			maskString += "0000001110111110";
			maskString += "0000001111111111";
			maskString += "0000001110111110";
			maskString += "0000000100011100";
			maskString += "0000000000001000";

			images.put($("crossPlus"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("crossPlus"));
	}

	/**
	 * Answer a dolly2 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor Dolly2Cursor() {
		if (cursors.containsKey($("dolly2")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Dolly2CursorImage()), new Point(7, 7), "dolly2");
			cursors.put($("dolly2"), cursor);
		}
		return (Cursor) cursors.get($("dolly2"));
	}

	/**
	 * Answer an image of dolly cursor 2.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Dolly2CursorImage() {
		if (images.containsKey($("dolly2")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000011110000";
			imageString += "0000000000110000";
			imageString += "0000000000110000";
			imageString += "0000111100110000";
			imageString += "0011000011110000";
			imageString += "0011000000110000";
			imageString += "0011000000110000";
			imageString += "0011000000110000";
			imageString += "0000111111111100";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000011110000";
			maskString += "0000001111111100";
			maskString += "0000000011111100";
			maskString += "0000111111111100";
			maskString += "0011111111111100";
			maskString += "1111111111111100";
			maskString += "1111110011111100";
			maskString += "1111110011111100";
			maskString += "1111111111111100";
			maskString += "0011111111111111";
			maskString += "0000111111111100";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("dolly2"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("dolly2"));
	}

	/**
	 * Answer a dolly cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor DollyCursor() {
		if (cursors.containsKey($("dolly")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(DollyCursorImage()), new Point(7, 7), "dolly");
			cursors.put($("dolly"), cursor);
		}
		return (Cursor) cursors.get($("dolly"));
	}

	/**
	 * Answer an image of dolly cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage DollyCursorImage() {
		if (images.containsKey($("dolly")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000011000000";
			imageString += "0000000001000000";
			imageString += "0000000001000000";
			imageString += "0000001101000000";
			imageString += "0000010011000000";
			imageString += "0000010001000000";
			imageString += "0000010001000000";
			imageString += "0000010001000000";
			imageString += "0000001111100000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000011000000";
			maskString += "0000000111100000";
			maskString += "0000000011100000";
			maskString += "0000001111100000";
			maskString += "0000011111100000";
			maskString += "0000111111100000";
			maskString += "0000111011100000";
			maskString += "0000111011100000";
			maskString += "0000111111100000";
			maskString += "0000011111110000";
			maskString += "0000001111100000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("dolly"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("dolly"));
	}

	/**
	 * Answer an down arrow cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Arrow cursors
	 */
	public static final Cursor DownArrowCursor() {
		if (cursors.containsKey($("downArrow")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(DownArrowCursorImage()), new Point(7, 7), "downArrow");
			cursors.put($("downArrow"), cursor);
		}
		return (Cursor) cursors.get($("downArrow"));
	}

	/**
	 * Answer an image of down arrow cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage DownArrowCursorImage() {
		if (images.containsKey($("downArrow")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000011111000000";
			imageString += "0000001110000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000011111000000";
			maskString += "0000111111100000";
			maskString += "0000011111000000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";
			maskString += "0000000000000000";

			images.put($("downArrow"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("downArrow"));
	}

	/**
	 * Answer an epilogue cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Video cursors
	 */
	public static final Cursor EpilogueCursor() {
		if (cursors.containsKey($("epilogue")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(EpilogueCursorImage()), new Point(7, 7), "epilogue");
			cursors.put($("epilogue"), cursor);
		}
		return (Cursor) cursors.get($("epilogue"));
	}

	/**
	 * Answer an image of epilogue cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage EpilogueCursorImage() {
		if (images.containsKey($("epilogue")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0001100000001000";
			imageString += "0001110000001000";
			imageString += "0001111000001000";
			imageString += "0001101100001000";
			imageString += "0001100110001000";
			imageString += "0001100011001000";
			imageString += "0001100011001000";
			imageString += "0001100110001000";
			imageString += "0001101100001000";
			imageString += "0001111000001000";
			imageString += "0001110000001000";
			imageString += "0001100000001000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0001100000001000";
			maskString += "0011110000011100";
			maskString += "0011111000011100";
			maskString += "0011111100011100";
			maskString += "0011111110011100";
			maskString += "0011111111011100";
			maskString += "0011110111111100";
			maskString += "0011110111111100";
			maskString += "0011111111011100";
			maskString += "0011111110011100";
			maskString += "0011111100011100";
			maskString += "0011111000011100";
			maskString += "0011110000011100";
			maskString += "0001100000001000";
			maskString += "0000000000000000";

			images.put($("epilogue"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("epilogue"));
	}

	/**
	 * Answer an eraser cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Stationery cursors
	 */
	public static final Cursor EraserCursor() {
		if (cursors.containsKey($("eraser")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(EraserCursorImage()), new Point(1, 12), "eraser");
			cursors.put($("eraser"), cursor);
		}
		return (Cursor) cursors.get($("eraser"));
	}

	/**
	 * Answer an image of eraser cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage EraserCursorImage() {
		if (images.containsKey($("eraser")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000111111110";
			imageString += "0000001000000110";
			imageString += "0000010000001010";
			imageString += "0000100000010010";
			imageString += "0001000000100100";
			imageString += "0010000001001000";
			imageString += "0111111110010000";
			imageString += "0100000010100000";
			imageString += "0100000011000000";
			imageString += "0111111110000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000111111110";
			maskString += "0000001111111111";
			maskString += "0000011111111111";
			maskString += "0000111111111111";
			maskString += "0001111111111111";
			maskString += "0011111111111110";
			maskString += "0111111111111100";
			maskString += "1111111111111000";
			maskString += "1111111111110000";
			maskString += "1111111111100000";
			maskString += "1111111111000000";
			maskString += "0111111110000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("eraser"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("eraser"));
	}

	/**
	 * Answer an epilogue cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Smalltalk cursors
	 */
	public static final Cursor ExecuteCursor() {
		if (cursors.containsKey($("execute")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(ExecuteCursorImage()), new Point(1, 1), "execute");
			cursors.put($("execute"), cursor);
		}
		return (Cursor) cursors.get($("execute"));
	}

	/**
	 * Answer an image of execute cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage ExecuteCursorImage() {
		if (images.containsKey($("execute")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0100000000010000";
			imageString += "0110000000010000";
			imageString += "0111000000111000";
			imageString += "0111100111111111";
			imageString += "0111110011000110";
			imageString += "0111111001000100";
			imageString += "0111111101111100";
			imageString += "0111110001101100";
			imageString += "0111110011000110";
			imageString += "0100110010000010";
			imageString += "0000011000000000";
			imageString += "0000011000000000";
			imageString += "0000001100000000";
			imageString += "0000001100000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "1100000000010000";
			maskString += "1110000000111000";
			maskString += "1111000000111000";
			maskString += "1111100111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111011111110";
			maskString += "1111111111101111";
			maskString += "1111111111000111";
			maskString += "1000111111000111";
			maskString += "0000111100000000";
			maskString += "0000011110000000";
			maskString += "0000011110000000";
			maskString += "0000001100000000";

			images.put($("execute"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("execute"));
	}

	/**
	 * Answer an eye1 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor Eye1Cursor() {
		if (cursors.containsKey($("eye1")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Eye1CursorImage()), new Point(7, 7), "eye1");
			cursors.put($("eye1"), cursor);
		}
		return (Cursor) cursors.get($("eye1"));
	}

	/**
	 * Answer an image of eye1 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Eye1CursorImage() {
		if (images.containsKey($("eye1")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0100011110000000";
			imageString += "0100100001100000";
			imageString += "0011111110011000";
			imageString += "0000111111100100";
			imageString += "0000010101111010";
			imageString += "0000010100011100";
			imageString += "0000011100001110";
			imageString += "0000011100001000";
			imageString += "0000001100110000";
			imageString += "0000001111000000";
			imageString += "0000000110000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0100011110000000";
			maskString += "1110111111100000";
			maskString += "1111111111111000";
			maskString += "0111111111111100";
			maskString += "0011111111111110";
			maskString += "0000111111111111";
			maskString += "0000111111111110";
			maskString += "0000111111111111";
			maskString += "0000111111111110";
			maskString += "0000011111111000";
			maskString += "0000011111110000";
			maskString += "0000001111000000";
			maskString += "0000000110000000";
			maskString += "0000000000000000";

			images.put($("eye1"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("eye1"));
	}

	/**
	 * Answer an eye2 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor Eye2Cursor() {
		if (cursors.containsKey($("eye2")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Eye2CursorImage()), new Point(7, 7), "eye2");
			cursors.put($("eye2"), cursor);
		}
		return (Cursor) cursors.get($("eye2"));
	}

	/**
	 * Answer an image of eye2 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Eye2CursorImage() {
		if (images.containsKey($("eye2")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000010000000000";
			imageString += "0001010000000000";
			imageString += "0101011110000000";
			imageString += "0100101001100000";
			imageString += "0011111110011000";
			imageString += "0000110111100100";
			imageString += "0000010101111010";
			imageString += "0000010100011100";
			imageString += "0000011100001110";
			imageString += "0000011100001000";
			imageString += "0000001100110000";
			imageString += "0000001111000000";
			imageString += "0000000110000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000010000000000";
			maskString += "0001111000000000";
			maskString += "0111111110000000";
			maskString += "1111111111100000";
			maskString += "1111111111111000";
			maskString += "0111111111111100";
			maskString += "0011111111111110";
			maskString += "0000111111111111";
			maskString += "0000111111111110";
			maskString += "0000111111111111";
			maskString += "0000111111111110";
			maskString += "0000011111111000";
			maskString += "0000011111110000";
			maskString += "0000001111000000";
			maskString += "0000000110000000";

			images.put($("eye2"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("eye2"));
	}

	/**
	 * Answer a film cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor FilmCursor() {
		if (cursors.containsKey($("film")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(FilmCursorImage()), new Point(7, 7), "film");
			cursors.put($("film"), cursor);
		}
		return (Cursor) cursors.get($("film"));
	}

	/**
	 * Answer an image of film cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage FilmCursorImage() {
		if (images.containsKey($("film")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0111000000001110";
			imageString += "0111000000001110";
			imageString += "0101111111111010";
			imageString += "0111000000001110";
			imageString += "0111000000001110";
			imageString += "0101000000001010";
			imageString += "0111000000001110";
			imageString += "0111000000001110";
			imageString += "0101000000001010";
			imageString += "0111000000001110";
			imageString += "0111000000001110";
			imageString += "0101111111111010";
			imageString += "0111000000001110";
			imageString += "0111000000001110";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0111000000001110";
			maskString += "1111100000011111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111100000011111";
			maskString += "0111000000001110";

			images.put($("film"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("film"));
	}

	/**
	 * Answer a frame cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Region cursors
	 */
	public static final Cursor FrameCursor() {
		if (cursors.containsKey($("frame")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(FrameCursorImage()), new Point(7, 7), "frame");
			cursors.put($("frame"), cursor);
		}
		return (Cursor) cursors.get($("frame"));
	}

	/**
	 * Answer an image of frame cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage FrameCursorImage() {
		if (images.containsKey($("frame")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0111100111001110";
			imageString += "0100000000000010";
			imageString += "0100000000000010";
			imageString += "0000000000000010";
			imageString += "0000000000000000";
			imageString += "0100000000000000";
			imageString += "0100000000000010";
			imageString += "0100000000000010";
			imageString += "0000000000000010";
			imageString += "0000000000000000";
			imageString += "0100000000000000";
			imageString += "0100000000000010";
			imageString += "0100000000000010";
			imageString += "0111001110011110";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0111100111001110";
			maskString += "1111111111111111";
			maskString += "1111100111001111";
			maskString += "1110000000000111";
			maskString += "0100000000000111";
			maskString += "0100000000000010";
			maskString += "1110000000000010";
			maskString += "1110000000000111";
			maskString += "1110000000000111";
			maskString += "0100000000000111";
			maskString += "0100000000000010";
			maskString += "1110000000000010";
			maskString += "1110000000000111";
			maskString += "1111001110011111";
			maskString += "1111111111111111";
			maskString += "0111001110011110";

			images.put($("frame"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("frame"));
	}

	/**
	 * Answer a gauge cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor GaugeCursor() {
		if (cursors.containsKey($("gauge")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(GaugeCursorImage()), new Point(7, 7), "gauge");
			cursors.put($("gauge"), cursor);
		}
		return (Cursor) cursors.get($("gauge"));
	}

	/**
	 * Answer an image of gauge cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage GaugeCursorImage() {
		if (images.containsKey($("gauge")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0001111011111000";
			imageString += "0000000010001000";
			imageString += "0000011010001000";
			imageString += "0000000010001000";
			imageString += "0000011010001000";
			imageString += "0000000010001000";
			imageString += "0000111010001000";
			imageString += "0000000010001000";
			imageString += "0000011011111000";
			imageString += "0000000011111000";
			imageString += "0000011011111000";
			imageString += "0000000011111000";
			imageString += "0001111011111000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0001111011111000";
			maskString += "0011111111111100";
			maskString += "0001111111111100";
			maskString += "0000111111111100";
			maskString += "0000011111111100";
			maskString += "0000111111111100";
			maskString += "0000111111111100";
			maskString += "0001111111111100";
			maskString += "0000111111111100";
			maskString += "0000111111111100";
			maskString += "0000011111111100";
			maskString += "0000111111111100";
			maskString += "0001111111111100";
			maskString += "0011111111111100";
			maskString += "0001111011111000";

			images.put($("gauge"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("gauge"));
	}

	/**
	 * Answer a glass cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Glass cursors
	 */
	public static final Cursor GlassCursor() {
		if (cursors.containsKey($("glass")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(GlassCursorImage()), new Point(5, 5), "glass");
			cursors.put($("glass"), cursor);
		}
		return (Cursor) cursors.get($("glass"));
	}

	/**
	 * Answer an image of grass cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage GlassCursorImage() {
		if (images.containsKey($("glass")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000111100000000";
			imageString += "0011000011000000";
			imageString += "0010000001000000";
			imageString += "0100000000100000";
			imageString += "0100000000100000";
			imageString += "0100000000100000";
			imageString += "0100000000100000";
			imageString += "0010000001000000";
			imageString += "0011000011100000";
			imageString += "0000111101110000";
			imageString += "0000000000111000";
			imageString += "0000000000011100";
			imageString += "0000000000001110";
			imageString += "0000000000000110";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000111100000000";
			maskString += "0011111111000000";
			maskString += "0111111111100000";
			maskString += "0111000011100000";
			maskString += "1110000001110000";
			maskString += "1110000001110000";
			maskString += "1110000001110000";
			maskString += "1110000001110000";
			maskString += "0111000011100000";
			maskString += "0111111111110000";
			maskString += "0011111111111000";
			maskString += "0000111101111100";
			maskString += "0000000000111110";
			maskString += "0000000000011111";
			maskString += "0000000000001111";
			maskString += "0000000000000110";

			images.put($("glass"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("glass"));
	}

	/**
	 * Answer a glove cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor GloveCursor() {
		if (cursors.containsKey($("glove")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(GloveCursorImage()), new Point(7, 7), "glove");
			cursors.put($("glove"), cursor);
		}
		return (Cursor) cursors.get($("glove"));
	}

	/**
	 * Answer an image of glove cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage GloveCursorImage() {
		if (images.containsKey($("glove")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000111100000000";
			imageString += "0001111110000000";
			imageString += "0011111111000000";
			imageString += "0111111111100000";
			imageString += "0111111111100000";
			imageString += "0111111111100000";
			imageString += "0111111111110000";
			imageString += "0100111111011000";
			imageString += "0011111110111100";
			imageString += "0001111101111010";
			imageString += "0000001111110110";
			imageString += "0000000011101100";
			imageString += "0000000001011000";
			imageString += "0000000000110000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000111100000000";
			maskString += "0001111110000000";
			maskString += "0011111111000000";
			maskString += "0111111111100000";
			maskString += "1111111111110000";
			maskString += "1111111111110000";
			maskString += "1111111111110000";
			maskString += "1111111111111000";
			maskString += "1111111111111100";
			maskString += "0111111111111110";
			maskString += "0011111111111111";
			maskString += "0001111111111111";
			maskString += "0000001111111110";
			maskString += "0000000011111100";
			maskString += "0000000001111000";
			maskString += "0000000000110000";

			images.put($("glove"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("glove"));
	}

	/**
	 * Answer a go cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor GoCursor() {
		if (cursors.containsKey($("go")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(GoCursorImage()), new Point(7, 7), "go");
			cursors.put($("go"), cursor);
		}
		return (Cursor) cursors.get($("go"));
	}

	/**
	 * Answer an image of go cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage GoCursorImage() {
		if (images.containsKey($("go")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0001110000111000";
			imageString += "0010001001000100";
			imageString += "0010000001000100";
			imageString += "0010000001000100";
			imageString += "0010011101000100";
			imageString += "0010001001000100";
			imageString += "0010001001000100";
			imageString += "0001110000111000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0001110000111000";
			maskString += "0011111001111100";
			maskString += "0111111111111110";
			maskString += "0111001011101110";
			maskString += "0111011111101110";
			maskString += "0111111111101110";
			maskString += "0111011111101110";
			maskString += "0111111111111110";
			maskString += "0011111001111100";
			maskString += "0001110000111000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("go"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("go"));
	}

	/**
	 * Answer a hand cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor HandCursor() {
		if (cursors.containsKey($("hand")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(HandCursorImage()), new Point(7, 7), "hand");
			cursors.put($("hand"), cursor);
		}
		return (Cursor) cursors.get($("hand"));
	}

	/**
	 * Answer an image of hand cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage HandCursorImage() {
		if (images.containsKey($("hand")) == false) {
			String imageString = "";
			imageString += "0000000110000000";
			imageString += "0001101001110000";
			imageString += "0010011001001000";
			imageString += "0010011001001010";
			imageString += "0001001001001101";
			imageString += "0001001001001001";
			imageString += "0110100000001001";
			imageString += "1001100000000001";
			imageString += "1000100000000010";
			imageString += "0100000000000010";
			imageString += "0010000000000010";
			imageString += "0010000000000100";
			imageString += "0001000000000100";
			imageString += "0000100000001000";
			imageString += "0000010000001000";
			imageString += "0000010000001000";

			String maskString = "";
			maskString += "0000000110000000";
			maskString += "0001101111110000";
			maskString += "0011111111111000";
			maskString += "0011111111111010";
			maskString += "0001111111111111";
			maskString += "0001111111111111";
			maskString += "0110111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111110";
			maskString += "0111111111111110";
			maskString += "0011111111111110";
			maskString += "0011111111111100";
			maskString += "0001111111111100";
			maskString += "0000111111111000";
			maskString += "0000011111111000";
			maskString += "0000011111111000";

			images.put($("hand"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("hand"));
	}

	/**
	 * Answer a home cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor HomeCursor() {
		if (cursors.containsKey($("home")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(HomeCursorImage()), new Point(7, 7), "home");
			cursors.put($("home"), cursor);
		}
		return (Cursor) cursors.get($("home"));
	}

	/**
	 * Answer an image of home cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage HomeCursorImage() {
		if (images.containsKey($("home")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000110000000";
			imageString += "0000001011000000";
			imageString += "0000010111100000";
			imageString += "0000101111110000";
			imageString += "0001011001111000";
			imageString += "0010110000111100";
			imageString += "0101100000011110";
			imageString += "0111000000001110";
			imageString += "0110001111000110";
			imageString += "0010001001000100";
			imageString += "0010001001000100";
			imageString += "0010001011000100";
			imageString += "0010001001000100";
			imageString += "0011111111111100";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000110000000";
			maskString += "0000001111000000";
			maskString += "0000011111100000";
			maskString += "0000111111110000";
			maskString += "0001111111111000";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0011111111111100";

			images.put($("home"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("home"));
	}

	/**
	 * Answer a juice cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor JuiceCursor() {
		if (cursors.containsKey($("juice")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(JuiceCursorImage()), new Point(7, 8), "juice");
			cursors.put($("juice"), cursor);
		}
		return (Cursor) cursors.get($("juice"));
	}

	/**
	 * Answer an image of juice cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage JuiceCursorImage() {
		if (images.containsKey($("juice")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000001010000000";
			imageString += "0000001010000000";
			imageString += "0000010001000000";
			imageString += "0000100000100000";
			imageString += "0000100000100000";
			imageString += "0001000000010000";
			imageString += "0001000000010000";
			imageString += "0001000000010000";
			imageString += "0001000000010000";
			imageString += "0000100000100000";
			imageString += "0000010001000000";
			imageString += "0000001110000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000011111000000";
			maskString += "0000011111000000";
			maskString += "0000111011100000";
			maskString += "0001110001110000";
			maskString += "0001110001110000";
			maskString += "0011100000111000";
			maskString += "0011100000111000";
			maskString += "0011100000111000";
			maskString += "0011100000111000";
			maskString += "0001110001110000";
			maskString += "0000111111100000";
			maskString += "0000011111000000";
			maskString += "0000001110000000";

			images.put($("juice"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("juice"));
	}

	/**
	 * Answer a lasso cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Region cursors
	 */
	public static final Cursor LassoCursor() {
		if (cursors.containsKey($("lasso")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(LassoCursorImage()), new Point(3, 14), "lasso");
			cursors.put($("lasso"), cursor);
		}
		return (Cursor) cursors.get($("lasso"));
	}

	/**
	 * Answer an image of lasso cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage LassoCursorImage() {
		if (images.containsKey($("lasso")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000111110000";
			imageString += "0000111000001100";
			imageString += "0001000000000010";
			imageString += "0010000000000010";
			imageString += "0100000000000010";
			imageString += "0100000000001100";
			imageString += "0100000000110000";
			imageString += "0011100011000000";
			imageString += "0110011100000000";
			imageString += "0101010000000000";
			imageString += "0011100000000000";
			imageString += "0000100000000000";
			imageString += "0000100000000000";
			imageString += "0001000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000111110000";
			maskString += "0000111111111100";
			maskString += "0001111111111110";
			maskString += "0011111000001111";
			maskString += "0111000000000111";
			maskString += "1110000000001111";
			maskString += "1110000000111110";
			maskString += "1111100011111100";
			maskString += "0111111111110000";
			maskString += "1111111111000000";
			maskString += "1111111100000000";
			maskString += "0111110000000000";
			maskString += "0011110000000000";
			maskString += "0001110000000000";
			maskString += "0011100000000000";
			maskString += "0001000000000000";

			images.put($("lasso"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("lasso"));
	}

	/**
	 * Answer a lasso minus cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Region cursors
	 */
	public static final Cursor LassoMinusCursor() {
		if (cursors.containsKey($("lassoMinus")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(LassoMinusCursorImage()), new Point(3, 14), "lassoMinus");
			cursors.put($("lassoMinus"), cursor);
		}
		return (Cursor) cursors.get($("lassoMinus"));
	}

	/**
	 * Answer an image of lasso minus cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage LassoMinusCursorImage() {
		if (images.containsKey($("lassoMinus")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000111110000";
			imageString += "0000111000001100";
			imageString += "0001000000000010";
			imageString += "0010000000000010";
			imageString += "0100000000000010";
			imageString += "0100000000001100";
			imageString += "0100000000110000";
			imageString += "0011100011000000";
			imageString += "0110011100000000";
			imageString += "0101010000000000";
			imageString += "0011100000000000";
			imageString += "0000100000111110";
			imageString += "0000100000000000";
			imageString += "0001000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000111110000";
			maskString += "0000111111111100";
			maskString += "0001111111111110";
			maskString += "0011111000001111";
			maskString += "0111000000000111";
			maskString += "1110000000001111";
			maskString += "1110000000111110";
			maskString += "1111100011111100";
			maskString += "0111111111110000";
			maskString += "1111111111000000";
			maskString += "1111111100000000";
			maskString += "0111110000111110";
			maskString += "0011110001111111";
			maskString += "0001110000111110";
			maskString += "0011100000000000";
			maskString += "0001000000000000";

			images.put($("lassoMinus"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("lassoMinus"));
	}

	/**
	 * Answer a lasso plus cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Region cursors
	 */
	public static final Cursor LassoPlusCursor() {
		if (cursors.containsKey($("lassoPlus")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(LassoPlusCursorImage()), new Point(3, 14), "lassoPlus");
			cursors.put($("lassoPlus"), cursor);
		}
		return (Cursor) cursors.get($("lassoPlus"));
	}

	/**
	 * Answer an image of lasso plus cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage LassoPlusCursorImage() {
		if (images.containsKey($("lassoPlus")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000111110000";
			imageString += "0000111000001100";
			imageString += "0001000000000010";
			imageString += "0010000000000010";
			imageString += "0100000000000010";
			imageString += "0100000000001100";
			imageString += "0100000000110000";
			imageString += "0011100011000000";
			imageString += "0110011100000000";
			imageString += "0101010000001000";
			imageString += "0011100000001000";
			imageString += "0000100000111110";
			imageString += "0000100000001000";
			imageString += "0001000000001000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000111110000";
			maskString += "0000111111111100";
			maskString += "0001111111111110";
			maskString += "0011111000001111";
			maskString += "0111000000000111";
			maskString += "1110000000001111";
			maskString += "1110000000111110";
			maskString += "1111100011111100";
			maskString += "0111111111110000";
			maskString += "1111111111001000";
			maskString += "1111111100011100";
			maskString += "0111110000111110";
			maskString += "0011110001111111";
			maskString += "0001110000111110";
			maskString += "0011100000011100";
			maskString += "0001000000001000";

			images.put($("lassoPlus"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("lassoPlus"));
	}

	/**
	 * Answer a layer cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor LayerCursor() {
		if (cursors.containsKey($("layer")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(LayerCursorImage()), new Point(7, 7), "layer");
			cursors.put($("layer"), cursor);
		}
		return (Cursor) cursors.get($("layer"));
	}

	/**
	 * Answer an image of layer cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage LayerCursorImage() {
		if (images.containsKey($("layer")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000011111111110";
			imageString += "0000010000000010";
			imageString += "0001111111111010";
			imageString += "0001000000001010";
			imageString += "0111111111101010";
			imageString += "0100000000101010";
			imageString += "0100000000101010";
			imageString += "0100000000101010";
			imageString += "0100000000101010";
			imageString += "0100000000101110";
			imageString += "0100000000101000";
			imageString += "0100000000111000";
			imageString += "0100000000100000";
			imageString += "0111111111100000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000011111111110";
			maskString += "0000111111111111";
			maskString += "0001111111111111";
			maskString += "0011111111111111";
			maskString += "0111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111110";
			maskString += "1111111111111100";
			maskString += "1111111111111000";
			maskString += "1111111111110000";
			maskString += "0111111111100000";

			images.put($("layer"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("layer"));
	}

	/**
	 * Answer a left arrow cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Arrow cursors
	 */
	public static final Cursor LeftArrowCursor() {
		if (cursors.containsKey($("leftArrow")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(LeftArrowCursorImage()), new Point(7, 7), "leftArrow");
			cursors.put($("leftArrow"), cursor);
		}
		return (Cursor) cursors.get($("leftArrow"));
	}

	/**
	 * Answer an image of left arrow cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage LeftArrowCursorImage() {
		if (images.containsKey($("leftArrow")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000100000000000";
			imageString += "0001100000000000";
			imageString += "0011111111111100";
			imageString += "0001100000000000";
			imageString += "0000100000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000100000000000";
			maskString += "0001110000000000";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001110000000000";
			maskString += "0000100000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("leftArrow"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("leftArrow"));
	}

	/**
	 * Answer a left click cordless mouse cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Mouse cursors
	 */
	public static final Cursor LeftClickCordlessMouseCursor() {
		if (cursors.containsKey($("leftClickCordlessMouse")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(LeftClickCordlessMouseCursorImage()), new Point(7, 7), "leftClickCordlessMouse");
			cursors.put($("leftClickCordlessMouse"), cursor);
		}
		return (Cursor) cursors.get($("leftClickCordlessMouse"));
	}

	/**
	 * Answer an image of left click cordless mouse cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage LeftClickCordlessMouseCursorImage() {
		if (images.containsKey($("leftClickCordlessMouse")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000011111100000";
			imageString += "0000111100110000";
			imageString += "0001111100011000";
			imageString += "0001111100001000";
			imageString += "0011111100001100";
			imageString += "0011111100000100";
			imageString += "0011111100000100";
			imageString += "0011111111111100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0011000000001100";
			imageString += "0001100000011000";
			imageString += "0000111111110000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000011111100000";
			maskString += "0000111111110000";
			maskString += "0001111111111000";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001111111111000";
			maskString += "0000111111110000";

			images.put($("leftClickCordlessMouse"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("leftClickCordlessMouse"));
	}

	/**
	 * Answer a left click mouse cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Mouse cursors
	 */
	public static final Cursor LeftClickMouseCursor() {
		if (cursors.containsKey($("leftClickMouse")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(LeftClickMouseCursorImage()), new Point(7, 7), "leftClickMouse");
			cursors.put($("leftClickMouse"), cursor);
		}
		return (Cursor) cursors.get($("leftClickMouse"));
	}

	/**
	 * Answer an image of left click mouse cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage LeftClickMouseCursorImage() {
		if (images.containsKey($("leftClickMouse")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0001111110000000";
			imageString += "0011000010000000";
			imageString += "0000011111100000";
			imageString += "0000111100110000";
			imageString += "0001111100011000";
			imageString += "0001111100001000";
			imageString += "0011111100001100";
			imageString += "0011111100000100";
			imageString += "0011111111111100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0011000000001100";
			imageString += "0001100000011000";
			imageString += "0000111111110000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0001111110000000";
			maskString += "0011111111000000";
			maskString += "0111111111100000";
			maskString += "0011111111110000";
			maskString += "0001111111111000";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001111111111000";
			maskString += "0000111111110000";

			images.put($("leftClickMouse"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("leftClickMouse"));
	}

	/**
	 * Answer a muscle cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Video cursors
	 */
	public static final Cursor MuscleCursor() {
		if (cursors.containsKey($("muscle")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(MuscleCursorImage()), new Point(7, 7), "muscle");
			cursors.put($("muscle"), cursor);
		}
		return (Cursor) cursors.get($("muscle"));
	}

	/**
	 * Answer an image of muscle cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage MuscleCursorImage() {
		if (images.containsKey($("muscle")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000111100000";
			imageString += "0000001111110000";
			imageString += "0000001001110000";
			imageString += "0000000111111000";
			imageString += "0000000000111000";
			imageString += "0010010010111000";
			imageString += "0001010100111100";
			imageString += "0000000000011100";
			imageString += "0001111100011100";
			imageString += "0011111110011110";
			imageString += "0111111111111110";
			imageString += "0111111101111110";
			imageString += "0111110011111110";
			imageString += "0111111111111100";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000111100000";
			maskString += "0000001111110000";
			maskString += "0000011111111000";
			maskString += "0000011111111000";
			maskString += "0000001111111100";
			maskString += "0010010111111100";
			maskString += "0111111111111100";
			maskString += "0011111111111110";
			maskString += "0001111100111110";
			maskString += "0011111110111110";
			maskString += "0111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111110";
			maskString += "0111111111111100";

			images.put($("muscle"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("muscle"));
	}

	/**
	 * Answer a next cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Video cursors
	 */
	public static final Cursor NextCursor() {
		if (cursors.containsKey($("next")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(NextCursorImage()), new Point(7, 7), "next");
			cursors.put($("next"), cursor);
		}
		return (Cursor) cursors.get($("next"));
	}

	/**
	 * Answer an image of next cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage NextCursorImage() {
		if (images.containsKey($("next")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0001001100000000";
			imageString += "0001001110000000";
			imageString += "0001001111000000";
			imageString += "0001001101100000";
			imageString += "0001001100110000";
			imageString += "0001001100011000";
			imageString += "0001001100011000";
			imageString += "0001001100110000";
			imageString += "0001001101100000";
			imageString += "0001001111000000";
			imageString += "0001001110000000";
			imageString += "0001001100000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0001001100000000";
			maskString += "0011111110000000";
			maskString += "0011111111000000";
			maskString += "0011111111100000";
			maskString += "0011111111110000";
			maskString += "0011111111111000";
			maskString += "0011111110111100";
			maskString += "0011111110111100";
			maskString += "0011111111111000";
			maskString += "0011111111110000";
			maskString += "0011111111100000";
			maskString += "0011111111000000";
			maskString += "0011111110000000";
			maskString += "0001001100000000";
			maskString += "0000000000000000";

			images.put($("next"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("next"));
	}

	/**
	 * Answer a normal cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Smalltalk cursors
	 */
	public static final Cursor NormalCursor() {
		if (cursors.containsKey($("normal")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(NormalCursorImage()), new Point(1, 1), "normal");
			cursors.put($("normal"), cursor);
		}
		return (Cursor) cursors.get($("normal"));
	}

	/**
	 * Answer an image of normal cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage NormalCursorImage() {
		if (images.containsKey($("normal")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000010000000000";
			imageString += "0000011000000000";
			imageString += "0000011100000000";
			imageString += "0000011110000000";
			imageString += "0000011111000000";
			imageString += "0000011111100000";
			imageString += "0000011111110000";
			imageString += "0000011111000000";
			imageString += "0000011111000000";
			imageString += "0000010011000000";
			imageString += "0000000001100000";
			imageString += "0000000001100000";
			imageString += "0000000000110000";
			imageString += "0000000000110000";
			imageString += "0000000000000000)";

			String maskString = "";
			maskString += "0000110000000000";
			maskString += "0000111000000000";
			maskString += "0000111100000000";
			maskString += "0000111110000000";
			maskString += "0000111111000000";
			maskString += "0000111111100000";
			maskString += "0000111111110000";
			maskString += "0000111111111000";
			maskString += "0000111111100000";
			maskString += "0000111111100000";
			maskString += "0000111111100000";
			maskString += "0000100011110000";
			maskString += "0000000011110000";
			maskString += "0000000001111000";
			maskString += "0000000001111000";
			maskString += "0000000000110000";

			images.put($("normal"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("normal"));
	}

	/**
	 * Answer a normal minus cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor NormalMinusCursor() {
		if (cursors.containsKey($("normalMinus")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(NormalMinusCursorImage()), new Point(1, 1), "normalMinus");
			cursors.put($("normalMinus"), cursor);
		}
		return (Cursor) cursors.get($("normalMinus"));
	}

	/**
	 * Answer an image of normal minus cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage NormalMinusCursorImage() {
		if (images.containsKey($("normalMinus")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0100000000000000";
			imageString += "0110000000000000";
			imageString += "0111000000000000";
			imageString += "0111100000000000";
			imageString += "0111110000000000";
			imageString += "0111111000000000";
			imageString += "0111111100000000";
			imageString += "0111110000000000";
			imageString += "0111110000000000";
			imageString += "0100110000000000";
			imageString += "0000011000000000";
			imageString += "0000011000111110";
			imageString += "0000001100000000";
			imageString += "0000001100000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0100000000000000";
			maskString += "1110000000000000";
			maskString += "1111000000000000";
			maskString += "1111100000000000";
			maskString += "1111110000000000";
			maskString += "1111111000000000";
			maskString += "1111111100000000";
			maskString += "1111111110000000";
			maskString += "1111111100000000";
			maskString += "1111111000000000";
			maskString += "1111111000000000";
			maskString += "0100111100111110";
			maskString += "0000111101111111";
			maskString += "0000011110111110";
			maskString += "0000011110000000";
			maskString += "0000001100000000";

			images.put($("normalMinus"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("normalMinus"));
	}

	/**
	 * Answer an normal oblique cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Arrow cursors
	 */
	public static final Cursor NormalObliqueCursor() {
		if (cursors.containsKey($("normalOblique")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(NormalObliqueCursorImage()), new Point(7, 7), "normalOblique");
			cursors.put($("normalOblique"), cursor);
		}
		return (Cursor) cursors.get($("normalOblique"));
	}

	/**
	 * Answer an image of normal oblique cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage NormalObliqueCursorImage() {
		if (images.containsKey($("normalOblique")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000001111000";
			imageString += "0000000000011000";
			imageString += "0000000000101000";
			imageString += "0000000001001000";
			imageString += "0000000010000000";
			imageString += "0000000100000000";
			imageString += "0001001000000000";
			imageString += "0001010000000000";
			imageString += "0001100000000000";
			imageString += "0001111000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000001111000";
			maskString += "0000000011111100";
			maskString += "0000000001111100";
			maskString += "0000000001111100";
			maskString += "0000000011111100";
			maskString += "0000000111001000";
			maskString += "0001001110000000";
			maskString += "0011111100000000";
			maskString += "0011111000000000";
			maskString += "0011111000000000";
			maskString += "0011111100000000";
			maskString += "0001111000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("normalOblique"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("normalOblique"));
	}

	/**
	 * Answer a normal plus cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor NormalPlusCursor() {
		if (cursors.containsKey($("normalPlus")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(NormalPlusCursorImage()), new Point(1, 1), "normalPlus");
			cursors.put($("normalPlus"), cursor);
		}
		return (Cursor) cursors.get($("normalPlus"));
	}

	/**
	 * Answer an image of normal plus cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage NormalPlusCursorImage() {
		if (images.containsKey($("normalPlus")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0100000000000000";
			imageString += "0110000000000000";
			imageString += "0111000000000000";
			imageString += "0111100000000000";
			imageString += "0111110000000000";
			imageString += "0111111000000000";
			imageString += "0111111100000000";
			imageString += "0111110000000000";
			imageString += "0111110000000000";
			imageString += "0100110000001000";
			imageString += "0000011000001000";
			imageString += "0000011000111110";
			imageString += "0000001100001000";
			imageString += "0000001100001000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0100000000000000";
			maskString += "1110000000000000";
			maskString += "1111000000000000";
			maskString += "1111100000000000";
			maskString += "1111110000000000";
			maskString += "1111111000000000";
			maskString += "1111111100000000";
			maskString += "1111111110000000";
			maskString += "1111111100000000";
			maskString += "1111111000001000";
			maskString += "1111111000011100";
			maskString += "0100111100111110";
			maskString += "0000111101111111";
			maskString += "0000011110111110";
			maskString += "0000011110011100";
			maskString += "0000001100001000";

			images.put($("normalPlus"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("normalPlus"));
	}

	/**
	 * Answer a paint cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Stationery cursors
	 */
	public static final Cursor PaintCursor() {
		if (cursors.containsKey($("paint")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(PaintCursorImage()), new Point(13, 14), "paint");
			cursors.put($("paint"), cursor);
		}
		return (Cursor) cursors.get($("paint"));
	}

	/**
	 * Answer an image of paint cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage PaintCursorImage() {
		if (images.containsKey($("paint")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000011100000000";
			imageString += "0000100110000000";
			imageString += "0000101011000000";
			imageString += "0000110010110000";
			imageString += "0000100010011100";
			imageString += "0001000010001110";
			imageString += "0010000101000110";
			imageString += "0100000010000110";
			imageString += "0100000000001110";
			imageString += "0010000000010110";
			imageString += "0001000000100110";
			imageString += "0000100001000110";
			imageString += "0000010010000110";
			imageString += "0000001100000100";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000011100000000";
			maskString += "0000111110000000";
			maskString += "0001111111000000";
			maskString += "0001111111110000";
			maskString += "0001111111111100";
			maskString += "0001111111111110";
			maskString += "0011111111111111";
			maskString += "0111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "0111111111111111";
			maskString += "0011111111111111";
			maskString += "0001111111101111";
			maskString += "0000111111001111";
			maskString += "0000011110001110";
			maskString += "0000001100000100";

			images.put($("paint"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("paint"));
	}

	/**
	 * Answer a panda cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Animal cursors
	 */
	public static final Cursor PandaCursor() {
		if (cursors.containsKey($("panda")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(PandaCursorImage()), new Point(7, 9), "panda");
			cursors.put($("panda"), cursor);
		}
		return (Cursor) cursors.get($("panda"));
	}

	/**
	 * Answer an image of panda cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage PandaCursorImage() {
		if (images.containsKey($("panda")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0011100000011100";
			imageString += "0111111111111110";
			imageString += "0111100000011110";
			imageString += "0110000000000110";
			imageString += "0010111001110100";
			imageString += "0110111001110110";
			imageString += "0101101001011010";
			imageString += "0101110110111010";
			imageString += "0101110110111010";
			imageString += "0100110000110010";
			imageString += "0110000110000110";
			imageString += "0011000000001100";
			imageString += "0001111111111000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0011100000011100";
			maskString += "0111111111111110";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "0111111111111110";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001111111111000";

			images.put($("panda"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("panda"));
	}

	/**
	 * Answer a paper cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Stationery cursors
	 */
	public static final Cursor PaperCursor() {
		if (cursors.containsKey($("paper")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(PaperCursorImage()), new Point(7, 7), "paper");
			cursors.put($("paper"), cursor);
		}
		return (Cursor) cursors.get($("paper"));
	}

	/**
	 * Answer an image of paper cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage PaperCursorImage() {
		if (images.containsKey($("paper")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0001111111111000";
			imageString += "0001000000001000";
			imageString += "0001011111101000";
			imageString += "0001000000001000";
			imageString += "0001011111101000";
			imageString += "0001000000001000";
			imageString += "0001011111101000";
			imageString += "0001000000001000";
			imageString += "0001011111101000";
			imageString += "0001000000001000";
			imageString += "0001011101111000";
			imageString += "0001000001010000";
			imageString += "0001000001100000";
			imageString += "0001111111000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0001111111111000";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0011111111111000";
			maskString += "0011111111110000";
			maskString += "0011111111100000";
			maskString += "0001111111000000";

			images.put($("paper"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("paper"));
	}

	/**
	 * Answer a pause cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Video cursors
	 */
	public static final Cursor PauseCursor() {
		if (cursors.containsKey($("pause")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(PauseCursorImage()), new Point(7, 7), "pause");
			cursors.put($("pause"), cursor);
		}
		return (Cursor) cursors.get($("pause"));
	}

	/**
	 * Answer an image of pause cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage PauseCursorImage() {
		if (images.containsKey($("pause")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000110000110000";
			imageString += "0000110000110000";
			imageString += "0000110000110000";
			imageString += "0000110000110000";
			imageString += "0000110000110000";
			imageString += "0000110000110000";
			imageString += "0000110000110000";
			imageString += "0000110000110000";
			imageString += "0000110000110000";
			imageString += "0000110000110000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000110000110000";
			maskString += "0001111001111000";
			maskString += "0001111001111000";
			maskString += "0001111001111000";
			maskString += "0001111001111000";
			maskString += "0001111001111000";
			maskString += "0001111001111000";
			maskString += "0001111001111000";
			maskString += "0001111001111000";
			maskString += "0001111001111000";
			maskString += "0001111001111000";
			maskString += "0000110000110000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("pause"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("pause"));
	}

	/**
	 * Answer a peak cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor PeakCursor() {
		if (cursors.containsKey($("peak")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(PeakCursorImage()), new Point(5, 10), "peak");
			cursors.put($("peak"), cursor);
		}
		return (Cursor) cursors.get($("peak"));
	}

	/**
	 * Answer an image of peak cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage PeakCursorImage() {
		if (images.containsKey($("peak")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000110000000";
			imageString += "0000001011000000";
			imageString += "0000010001100000";
			imageString += "0000100000110000";
			imageString += "0001000000011000";
			imageString += "0010000000001100";
			imageString += "0111111111111110";
			imageString += "0111111111111110";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000110000000";
			maskString += "0000001111000000";
			maskString += "0000011111100000";
			maskString += "0000111011110000";
			maskString += "0001110001111000";
			maskString += "0011100000111100";
			maskString += "0111111111111110";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "0111111111111110";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("peak"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("peak"));
	}

	/**
	 * Answer a pencil cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Stationery cursors
	 */
	public static final Cursor PencilCursor() {
		if (cursors.containsKey($("pencil")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(PencilCursorImage()), new Point(3, 14), "pencil");
			cursors.put($("pencil"), cursor);
		}
		return (Cursor) cursors.get($("pencil"));
	}

	/**
	 * Answer an image of pencil cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage PencilCursorImage() {
		if (images.containsKey($("pencil")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000111100000";
			imageString += "0000000100010000";
			imageString += "0000001000010000";
			imageString += "0000011100100000";
			imageString += "0000010011100000";
			imageString += "0000100001000000";
			imageString += "0000100010000000";
			imageString += "0001000010000000";
			imageString += "0001000100000000";
			imageString += "0001100100000000";
			imageString += "0001111000000000";
			imageString += "0001110000000000";
			imageString += "0001100000000000";
			imageString += "0001000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000111100000";
			maskString += "0000001111110000";
			maskString += "0000001111111000";
			maskString += "0000011111111000";
			maskString += "0000111111110000";
			maskString += "0000111111110000";
			maskString += "0001111111100000";
			maskString += "0001111111000000";
			maskString += "0011111111000000";
			maskString += "0011111110000000";
			maskString += "0011111110000000";
			maskString += "0011111100000000";
			maskString += "0011111000000000";
			maskString += "0011110000000000";
			maskString += "0011100000000000";
			maskString += "0001000000000000";

			images.put($("pencil"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("pencil"));
	}

	/**
	 * Answer a pencil minus cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Stationery cursors
	 */
	public static final Cursor PencilMinusCursor() {
		if (cursors.containsKey($("pencilMinus")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(PencilMinusCursorImage()), new Point(3, 14), "pencilMinus");
			cursors.put($("pencilMinus"), cursor);
		}
		return (Cursor) cursors.get($("pencilMinus"));
	}

	/**
	 * Answer an image of pencil minus cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage PencilMinusCursorImage() {
		if (images.containsKey($("pencilMinus")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000111100000";
			imageString += "0000000100010000";
			imageString += "0000001000010000";
			imageString += "0000011100100000";
			imageString += "0000010011100000";
			imageString += "0000100001000000";
			imageString += "0000100010000000";
			imageString += "0001000010000000";
			imageString += "0001000100000000";
			imageString += "0001100100000000";
			imageString += "0001111000000000";
			imageString += "0001110000111110";
			imageString += "0001100000000000";
			imageString += "0001000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000111100000";
			maskString += "0000001111110000";
			maskString += "0000001111111000";
			maskString += "0000011111111000";
			maskString += "0000111111110000";
			maskString += "0000111111110000";
			maskString += "0001111111100000";
			maskString += "0001111111000000";
			maskString += "0011111111000000";
			maskString += "0011111110000000";
			maskString += "0011111110000000";
			maskString += "0011111100111110";
			maskString += "0011111001111111";
			maskString += "0011110000111110";
			maskString += "0011100000000000";
			maskString += "0001000000000000";

			images.put($("pencilMinus"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("pencilMinus"));
	}

	/**
	 * Answer a pencil plus cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Stationery cursors
	 */
	public static final Cursor PencilPlusCursor() {
		if (cursors.containsKey($("pencilPlus")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(PencilPlusCursorImage()), new Point(3, 14), "pencilPlus");
			cursors.put($("pencilPlus"), cursor);
		}
		return (Cursor) cursors.get($("pencilPlus"));
	}

	/**
	 * Answer an image of pencil plus cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage PencilPlusCursorImage() {
		if (images.containsKey($("pencilPlus")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000111100000";
			imageString += "0000000100010000";
			imageString += "0000001000010000";
			imageString += "0000011100100000";
			imageString += "0000010011100000";
			imageString += "0000100001000000";
			imageString += "0000100010000000";
			imageString += "0001000010000000";
			imageString += "0001000100000000";
			imageString += "0001100100001000";
			imageString += "0001111000001000";
			imageString += "0001110000111110";
			imageString += "0001100000001000";
			imageString += "0001000000001000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000111100000";
			maskString += "0000001111110000";
			maskString += "0000001111111000";
			maskString += "0000011111111000";
			maskString += "0000111111110000";
			maskString += "0000111111110000";
			maskString += "0001111111100000";
			maskString += "0001111111000000";
			maskString += "0011111111000000";
			maskString += "0011111110001000";
			maskString += "0011111110011100";
			maskString += "0011111100111110";
			maskString += "0011111001111111";
			maskString += "0011110000111110";
			maskString += "0011100000011100";
			maskString += "0001000000001000";

			images.put($("pencilPlus"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("pencilPlus"));
	}

	/**
	 * Answer a pig cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Animal cursors
	 */
	public static final Cursor PigCursor() {
		if (cursors.containsKey($("pig")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(PigCursorImage()), new Point(3, 14), "pig");
			cursors.put($("pig"), cursor);
		}
		return (Cursor) cursors.get($("pig"));
	}

	/**
	 * Answer an image of pig cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage PigCursorImage() {
		if (images.containsKey($("pig")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0001000000001000";
			imageString += "0011100000011100";
			imageString += "0010111111110100";
			imageString += "0011110000111100";
			imageString += "0011000000001100";
			imageString += "0010110000110100";
			imageString += "0110100000010110";
			imageString += "0100011111100010";
			imageString += "0100110000110010";
			imageString += "0110101001010110";
			imageString += "0010110000110100";
			imageString += "0011011111101100";
			imageString += "0001110000111000";
			imageString += "0000011111100000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0001000000001000";
			maskString += "0011100000011100";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001111111111000";
			maskString += "0000011111100000";

			images.put($("pig"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("pig"));
	}

	/**
	 * Answer a play cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Video cursors
	 */
	public static final Cursor PlayCursor() {
		if (cursors.containsKey($("play")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(PlayCursorImage()), new Point(7, 7), "play");
			cursors.put($("play"), cursor);
		}
		return (Cursor) cursors.get($("play"));
	}

	/**
	 * Answer an image of play cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage PlayCursorImage() {
		if (images.containsKey($("play")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000011000000000";
			imageString += "0000011100000000";
			imageString += "0000011110000000";
			imageString += "0000011011000000";
			imageString += "0000011001100000";
			imageString += "0000011000110000";
			imageString += "0000011000110000";
			imageString += "0000011001100000";
			imageString += "0000011011000000";
			imageString += "0000011110000000";
			imageString += "0000011100000000";
			imageString += "0000011000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000011000000000";
			maskString += "0000111100000000";
			maskString += "0000111110000000";
			maskString += "0000111111000000";
			maskString += "0000111111100000";
			maskString += "0000111111110000";
			maskString += "0000111101111000";
			maskString += "0000111101111000";
			maskString += "0000111111110000";
			maskString += "0000111111100000";
			maskString += "0000111111000000";
			maskString += "0000111110000000";
			maskString += "0000111100000000";
			maskString += "0000011000000000";
			maskString += "0000000000000000";

			images.put($("play"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("play"));
	}

	/**
	 * Answer a point cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Transformation cursors
	 */
	public static final Cursor PointCursor() {
		if (cursors.containsKey($("point")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(PointCursorImage()), new Point(7, 7), "point");
			cursors.put($("point"), cursor);
		}
		return (Cursor) cursors.get($("point"));
	}

	/**
	 * Answer an image of point cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage PointCursorImage() {
		if (images.containsKey($("point")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000001111000000";
			imageString += "0000011111100000";
			imageString += "0000111000110000";
			imageString += "0000110110010000";
			imageString += "0000110110010000";
			imageString += "0000110000010000";
			imageString += "0000011000100000";
			imageString += "0000001111000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000001111000000";
			maskString += "0000011111100000";
			maskString += "0000111111110000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0000111111110000";
			maskString += "0000011111100000";
			maskString += "0000001111000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("point"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("point"));
	}

	/**
	 * Answer a previous cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Video cursors
	 */
	public static final Cursor PreviousCursor() {
		if (cursors.containsKey($("previous")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(PreviousCursorImage()), new Point(7, 7), "previous");
			cursors.put($("previous"), cursor);
		}
		return (Cursor) cursors.get($("previous"));
	}

	/**
	 * Answer an image of previous cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage PreviousCursorImage() {
		if (images.containsKey($("previous")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000011001000";
			imageString += "0000000111001000";
			imageString += "0000001111001000";
			imageString += "0000011011001000";
			imageString += "0000110011001000";
			imageString += "0001100011001000";
			imageString += "0001100011001000";
			imageString += "0000110011001000";
			imageString += "0000011011001000";
			imageString += "0000001111001000";
			imageString += "0000000111001000";
			imageString += "0000000011001000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000011001000";
			maskString += "0000000111111100";
			maskString += "0000001111111100";
			maskString += "0000011111111100";
			maskString += "0000111111111100";
			maskString += "0001111111111100";
			maskString += "0011110111111100";
			maskString += "0011110111111100";
			maskString += "0001111111111100";
			maskString += "0000111111111100";
			maskString += "0000011111111100";
			maskString += "0000001111111100";
			maskString += "0000000111111100";
			maskString += "0000000011001000";
			maskString += "0000000000000000";

			images.put($("previous"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("previous"));
	}

	/**
	 * Answer a prologue cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Video cursors
	 */
	public static final Cursor PrologueCursor() {
		if (cursors.containsKey($("prologue")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(PrologueCursorImage()), new Point(7, 7), "prologue");
			cursors.put($("prologue"), cursor);
		}
		return (Cursor) cursors.get($("prologue"));
	}

	/**
	 * Answer an image of prologue cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage PrologueCursorImage() {
		if (images.containsKey($("prologue")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0001000000011000";
			imageString += "0001000000111000";
			imageString += "0001000001111000";
			imageString += "0001000011011000";
			imageString += "0001000110011000";
			imageString += "0001001100011000";
			imageString += "0001001100011000";
			imageString += "0001000110011000";
			imageString += "0001000011011000";
			imageString += "0001000001111000";
			imageString += "0001000000111000";
			imageString += "0001000000011000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0001000000011000";
			maskString += "0011100000111100";
			maskString += "0011100001111100";
			maskString += "0011100011111100";
			maskString += "0011100111111100";
			maskString += "0011101111111100";
			maskString += "0011111110111100";
			maskString += "0011111110111100";
			maskString += "0011101111111100";
			maskString += "0011100111111100";
			maskString += "0011100011111100";
			maskString += "0011100001111100";
			maskString += "0011100000111100";
			maskString += "0001000000011000";
			maskString += "0000000000000000";

			images.put($("prologue"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("prologue"));
	}

	/**
	 * Answer a quarters2 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Arrow cursors
	 */
	public static final Cursor Quarters2Cursor() {
		if (cursors.containsKey($("quarters2")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Quarters2CursorImage()), new Point(7, 7), "quarters2");
			cursors.put($("quarters2"), cursor);
		}
		return (Cursor) cursors.get($("quarters2"));
	}

	/**
	 * Answer an image of quarters2 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Quarters2CursorImage() {
		if (images.containsKey($("quarters2")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001110000000";
			imageString += "0000011111000000";
			imageString += "0000000100000000";
			imageString += "0001000100010000";
			imageString += "0011000000011000";
			imageString += "0111110001111100";
			imageString += "0011000000011000";
			imageString += "0001000100010000";
			imageString += "0000000100000000";
			imageString += "0000011111000000";
			imageString += "0000001110000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000011111000000";
			maskString += "0000111111100000";
			maskString += "0001001110010000";
			maskString += "0011001110011000";
			maskString += "0111111011111100";
			maskString += "1111110001111110";
			maskString += "0111111011111100";
			maskString += "0011001110011000";
			maskString += "0001001110010000";
			maskString += "0000111111100000";
			maskString += "0000011111000000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";
			maskString += "0000000000000000";

			images.put($("quarters2"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("quarters2"));
	}

	/**
	 * Answer a quarters cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Arrow cursors
	 */
	public static final Cursor QuartersCursor() {
		if (cursors.containsKey($("quarters")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(QuartersCursorImage()), new Point(7, 7), "quarters");
			cursors.put($("quarters"), cursor);
		}
		return (Cursor) cursors.get($("quarters"));
	}

	/**
	 * Answer an image of quarters cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage QuartersCursorImage() {
		if (images.containsKey($("quarters")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001110000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0010000000001000";
			imageString += "0111110001111100";
			imageString += "0010000000001000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000001110000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000011111000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0010001110001000";
			maskString += "0111111011111100";
			maskString += "1111110001111110";
			maskString += "0111111011111100";
			maskString += "0010001110001000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000011111000000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";
			maskString += "0000000000000000";

			images.put($("quarters"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("quarters"));
	}

	/**
	 * Answer a read cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Cursors
	 */
	public static final Cursor ReadCursor() {
		if (cursors.containsKey($("read")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(ReadCursorImage()), new Point(5, 10), "read");
			cursors.put($("read"), cursor);
		}
		return (Cursor) cursors.get($("read"));
	}

	/**
	 * Answer an image of read cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage ReadCursorImage() {
		if (images.containsKey($("read")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000110000000110";
			imageString += "0001001000001001";
			imageString += "0001001000001001";
			imageString += "0010000000010000";
			imageString += "0100000000100000";
			imageString += "1111101111100000";
			imageString += "1000010000100000";
			imageString += "1000010000100000";
			imageString += "1011010110100000";
			imageString += "0111101111000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0001000000001000";
			maskString += "0010010000010010";
			maskString += "0010010000010010";
			maskString += "0100000000100000";
			maskString += "1000000001000000";
			maskString += "0000000000000000";
			maskString += "0111101111000000";
			maskString += "0111101111000000";
			maskString += "0100101001000000";
			maskString += "0000010000000000";
			maskString += "0111101111000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("read"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("read"));
	}

	/**
	 * Answer a repeat cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Arrow cursors
	 */
	public static final Cursor RepeatCursor() {
		if (cursors.containsKey($("repeat")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(RepeatCursorImage()), new Point(7, 7), "repeat");
			cursors.put($("repeat"), cursor);
		}
		return (Cursor) cursors.get($("repeat"));
	}

	/**
	 * Answer an image of repeat cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage RepeatCursorImage() {
		if (images.containsKey($("repeat")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000000110000000";
			imageString += "0001111111111000";
			imageString += "0011000110001100";
			imageString += "0010000100000100";
			imageString += "0010000000000100";
			imageString += "0011000000001100";
			imageString += "0001111111111000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0001111111111000";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "0111001110001110";
			maskString += "0111000100001110";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001111111111000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("repeat"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("repeat"));
	}

	/**
	 * Answer a right arrow cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Arrow cursors
	 */
	public static final Cursor RightArrowCursor() {
		if (cursors.containsKey($("rightArrow")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(RightArrowCursorImage()), new Point(7, 7), "rightArrow");
			cursors.put($("rightArrow"), cursor);
		}
		return (Cursor) cursors.get($("rightArrow"));
	}

	/**
	 * Answer an image of right arrow cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage RightArrowCursorImage() {
		if (images.containsKey($("rightArrow")) == false) {
			images.put($("rightArrow"), ((StImage) new StImage(ArrowCursorImage()).clone()).image());
		}
		return (BufferedImage) images.get($("rightArrow"));
	}

	/**
	 * Answer a right click cordless mouse cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Mouse cursors
	 */
	public static final Cursor RightClickCordlessMouseCursor() {
		if (cursors.containsKey($("rightClickCordlessMouse")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(RightClickCordlessMouseCursorImage()), new Point(7, 7), "rightClickCordlessMouse");
			cursors.put($("rightClickCordlessMouse"), cursor);
		}
		return (Cursor) cursors.get($("rightClickCordlessMouse"));
	}

	/**
	 * Answer an image of right click cordless mouse cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage RightClickCordlessMouseCursorImage() {
		if (images.containsKey($("rightClickCordlessMouse")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000011111100000";
			imageString += "0000110011110000";
			imageString += "0001100011111000";
			imageString += "0001000011111000";
			imageString += "0011000011111100";
			imageString += "0010000011111100";
			imageString += "0010000011111100";
			imageString += "0011111111111100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0011000000001100";
			imageString += "0001100000011000";
			imageString += "0000111111110000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000011111100000";
			maskString += "0000111111110000";
			maskString += "0001111111111000";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001111111111000";
			maskString += "0000111111110000";

			images.put($("rightClickCordlessMouse"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("rightClickCordlessMouse"));
	}

	/**
	 * Answer a right click mouse cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Mouse cursors
	 */
	public static final Cursor RightClickMouseCursor() {
		if (cursors.containsKey($("rightClickMouse")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(RightClickMouseCursorImage()), new Point(7, 7), "rightClickMouse");
			cursors.put($("rightClickMouse"), cursor);
		}
		return (Cursor) cursors.get($("rightClickMouse"));
	}

	/**
	 * Answer an image of right click mouse cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage RightClickMouseCursorImage() {
		if (images.containsKey($("rightClickMouse")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0001111110000000";
			imageString += "0011000010000000";
			imageString += "0000011111100000";
			imageString += "0000110011110000";
			imageString += "0001100011111000";
			imageString += "0001000011111000";
			imageString += "0011000011111100";
			imageString += "0010000011111100";
			imageString += "0011111111111100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0011000000001100";
			imageString += "0001100000011000";
			imageString += "0000111111110000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0001111110000000";
			maskString += "0011111111000000";
			maskString += "0111111111100000";
			maskString += "0011111111110000";
			maskString += "0001111111111000";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001111111111000";
			maskString += "0000111111110000";

			images.put($("rightClickMouse"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("rightClickMouse"));
	}

	/**
	 * Answer a rotate cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Transformation cursors
	 */
	public static final Cursor RotateCursor() {
		if (cursors.containsKey($("rotate")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(RotateCursorImage()), new Point(7, 7), "rotate");
			cursors.put($("rotate"), cursor);
		}
		return (Cursor) cursors.get($("rotate"));
	}

	/**
	 * Answer an image of rotate cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage RotateCursorImage() {
		if (images.containsKey($("rotate")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0100000000011100";
			imageString += "0010000000011000";
			imageString += "0001000000010100";
			imageString += "0000101111000110";
			imageString += "0010011111100010";
			imageString += "0110111000110010";
			imageString += "0100110000010010";
			imageString += "0100110010010010";
			imageString += "0100110001010110";
			imageString += "0100011000100100";
			imageString += "0110001111010000";
			imageString += "0010100000001000";
			imageString += "0001100000000100";
			imageString += "0011100000000010";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0100000000011100";
			maskString += "1110000000111110";
			maskString += "0111000000111100";
			maskString += "0011101111111110";
			maskString += "0011111111111111";
			maskString += "0111111111110111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "1110111111111110";
			maskString += "1111111111111100";
			maskString += "0111111111011100";
			maskString += "0011110000001110";
			maskString += "0111110000000111";
			maskString += "0011100000000010";

			images.put($("rotate"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("rotate"));
	}

	/**
	 * Answer a roundtrip cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Arrow cursors
	 */
	public static final Cursor RoundtripCursor() {
		if (cursors.containsKey($("roundtrip")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(RoundtripCursorImage()), new Point(7, 7), "roundtrip");
			cursors.put($("roundtrip"), cursor);
		}
		return (Cursor) cursors.get($("roundtrip"));
	}

	/**
	 * Answer an image of roundtrip cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage RoundtripCursorImage() {
		if (images.containsKey($("roundtrip")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000010000";
			imageString += "0000000000011000";
			imageString += "0011111111111100";
			imageString += "0000000000011000";
			imageString += "0000000000010000";
			imageString += "0000100000000000";
			imageString += "0001100000000000";
			imageString += "0011111111111100";
			imageString += "0001100000000000";
			imageString += "0000100000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000000000010000";
			maskString += "0000000000111000";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0000100000111000";
			maskString += "0001110000010000";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001110000000000";
			maskString += "0000100000000000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("roundtrip"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("roundtrip"));
	}

	/**
	 * Answer a scale cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Transformation cursors
	 */
	public static final Cursor ScaleCursor() {
		if (cursors.containsKey($("scale")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(ScaleCursorImage()), new Point(7, 7), "scale");
			cursors.put($("scale"), cursor);
		}
		return (Cursor) cursors.get($("scale"));
	}

	/**
	 * Answer an image of scale cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage ScaleCursorImage() {
		if (images.containsKey($("scale")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0111000000001110";
			imageString += "0110000000000110";
			imageString += "0101000000001010";
			imageString += "0000101111010000";
			imageString += "0000011111100000";
			imageString += "0000111000110000";
			imageString += "0000110110010000";
			imageString += "0000110110010000";
			imageString += "0000110000010000";
			imageString += "0000011000100000";
			imageString += "0000101111010000";
			imageString += "0101000000001010";
			imageString += "0110000000000110";
			imageString += "0111000000001110";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0111000000001110";
			maskString += "1111100000011111";
			maskString += "1111000000001111";
			maskString += "1111101111011111";
			maskString += "0101111111111010";
			maskString += "0000111111110000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0000111111110000";
			maskString += "0101111111111010";
			maskString += "1111101111011111";
			maskString += "1111000000001111";
			maskString += "1111100000011111";
			maskString += "0111000000001110";

			images.put($("scale"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("scale"));
	}

	/**
	 * Answer a scissors cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Stationery cursors
	 */
	public static final Cursor ScissorsCursor() {
		if (cursors.containsKey($("scissors")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(ScissorsCursorImage()), new Point(7, 8), "scissors");
			cursors.put($("scissors"), cursor);
		}
		return (Cursor) cursors.get($("scissors"));
	}

	/**
	 * Answer an image of scissors cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage ScissorsCursorImage() {
		if (images.containsKey($("scissors")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000001010000000";
			imageString += "0000011011000000";
			imageString += "0000011011000000";
			imageString += "0000011011000000";
			imageString += "0000011011000000";
			imageString += "0000001010000000";
			imageString += "0000001110000000";
			imageString += "0000001010000000";
			imageString += "0000001110000000";
			imageString += "0000011011000000";
			imageString += "0000101010100000";
			imageString += "0001001010010000";
			imageString += "0001001010010000";
			imageString += "0000111011100000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000001010000000";
			maskString += "0000011111000000";
			maskString += "0000111111100000";
			maskString += "0000111111100000";
			maskString += "0000111111100000";
			maskString += "0000111111100000";
			maskString += "0000011111000000";
			maskString += "0000011111000000";
			maskString += "0000011111000000";
			maskString += "0000011111000000";
			maskString += "0000111111100000";
			maskString += "0001111111110000";
			maskString += "0011111111111000";
			maskString += "0011111111111000";
			maskString += "0001111111110000";
			maskString += "0000111011100000";

			images.put($("scissors"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("scissors"));
	}

	/**
	 * Answer a stopwatch cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Stopwatch cursors
	 */
	public static final Cursor StopwatchCursor() {
		if (cursors.containsKey($("stopwatch")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(StopwatchCursorImage()), new Point(7, 9), "stopwatch");
			cursors.put($("stopwatch"), cursor);
		}
		return (Cursor) cursors.get($("stopwatch"));
	}

	/**
	 * Answer an image of stopwatch cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage StopwatchCursorImage() {
		if (images.containsKey($("stopwatch")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000011111000000";
			imageString += "0000011111000000";
			imageString += "0110000100001100";
			imageString += "0110111111101100";
			imageString += "0011100100111000";
			imageString += "0010000000001000";
			imageString += "0110000100001100";
			imageString += "0100000100000100";
			imageString += "0110000100001100";
			imageString += "0100000000000100";
			imageString += "0110000000001100";
			imageString += "0010000000001000";
			imageString += "0011100100111000";
			imageString += "0000111111100000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000011111000000";
			maskString += "0000111111100000";
			maskString += "0110111111101100";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "0111111111111100";
			maskString += "0111111111111100";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "0111111111111100";
			maskString += "0111111111111100";
			maskString += "0011111111111000";
			maskString += "0000111111100000";

			images.put($("stopwatch"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("stopwatch"));
	}

	/**
	 * Answer a stopwatch memory4 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Stopwatch cursors
	 */
	public static final Cursor StopwatchMemory4Cursor() {
		if (cursors.containsKey($("stopwatchMemory4")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(StopwatchMemory4CursorImage()), new Point(7, 9), "stopwatchMemory4");
			cursors.put($("stopwatchMemory4"), cursor);
		}
		return (Cursor) cursors.get($("stopwatchMemory4"));
	}

	/**
	 * Answer an image of stopwatch memory4 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage StopwatchMemory4CursorImage() {
		if (images.containsKey($("stopwatchMemory4")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000011111000000";
			imageString += "0000011111000000";
			imageString += "0110000100000000";
			imageString += "0110111111111000";
			imageString += "0011100100111000";
			imageString += "0010000000001000";
			imageString += "0110000000001100";
			imageString += "0100000000000100";
			imageString += "0110000100001100";
			imageString += "0100000100000100";
			imageString += "0110000100001100";
			imageString += "0010000000001000";
			imageString += "0011100100111000";
			imageString += "0000111111100000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000011111000000";
			maskString += "0000111111100000";
			maskString += "0110111111100000";
			maskString += "1111111111111000";
			maskString += "1111111111111100";
			maskString += "0111111111111100";
			maskString += "0111111111111100";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "0111111111111100";
			maskString += "0111111111111100";
			maskString += "0011111111111000";
			maskString += "0000111111100000";

			images.put($("stopwatchMemory4"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("stopwatchMemory4"));
	}

	/**
	 * Answer a stopwatch memory cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Stopwatch cursors
	 */
	public static final Cursor StopwatchMemoryCursor() {
		if (cursors.containsKey($("stopwatchMemory")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(StopwatchMemoryCursorImage()), new Point(7, 9), "stopwatchMemory");
			cursors.put($("stopwatchMemory"), cursor);
		}
		return (Cursor) cursors.get($("stopwatchMemory"));
	}

	/**
	 * Answer an image of stopwatch memory cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage StopwatchMemoryCursorImage() {
		if (images.containsKey($("stopwatchMemory")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000011111000000";
			imageString += "0000011111000000";
			imageString += "0110000100000000";
			imageString += "0110111111111000";
			imageString += "0011100100111000";
			imageString += "0010000000001000";
			imageString += "0110000100001100";
			imageString += "0100000100000100";
			imageString += "0110000100001100";
			imageString += "0100000000000100";
			imageString += "0110000000001100";
			imageString += "0010000000001000";
			imageString += "0011100100111000";
			imageString += "0000111111100000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000011111000000";
			maskString += "0000111111100000";
			maskString += "0110111111100000";
			maskString += "1111111111111000";
			maskString += "1111111111111100";
			maskString += "0111111111111100";
			maskString += "0111111111111100";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "0111111111111100";
			maskString += "0111111111111100";
			maskString += "0011111111111000";
			maskString += "0000111111100000";

			images.put($("stopwatchMemory"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("stopwatchMemory"));
	}

	/**
	 * Answer a stopwatch push4 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Stopwatch cursors
	 */
	public static final Cursor StopwatchPush4Cursor() {
		if (cursors.containsKey($("stopwatchPush4")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(StopwatchPush4CursorImage()), new Point(7, 9), "stopwatchPush4");
			cursors.put($("stopwatchPush4"), cursor);
		}
		return (Cursor) cursors.get($("stopwatchPush4"));
	}

	/**
	 * Answer an image of stopwatch push4 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage StopwatchPush4CursorImage() {
		if (images.containsKey($("stopwatchPush4")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000011111000000";
			imageString += "0110011111001100";
			imageString += "0110111111101100";
			imageString += "0011100100111000";
			imageString += "0010000000001000";
			imageString += "0110000000001100";
			imageString += "0100000000000100";
			imageString += "0110000100001100";
			imageString += "0100000100000100";
			imageString += "0110000100001100";
			imageString += "0010000000001000";
			imageString += "0011100100111000";
			imageString += "0000111111100000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000011111000000";
			maskString += "0110111111101100";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "0111111111111100";
			maskString += "0111111111111100";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "0111111111111100";
			maskString += "0111111111111100";
			maskString += "0011111111111000";
			maskString += "0000111111100000";

			images.put($("stopwatchPush4"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("stopwatchPush4"));
	}

	/**
	 * Answer a stopwatch push cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Stopwatch cursors
	 */
	public static final Cursor StopwatchPushCursor() {
		if (cursors.containsKey($("stopwatchPush")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(StopwatchPushCursorImage()), new Point(7, 9), "stopwatchPush");
			cursors.put($("stopwatchPush"), cursor);
		}
		return (Cursor) cursors.get($("stopwatchPush"));
	}

	/**
	 * Answer an image of stopwatch push cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage StopwatchPushCursorImage() {
		if (images.containsKey($("stopwatchPush")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000011111000000";
			imageString += "0110011111001100";
			imageString += "0110111111101100";
			imageString += "0011100100111000";
			imageString += "0010000000001000";
			imageString += "0110000100001100";
			imageString += "0100000100000100";
			imageString += "0110000100001100";
			imageString += "0100000000000100";
			imageString += "0110000000001100";
			imageString += "0010000000001000";
			imageString += "0011100100111000";
			imageString += "0000111111100000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000011111000000";
			maskString += "0110111111101100";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "0111111111111100";
			maskString += "0111111111111100";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "0111111111111100";
			maskString += "0111111111111100";
			maskString += "0011111111111000";
			maskString += "0000111111100000";

			images.put($("stopwatchPush"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("stopwatchPush"));
	}

	/**
	 * Answer a stopwatch reset cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Stopwatch cursors
	 */
	public static final Cursor StopwatchResetCursor() {
		if (cursors.containsKey($("stopwatchReset")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(StopwatchResetCursorImage()), new Point(7, 9), "stopwatchReset");
			cursors.put($("stopwatchReset"), cursor);
		}
		return (Cursor) cursors.get($("stopwatchReset"));
	}

	/**
	 * Answer an image of stopwatch reset cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage StopwatchResetCursorImage() {
		if (images.containsKey($("stopwatchReset")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000011111000000";
			imageString += "0000011111000000";
			imageString += "0000000100001100";
			imageString += "0011111111101100";
			imageString += "0011100100111000";
			imageString += "0010000000001000";
			imageString += "0110000100001100";
			imageString += "0100000100000100";
			imageString += "0110000100001100";
			imageString += "0100000000000100";
			imageString += "0110000000001100";
			imageString += "0010000000001000";
			imageString += "0011100100111000";
			imageString += "0000111111100000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000011111000000";
			maskString += "0000111111100000";
			maskString += "0000111111101100";
			maskString += "0011111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111100";
			maskString += "0111111111111100";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111111111110";
			maskString += "0111111111111100";
			maskString += "0111111111111100";
			maskString += "0011111111111000";
			maskString += "0000111111100000";

			images.put($("stopwatchReset"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("stopwatchReset"));
	}

	/**
	 * Answer a speaker00 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Speaker cursors
	 */
	public static final Cursor Speaker00Cursor() {
		if (cursors.containsKey($("speaker00")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Speaker00CursorImage()), new Point(7, 7), "speaker00");
			cursors.put($("speaker00"), cursor);
		}
		return (Cursor) cursors.get($("speaker00"));
	}

	/**
	 * Answer an image of speaker00 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Speaker00CursorImage() {
		if (images.containsKey($("speaker00")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001100000000";
			imageString += "0000010100000000";
			imageString += "0000100100000000";
			imageString += "0001000100000000";
			imageString += "0110000100000000";
			imageString += "0100000100000000";
			imageString += "0100000100000000";
			imageString += "0110000100000000";
			imageString += "0001000100000000";
			imageString += "0000100100000000";
			imageString += "0000010100000000";
			imageString += "0000001100000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000011110000000";
			maskString += "0000111110000000";
			maskString += "0001111110000000";
			maskString += "0111111110000000";
			maskString += "1111111110000000";
			maskString += "1111111110000000";
			maskString += "1111111110000000";
			maskString += "1111111110000000";
			maskString += "0111111110000000";
			maskString += "0001111110000000";
			maskString += "0000111110000000";
			maskString += "0000011110000000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";

			images.put($("speaker00"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("speaker00"));
	}

	/**
	 * Answer a speaker01 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Speaker cursors
	 */
	public static final Cursor Speaker01Cursor() {
		if (cursors.containsKey($("speaker01")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Speaker01CursorImage()), new Point(7, 7), "speaker01");
			cursors.put($("speaker01"), cursor);
		}
		return (Cursor) cursors.get($("speaker01"));
	}

	/**
	 * Answer an image of speaker01 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Speaker01CursorImage() {
		if (images.containsKey($("speaker01")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001100000000";
			imageString += "0000010100000000";
			imageString += "0000100100000000";
			imageString += "0001000100000000";
			imageString += "0110000100100000";
			imageString += "0100000100000000";
			imageString += "0100000100000000";
			imageString += "0110000100100000";
			imageString += "0001000100000000";
			imageString += "0000100100000000";
			imageString += "0000010100000000";
			imageString += "0000001100000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000011110000000";
			maskString += "0000111110000000";
			maskString += "0001111110000000";
			maskString += "0111111110100000";
			maskString += "1111111111110000";
			maskString += "1111111110100000";
			maskString += "1111111110100000";
			maskString += "1111111111110000";
			maskString += "0111111110100000";
			maskString += "0001111110000000";
			maskString += "0000111110000000";
			maskString += "0000011110000000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";

			images.put($("speaker01"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("speaker01"));
	}

	/**
	 * Answer a speaker02 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Speaker cursors
	 */
	public static final Cursor Speaker02Cursor() {
		if (cursors.containsKey($("speaker02")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Speaker02CursorImage()), new Point(7, 7), "speaker02");
			cursors.put($("speaker02"), cursor);
		}
		return (Cursor) cursors.get($("speaker02"));
	}

	/**
	 * Answer an image of speaker02 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Speaker02CursorImage() {
		if (images.containsKey($("speaker02")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001100000000";
			imageString += "0000010100000000";
			imageString += "0000100100000000";
			imageString += "0001000100000000";
			imageString += "0110000100100000";
			imageString += "0100000100010000";
			imageString += "0100000100010000";
			imageString += "0110000100100000";
			imageString += "0001000100000000";
			imageString += "0000100100000000";
			imageString += "0000010100000000";
			imageString += "0000001100000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000011110000000";
			maskString += "0000111110000000";
			maskString += "0001111110000000";
			maskString += "0111111110100000";
			maskString += "1111111111110000";
			maskString += "1111111110111000";
			maskString += "1111111110111000";
			maskString += "1111111111110000";
			maskString += "0111111110100000";
			maskString += "0001111110000000";
			maskString += "0000111110000000";
			maskString += "0000011110000000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";

			images.put($("speaker02"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("speaker02"));
	}

	/**
	 * Answer a speaker03 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Speaker cursors
	 */
	public static final Cursor Speaker03Cursor() {
		if (cursors.containsKey($("speaker03")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Speaker03CursorImage()), new Point(7, 7), "speaker03");
			cursors.put($("speaker03"), cursor);
		}
		return (Cursor) cursors.get($("speaker03"));
	}

	/**
	 * Answer an image of speaker03 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Speaker03CursorImage() {
		if (images.containsKey($("speaker03")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001100000000";
			imageString += "0000010100000000";
			imageString += "0000100100000000";
			imageString += "0001000100100000";
			imageString += "0110000100100000";
			imageString += "0100000100010000";
			imageString += "0100000100010000";
			imageString += "0110000100100000";
			imageString += "0001000100100000";
			imageString += "0000100100000000";
			imageString += "0000010100000000";
			imageString += "0000001100000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000011110000000";
			maskString += "0000111110000000";
			maskString += "0001111110100000";
			maskString += "0111111111110000";
			maskString += "1111111111110000";
			maskString += "1111111110111000";
			maskString += "1111111110111000";
			maskString += "1111111111110000";
			maskString += "0111111111110000";
			maskString += "0001111110100000";
			maskString += "0000111110000000";
			maskString += "0000011110000000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";

			images.put($("speaker03"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("speaker03"));
	}

	/**
	 * Answer a speaker04 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Speaker cursors
	 */
	public static final Cursor Speaker04Cursor() {
		if (cursors.containsKey($("speaker04")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Speaker04CursorImage()), new Point(7, 7), "speaker04");
			cursors.put($("speaker04"), cursor);
		}
		return (Cursor) cursors.get($("speaker04"));
	}

	/**
	 * Answer an image of speaker04 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Speaker04CursorImage() {
		if (images.containsKey($("speaker04")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001100000000";
			imageString += "0000010100000000";
			imageString += "0000100100000000";
			imageString += "0001000100100000";
			imageString += "0110000100100100";
			imageString += "0100000100010000";
			imageString += "0100000100010000";
			imageString += "0110000100100100";
			imageString += "0001000100100000";
			imageString += "0000100100000000";
			imageString += "0000010100000000";
			imageString += "0000001100000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000011110000000";
			maskString += "0000111110000000";
			maskString += "0001111110100000";
			maskString += "0111111111110100";
			maskString += "1111111111111110";
			maskString += "1111111110111100";
			maskString += "1111111110111100";
			maskString += "1111111111111110";
			maskString += "0111111111110100";
			maskString += "0001111110100000";
			maskString += "0000111110000000";
			maskString += "0000011110000000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";

			images.put($("speaker04"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("speaker04"));
	}

	/**
	 * Answer a speaker05 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Speaker cursors
	 */
	public static final Cursor Speaker05Cursor() {
		if (cursors.containsKey($("speaker05")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Speaker05CursorImage()), new Point(7, 7), "speaker05");
			cursors.put($("speaker05"), cursor);
		}
		return (Cursor) cursors.get($("speaker05"));
	}

	/**
	 * Answer an image of speaker05 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Speaker05CursorImage() {
		if (images.containsKey($("speaker05")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001100000000";
			imageString += "0000010100000000";
			imageString += "0000100100001000";
			imageString += "0001000100100000";
			imageString += "0110000100100100";
			imageString += "0100000100010000";
			imageString += "0100000100010000";
			imageString += "0110000100100100";
			imageString += "0001000100100000";
			imageString += "0000100100001000";
			imageString += "0000010100000000";
			imageString += "0000001100000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000011110000000";
			maskString += "0000111110001000";
			maskString += "0001111110111100";
			maskString += "0111111111111100";
			maskString += "1111111111111110";
			maskString += "1111111110111100";
			maskString += "1111111110111100";
			maskString += "1111111111111110";
			maskString += "0111111111111100";
			maskString += "0001111110111100";
			maskString += "0000111110001000";
			maskString += "0000011110000000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";

			images.put($("speaker05"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("speaker05"));
	}

	/**
	 * Answer a speaker06 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Speaker cursors
	 */
	public static final Cursor Speaker06Cursor() {
		if (cursors.containsKey($("speaker06")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Speaker06CursorImage()), new Point(7, 7), "speaker06");
			cursors.put($("speaker06"), cursor);
		}
		return (Cursor) cursors.get($("speaker06"));
	}

	/**
	 * Answer an image of speaker06 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Speaker06CursorImage() {
		if (images.containsKey($("speaker06")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001100000000";
			imageString += "0000010100001000";
			imageString += "0000100100000000";
			imageString += "0001000100100100";
			imageString += "0110000100100000";
			imageString += "0100000100010000";
			imageString += "0100000100010000";
			imageString += "0110000100100000";
			imageString += "0001000100100100";
			imageString += "0000100100000000";
			imageString += "0000010100001000";
			imageString += "0000001100000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000011110001000";
			maskString += "0000111110011100";
			maskString += "0001111110101100";
			maskString += "0111111111111110";
			maskString += "1111111111110100";
			maskString += "1111111110111000";
			maskString += "1111111110111000";
			maskString += "1111111111110100";
			maskString += "0111111111111110";
			maskString += "0001111110101100";
			maskString += "0000111110011100";
			maskString += "0000011110001000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";

			images.put($("speaker06"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("speaker06"));
	}

	/**
	 * Answer a speaker07 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Speaker cursors
	 */
	public static final Cursor Speaker07Cursor() {
		if (cursors.containsKey($("speaker07")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Speaker07CursorImage()), new Point(7, 7), "speaker07");
			cursors.put($("speaker07"), cursor);
		}
		return (Cursor) cursors.get($("speaker07"));
	}

	/**
	 * Answer an image of speaker07 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Speaker07CursorImage() {
		if (images.containsKey($("speaker07")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001100010000";
			imageString += "0000010100001000";
			imageString += "0000100100000000";
			imageString += "0001000100100100";
			imageString += "0110000100100100";
			imageString += "0100000100010000";
			imageString += "0100000100010000";
			imageString += "0110000100100100";
			imageString += "0001000100100100";
			imageString += "0000100100000000";
			imageString += "0000010100001000";
			imageString += "0000001100010000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110010000";
			maskString += "0000011110111000";
			maskString += "0000111110011100";
			maskString += "0001111110101100";
			maskString += "0111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111110111100";
			maskString += "1111111110111100";
			maskString += "1111111111111110";
			maskString += "0111111111111110";
			maskString += "0001111110101100";
			maskString += "0000111110011100";
			maskString += "0000011110111000";
			maskString += "0000001110010000";
			maskString += "0000000100000000";

			images.put($("speaker07"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("speaker07"));
	}

	/**
	 * Answer a speaker08 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Speaker cursors
	 */
	public static final Cursor Speaker08Cursor() {
		if (cursors.containsKey($("speaker08")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Speaker08CursorImage()), new Point(7, 7), "speaker08");
			cursors.put($("speaker08"), cursor);
		}
		return (Cursor) cursors.get($("speaker08"));
	}

	/**
	 * Answer an image of speaker08 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Speaker08CursorImage() {
		if (images.containsKey($("speaker08")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001100010000";
			imageString += "0000010100001000";
			imageString += "0000100100000000";
			imageString += "0001000100100100";
			imageString += "0110000100100100";
			imageString += "0100000100010000";
			imageString += "0100000100010000";
			imageString += "0110000100100100";
			imageString += "0001000100100100";
			imageString += "0000100100000000";
			imageString += "0000010100001000";
			imageString += "0000001100010000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110010000";
			maskString += "0000011110111000";
			maskString += "0000111110011100";
			maskString += "0001111110101100";
			maskString += "0111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111110111100";
			maskString += "1111111110111100";
			maskString += "1111111111111110";
			maskString += "0111111111111110";
			maskString += "0001111110101100";
			maskString += "0000111110011100";
			maskString += "0000011110111000";
			maskString += "0000001110010000";
			maskString += "0000000100000000";

			images.put($("speaker08"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("speaker08"));
	}

	/**
	 * Answer a speaker09 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Speaker cursors
	 */
	public static final Cursor Speaker09Cursor() {
		if (cursors.containsKey($("speaker09")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Speaker09CursorImage()), new Point(7, 7), "speaker09");
			cursors.put($("speaker09"), cursor);
		}
		return (Cursor) cursors.get($("speaker09"));
	}

	/**
	 * Answer an image of speaker09 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Speaker09CursorImage() {
		if (images.containsKey($("speaker09")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001100010000";
			imageString += "0000010100001000";
			imageString += "0000100100000100";
			imageString += "0001000100100100";
			imageString += "0110000100100100";
			imageString += "0100000100010000";
			imageString += "0100000100010000";
			imageString += "0110000100100100";
			imageString += "0001000100100100";
			imageString += "0000100100000100";
			imageString += "0000010100001000";
			imageString += "0000001100010000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110010000";
			maskString += "0000011110111000";
			maskString += "0000111110011100";
			maskString += "0001111110101110";
			maskString += "0111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111110111100";
			maskString += "1111111110111100";
			maskString += "1111111111111110";
			maskString += "0111111111111110";
			maskString += "0001111110101110";
			maskString += "0000111110011100";
			maskString += "0000011110111000";
			maskString += "0000001110010000";
			maskString += "0000000100000000";

			images.put($("speaker09"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("speaker09"));
	}

	/**
	 * Answer a speaker10 cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Speaker cursors
	 */
	public static final Cursor Speaker10Cursor() {
		if (cursors.containsKey($("speaker10")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(Speaker10CursorImage()), new Point(7, 7), "speaker10");
			cursors.put($("speaker10"), cursor);
		}
		return (Cursor) cursors.get($("speaker10"));
	}

	/**
	 * Answer an image of speaker10 cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage Speaker10CursorImage() {
		if (images.containsKey($("speaker10")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001100010000";
			imageString += "0000010100001000";
			imageString += "0000100100000100";
			imageString += "0001000100100100";
			imageString += "0110000100100100";
			imageString += "0100000100010010";
			imageString += "0100000100010010";
			imageString += "0110000100100100";
			imageString += "0001000100100100";
			imageString += "0000100100000100";
			imageString += "0000010100001000";
			imageString += "0000001100010000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110010000";
			maskString += "0000011110111000";
			maskString += "0000111110011100";
			maskString += "0001111110101110";
			maskString += "0111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111110111111";
			maskString += "1111111110111111";
			maskString += "1111111111111110";
			maskString += "0111111111111110";
			maskString += "0001111110101110";
			maskString += "0000111110011100";
			maskString += "0000011110111000";
			maskString += "0000001110010000";
			maskString += "0000000100000000";

			images.put($("speaker10"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("speaker10"));
	}

	/**
	 * Answer a speaker cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Speaker cursors
	 */
	public static final Cursor SpeakerCursor() {
		if (cursors.containsKey($("speaker")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(SpeakerCursorImage()), new Point(7, 7), "speaker");
			cursors.put($("speaker"), cursor);
		}
		return (Cursor) cursors.get($("speaker"));
	}

	/**
	 * Answer an image of speaker cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage SpeakerCursorImage() {
		if (images.containsKey($("speaker")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001100010000";
			imageString += "0000010100001000";
			imageString += "0000100100000100";
			imageString += "0001000100100100";
			imageString += "0110000100100100";
			imageString += "0100000100010010";
			imageString += "0100000100010010";
			imageString += "0110000100100100";
			imageString += "0001000100100100";
			imageString += "0000100100000100";
			imageString += "0000010100001000";
			imageString += "0000001100010000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000100000000";
			maskString += "0000001110010000";
			maskString += "0000011110111000";
			maskString += "0000111110011100";
			maskString += "0001111110101110";
			maskString += "0111111111111110";
			maskString += "1111111111111110";
			maskString += "1111111110111111";
			maskString += "1111111110111111";
			maskString += "1111111111111110";
			maskString += "0111111111111110";
			maskString += "0001111110101110";
			maskString += "0000111110011100";
			maskString += "0000011110111000";
			maskString += "0000001110010000";
			maskString += "0000000100000000";

			images.put($("speaker"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("speaker"));
	}

	/**
	 * Answer a spider cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Animal cursors
	 */
	public static final Cursor SpiderCursor() {
		if (cursors.containsKey($("spider")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(SpiderCursorImage()), new Point(7, 7), "spider");
			cursors.put($("spider"), cursor);
		}
		return (Cursor) cursors.get($("spider"));
	}

	/**
	 * Answer an image of spider cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage SpiderCursorImage() {
		if (images.containsKey($("spider")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000010000100000";
			imageString += "0010100110010100";
			imageString += "0010101111010100";
			imageString += "0001011111101000";
			imageString += "0000101111010000";
			imageString += "0011010110101100";
			imageString += "0100101111010010";
			imageString += "0101011111101010";
			imageString += "0001011111101000";
			imageString += "0001011111101000";
			imageString += "0010011111100100";
			imageString += "0010001111000100";
			imageString += "0010000000000100";
			imageString += "0001000000001000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000010000100000";
			maskString += "0010111111110100";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "1111111111111111";
			maskString += "1111111111111111";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "0111011111101110";
			maskString += "0111001111001110";
			maskString += "0011100000011100";
			maskString += "0001000000001000";

			images.put($("spider"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("spider"));
	}

	/**
	 * Answer a spuit cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Stationery cursors
	 */
	public static final Cursor SpuitCursor() {
		if (cursors.containsKey($("spuit")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(SpuitCursorImage()), new Point(2, 13), "spuit");
			cursors.put($("spuit"), cursor);
		}
		return (Cursor) cursors.get($("spuit"));
	}

	/**
	 * Answer an image of spuit cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage SpuitCursorImage() {
		if (images.containsKey($("spuit")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000011100";
			imageString += "0000000000111110";
			imageString += "0000000000111110";
			imageString += "0000000111111110";
			imageString += "0000000011111100";
			imageString += "0000000101110000";
			imageString += "0000001000110000";
			imageString += "0000010001010000";
			imageString += "0000100010000000";
			imageString += "0001000100000000";
			imageString += "0010001000000000";
			imageString += "0010010000000000";
			imageString += "0101100000000000";
			imageString += "0010000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000011100";
			maskString += "0000000000111110";
			maskString += "0000000001111111";
			maskString += "0000011111111111";
			maskString += "0000001111111111";
			maskString += "0000000111111110";
			maskString += "0000001111111100";
			maskString += "0000011111111000";
			maskString += "0000111111111000";
			maskString += "0001111111011000";
			maskString += "0011111110001000";
			maskString += "0111111100000000";
			maskString += "0111111000000000";
			maskString += "1101110000000000";
			maskString += "0111100000000000";
			maskString += "0010000000000000";

			images.put($("spuit"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("spuit"));
	}

	/**
	 * Answer a stop cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Video cursors
	 */
	public static final Cursor StopCursor() {
		if (cursors.containsKey($("stop")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(StopCursorImage()), new Point(7, 7), "stop");
			cursors.put($("stop"), cursor);
		}
		return (Cursor) cursors.get($("stop"));
	}

	/**
	 * Answer an image of stop cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage StopCursorImage() {
		if (images.containsKey($("stop")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000111111110000";
			imageString += "0000111111110000";
			imageString += "0000110000110000";
			imageString += "0000110000110000";
			imageString += "0000110000110000";
			imageString += "0000110000110000";
			imageString += "0000110000110000";
			imageString += "0000110000110000";
			imageString += "0000111111110000";
			imageString += "0000111111110000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000000000000";
			maskString += "0000111111110000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0001111001111000";
			maskString += "0001111001111000";
			maskString += "0001111001111000";
			maskString += "0001111001111000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0000111111110000";
			maskString += "0000000000000000";
			maskString += "0000000000000000";

			images.put($("stop"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("stop"));
	}

	/**
	 * Answer a takenoko cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Plant cursors
	 */
	public static final Cursor TakenokoCursor() {
		if (cursors.containsKey($("takenoko")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(TakenokoCursorImage()), new Point(7, 7), "takenoko");
			cursors.put($("takenoko"), cursor);
		}
		return (Cursor) cursors.get($("takenoko"));
	}

	/**
	 * Answer an image of takenoko cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage TakenokoCursorImage() {
		if (images.containsKey($("takenoko")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000011000000000";
			imageString += "0000001100000000";
			imageString += "0000001110000000";
			imageString += "0000001011000000";
			imageString += "0000001101000000";
			imageString += "0000011011100000";
			imageString += "0000010110100000";
			imageString += "0000010101110000";
			imageString += "0000111111010000";
			imageString += "0000100100010000";
			imageString += "0000101100010000";
			imageString += "0000101000010000";
			imageString += "0000101000010000";
			imageString += "0000111111110000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000011000000000";
			maskString += "0000111100000000";
			maskString += "0000011110000000";
			maskString += "0000011111000000";
			maskString += "0000011111100000";
			maskString += "0000011111100000";
			maskString += "0000111111110000";
			maskString += "0000111111110000";
			maskString += "0000111111111000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0000111111110000";

			images.put($("takenoko"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("takenoko"));
	}

	/**
	 * Answer a translate cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Transformation cursors
	 */
	public static final Cursor TranslateCursor() {
		if (cursors.containsKey($("translate")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(TranslateCursorImage()), new Point(7, 7), "translate");
			cursors.put($("translate"), cursor);
		}
		return (Cursor) cursors.get($("translate"));
	}

	/**
	 * Answer an image of translate cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage TranslateCursorImage() {
		if (images.containsKey($("translate")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0100000000010000";
			imageString += "0010000000001010";
			imageString += "0001000000000110";
			imageString += "0000101111001110";
			imageString += "0000011111100000";
			imageString += "0000111000110000";
			imageString += "0000110000010000";
			imageString += "0000110010010000";
			imageString += "0000110001010000";
			imageString += "0000011000100000";
			imageString += "0111001111010000";
			imageString += "0110000000001000";
			imageString += "0101000000000100";
			imageString += "0000100000000010";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0100000000010000";
			maskString += "1110000000111010";
			maskString += "0111000000011111";
			maskString += "0011101111001111";
			maskString += "0001111111111111";
			maskString += "0000111111111110";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0001111111111000";
			maskString += "0111111111110000";
			maskString += "1111111111111000";
			maskString += "1111001111011100";
			maskString += "1111100000001110";
			maskString += "0101110000000111";
			maskString += "0000100000000010";

			images.put($("translate"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("translate"));
	}

	/**
	 * Answer an up arrow cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Arrow cursors
	 */
	public static final Cursor UpArrowCursor() {
		if (cursors.containsKey($("upArrow")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(UpArrowCursorImage()), new Point(7, 7), "upArrow");
			cursors.put($("upArrow"), cursor);
		}
		return (Cursor) cursors.get($("upArrow"));
	}

	/**
	 * Answer an image of up arrow cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage UpArrowCursorImage() {
		if (images.containsKey($("upArrow")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001110000000";
			imageString += "0000011111000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000011111000000";
			maskString += "0000111111100000";
			maskString += "0000011111000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";
			maskString += "0000000000000000";

			images.put($("upArrow"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("upArrow"));
	}

	/**
	 * Answer an up cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Arrow cursors
	 */
	public static final Cursor UpCursor() {
		if (cursors.containsKey($("up")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(UpCursorImage()), new Point(7, 7), "up");
			cursors.put($("up"), cursor);
		}
		return (Cursor) cursors.get($("up"));
	}

	/**
	 * Answer an image of up cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage UpCursorImage() {
		if (images.containsKey($("up")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0100000000000000";
			imageString += "0110000000000000";
			imageString += "0111000000000000";
			imageString += "0111100000000000";
			imageString += "0111110000000000";
			imageString += "0111111000000000";
			imageString += "0110000000000000";
			imageString += "0110000000000000";
			imageString += "0110000000000000";
			imageString += "0110000000000000";
			imageString += "0110000000000000";
			imageString += "0110000000000000";
			imageString += "0110000000000000";
			imageString += "0110000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "1100000000000000";
			maskString += "1110000000000000";
			maskString += "1111000000000000";
			maskString += "1111100000000000";
			maskString += "1111110000000000";
			maskString += "1111111000000000";
			maskString += "1111111100000000";
			maskString += "1111111100000000";
			maskString += "1111000000000000";
			maskString += "1111000000000000";
			maskString += "1111000000000000";
			maskString += "1111000000000000";
			maskString += "1111000000000000";
			maskString += "1111000000000000";
			maskString += "1111000000000000";
			maskString += "1111000000000000";

			images.put($("up"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("up"));
	}

	/**
	 * Answer an up-down cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Arrow cursors
	 */
	public static final Cursor UpDownCursor() {
		if (cursors.containsKey($("upDown")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(UpDownCursorImage()), new Point(7, 7), "upDown");
			cursors.put($("upDown"), cursor);
		}
		return (Cursor) cursors.get($("upDown"));
	}

	/**
	 * Answer an image of up-down cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage UpDownCursorImage() {
		if (images.containsKey($("upDown")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000000000000000";
			imageString += "0000000100000000";
			imageString += "0000001110000000";
			imageString += "0000011111000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000000100000000";
			imageString += "0000011111000000";
			imageString += "0000001110000000";
			imageString += "0000000100000000";
			imageString += "0000000000000000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000000000000000";
			maskString += "0000000100000000";
			maskString += "0000001110000000";
			maskString += "0000011111000000";
			maskString += "0000111111100000";
			maskString += "0000011111000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000001110000000";
			maskString += "0000011111000000";
			maskString += "0000111111100000";
			maskString += "0000011111000000";
			maskString += "0000001110000000";
			maskString += "0000000100000000";
			maskString += "0000000000000000";

			images.put($("upDown"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("upDown"));
	}

	/**
	 * Answer a wheel cordless mouse cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Mouse cursors
	 */
	public static final Cursor WheelCordlessMouseCursor() {
		if (cursors.containsKey($("wheelCordlessMouse")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(WheelCordlessMouseCursorImage()), new Point(7, 7), "wheelCordlessMouse");
			cursors.put($("wheelCordlessMouse"), cursor);
		}
		return (Cursor) cursors.get($("wheelCordlessMouse"));
	}

	/**
	 * Answer an image of wheel cordless mouse cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage WheelCordlessMouseCursorImage() {
		if (images.containsKey($("wheelCordlessMouse")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0000011111100000";
			imageString += "0000110000110000";
			imageString += "0001100110011000";
			imageString += "0001000110001000";
			imageString += "0011000110001100";
			imageString += "0010000110000100";
			imageString += "0010000000000100";
			imageString += "0011111111111100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0011000000001100";
			imageString += "0001100000011000";
			imageString += "0000111111110000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0000011111100000";
			maskString += "0000111111110000";
			maskString += "0001111111111000";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001111111111000";
			maskString += "0000111111110000";

			images.put($("wheelCordlessMouse"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("wheelCordlessMouse"));
	}

	/**
	 * Answer a wheel mouse cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Mouse cursors
	 */
	public static final Cursor WheelMouseCursor() {
		if (cursors.containsKey($("wheelMouse")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(WheelMouseCursorImage()), new Point(7, 7), "wheelMouse");
			cursors.put($("wheelMouse"), cursor);
		}
		return (Cursor) cursors.get($("wheelMouse"));
	}

	/**
	 * Answer an image of wheel mouse cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage WheelMouseCursorImage() {
		if (images.containsKey($("wheelMouse")) == false) {
			String imageString = "";
			imageString += "0000000000000000";
			imageString += "0001111110000000";
			imageString += "0011000010000000";
			imageString += "0000011111100000";
			imageString += "0000110000110000";
			imageString += "0001100110011000";
			imageString += "0001000110001000";
			imageString += "0011000110001100";
			imageString += "0010000000000100";
			imageString += "0011111111111100";
			imageString += "0010000000000100";
			imageString += "0010000000000100";
			imageString += "0011000000001100";
			imageString += "0001100000011000";
			imageString += "0000111111110000";
			imageString += "0000000000000000";

			String maskString = "";
			maskString += "0001111110000000";
			maskString += "0011111111000000";
			maskString += "0111111111100000";
			maskString += "0011111111110000";
			maskString += "0001111111111000";
			maskString += "0011111111111100";
			maskString += "0011111111111100";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0111111111111110";
			maskString += "0011111111111100";
			maskString += "0001111111111000";
			maskString += "0000111111110000";

			images.put($("wheelMouse"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("wheelMouse"));
	}

	/**
	 * Answer an write cursor.
	 * 
	 * @return java.awt.Cursor
	 * @category Smalltalk cursors
	 */
	public static final Cursor WriteCursor() {
		if (cursors.containsKey($("write")) == false) {
			Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(_ResizeToFit(WriteCursorImage()), new Point(0, 0), "write");
			cursors.put($("write"), cursor);
		}
		return (Cursor) cursors.get($("write"));
	}

	/**
	 * Answer an image of write cursor.
	 * 
	 * @return java.awt.image.BufferedImage
	 * @category Cursor images
	 */
	public static final BufferedImage WriteCursorImage() {
		if (images.containsKey($("write")) == false) {
			String imageString = "";
			imageString += "0000000000000110";
			imageString += "0000000000001111";
			imageString += "0000000000010110";
			imageString += "0000000000100100";
			imageString += "0000000001001000";
			imageString += "0000000010010000";
			imageString += "0000000100100000";
			imageString += "0000001001000011";
			imageString += "0000010010000010";
			imageString += "0000100100000110";
			imageString += "0001001000001000";
			imageString += "0010010000001000";
			imageString += "0111100001001000";
			imageString += "0101000010111000";
			imageString += "0110000110000000";
			imageString += "1111111100000000";

			String maskString = "";
			maskString += "0000000000001111";
			maskString += "0000000000011111";
			maskString += "0000000000111110";
			maskString += "0000000001111100";
			maskString += "0000000011111000";
			maskString += "0000000111110000";
			maskString += "0000001111100011";
			maskString += "0000011111001111";
			maskString += "0000111110011111";
			maskString += "0001111100011111";
			maskString += "0011111000011110";
			maskString += "0111110011111110";
			maskString += "1111100111111110";
			maskString += "1111001111111110";
			maskString += "1111111111111100";
			maskString += "1111111111000000";

			images.put($("write"), _CreateImage(_Pixels(imageString, maskString)));
		}
		return (BufferedImage) images.get($("write"));
	}

	/**
	 * Restore the original cursor for all frames.
	 * 
	 * @category showing
	 */
	public void _restore() {
		if (_savedCursors == null) {
			return;
		}

		Frame[] frames = this._frames();
		for (int i = 0; i < frames.length; i++) {
			frames[i].setCursor(_savedCursors[i]);
		}
		_frames = null;
		_savedCursors = null;
	}

	/**
	 * Set the cursor for all frames.
	 * 
	 * @category showing
	 */
	public void _show() {
		Frame[] frames = this._frames();
		_savedCursors = new Cursor[frames.length];
		for (int i = 0; i < frames.length; i++) {
			_savedCursors[i] = frames[i].getCursor();
			frames[i].setCursor(_cursor);
		}
	}

	/**
	 * Answer the current frames.
	 * 
	 * @return java.awt.Frame[]
	 * @category private
	 */
	protected Frame[] _frames() {
		if (_frames == null) {
			_frames = Frame.getFrames();
		}
		return _frames;
	}

}
