package jp.co.sra.jun.goodies.colors;

import java.awt.*;
import java.awt.event.*;
import jp.co.sra.smalltalk.StSimpleDialogViewAwt;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunColorChoiceDialogViewAwt class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/04/02 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorChoiceDialogViewAwt.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorChoiceDialogViewAwt extends StSimpleDialogViewAwt implements JunColorChoiceDialogView {
	protected JunColorChoiceViewAwt colorChoiceView;
	protected Button acceptButton;
	protected Button cancelButton;

	/**
	 * Create a new instance of JunColorChoiceDialogViewAwt and initialize it with the JunColorChoiceDialog.
	 * 
	 * @param newColorChoiceDialog jp.co.sra.jun.goodies.colors.JunColorChoiceDialog
	 * @category Instance creation
	 */
	public JunColorChoiceDialogViewAwt(JunColorChoiceDialog newColorChoiceDialog) {
		super(newColorChoiceDialog);
	}

	/**
	 * Answer my model as a JunColorChoiceDialog.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceDialog
	 * @category model accessing
	 */
	public JunColorChoiceDialog getColorChoiceDialog() {
		return (JunColorChoiceDialog) this.model();
	}

	/**
	 * Answer the panel on accept/cancel buttons.
	 * 
	 * @return java.awt.Panel
	 * @category interface opening
	 */
	protected Panel _acceptCancelButtons() {
		Panel panel = new Panel();
		panel.setLayout(new FlowLayout());
		panel.add(this.acceptButton());
		panel.add(this.cancelButton());

		return panel;
	}

	/**
	 * Answer my accpet button.
	 *
	 * @return java.awt.Button
	 * @category interface opening
	 */
	protected Button acceptButton() {
		if (acceptButton == null) {
			acceptButton = new Button(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getColorChoiceDialog().acceptButtonPressed()) {
						getColorChoiceDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Build this component.
	 * 
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new BorderLayout());
		this.add(this.colorChoiceView(), BorderLayout.CENTER);
		this.add(this._acceptCancelButtons(), BorderLayout.SOUTH);

		defaultButton = this.acceptButton();
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return java.awt.Button
	 * @category interface opening
	 */
	protected Button cancelButton() {
		if (cancelButton == null) {
			cancelButton = new Button(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getColorChoiceDialog().cancelButtonPressed()) {
						getColorChoiceDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Answer my color choice view.
	 *
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceViewAwt
	 * @category interface opening
	 */
	protected JunColorChoiceViewAwt colorChoiceView() {
		if (colorChoiceView == null) {
			colorChoiceView = new JunColorChoiceViewAwt(this.getColorChoiceDialog().colorChoiceModel());
		}
		return colorChoiceView;
	}
}
