package jp.co.sra.jun.goodies.colors;

import java.awt.Button;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jp.co.sra.smalltalk.StSimpleDialogViewAwt;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunColorBarDialogViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2004/06/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun492 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorBarDialogViewAwt.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorBarDialogViewAwt extends StSimpleDialogViewAwt implements JunColorBarDialogView {

	protected JunColorBarViewAwt colorBarView;
	protected Button acceptButton;
	protected Button cancelButton;

	/**
	 * Create a new instance of JunColorBarDialogViewAwt and initialize it.
	 * 
	 * @param aColorBarDialog jp.co.sra.jun.goodies.colors.JunColorBarDialog
	 * @category Instance creation
	 */
	public JunColorBarDialogViewAwt(JunColorBarDialog aColorBarDialog) {
		super(aColorBarDialog);
	}

	/**
	 * Answer my model as JunColorBarDialog.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorBarDialog
	 * @see jp.co.sra.jun.goodies.colors.JunColorBarDialogView#getColorBarDialog()
	 * @category model accessing
	 */
	public JunColorBarDialog getColorBarDialog() {
		return (JunColorBarDialog) this.model();
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.colorBarView(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, -50));
		this.add(this.acceptButton(), WindowSpecLayout.Position(0.25f, -44, 1f, -40, 0.25f, 44, 1f, -8));
		this.add(this.cancelButton(), WindowSpecLayout.Position(0.75f, -44, 1f, -40, 0.75f, 44, 1f, -8));
		this.setSize(238, 100);

		defaultButton = this.acceptButton();
	}

	/**
	 * Answer my color bar view.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorBarViewAwt
	 * @category user interface
	 */
	protected JunColorBarViewAwt colorBarView() {
		if (colorBarView == null) {
			colorBarView = new JunColorBarViewAwt(this.getColorBarDialog().colorBarModel());
		}
		return colorBarView;
	}

	/**
	 * Answer my accpet button.
	 *
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button acceptButton() {
		if (acceptButton == null) {
			acceptButton = new Button(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunColorBarDialogViewAwt.this.getColorBarDialog().acceptButtonPressed()) {
						JunColorBarDialogViewAwt.this.getColorBarDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button cancelButton() {
		if (cancelButton == null) {
			cancelButton = new Button(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunColorBarDialogViewAwt.this.getColorBarDialog().cancelButtonPressed()) {
						JunColorBarDialogViewAwt.this.getColorBarDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

}
