package jp.co.sra.jun.goodies.colors;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Vector;
import jp.co.sra.smalltalk.StColorValue;

/**
 * JunColorBarCollection class
 * 
 *  @author    nisinaka
 *  @created   2004/06/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun452 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorBarCollection.java,v 8.11 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorBarCollection extends JunColorBarModel {

	protected ArrayList colorCollection;

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		colorCollection = null;
	}

	/**
	 * Answer my current color collection.
	 * 
	 * @return java.util.ArrayList
	 * @category color accessing
	 */
	public ArrayList colorCollection() {
		if (colorCollection == null) {
			colorCollection = this.defaultColorCollection();
		}
		return colorCollection;
	}

	/**
	 * Set my new color collection.
	 * 
	 * @param newCollection java.util.ArrayList
	 * @category color accessing
	 */
	public void colorCollection_(ArrayList newCollection) {
		colorCollection = newCollection;
		this.changed_($("color"));
	}

	/**
	 * Set my new color collection.
	 * 
	 * @param newCollection java.awt.Color[]
	 * @category color accessing
	 */
	public void colorCollection_(Color[] newCollection) {
		ArrayList anArrayList = null;
		if (newCollection != null) {
			anArrayList = new ArrayList(newCollection.length);
			for (int i = 0; i < newCollection.length; i++) {
				anArrayList.add(newCollection[i]);
			}
		}
		this.colorCollection_(anArrayList);
	}

	/**
	 * Add a color to the collection.
	 * 
	 * @param aColor java.awt.Color
	 * @category color accessing
	 */
	public void addColor_(Color aColor) {
		this.colorCollection().add(aColor);
		this.changed_($("color"));
	}

	/**
	 * Answer my default color collection.
	 * 
	 * @return java.util.ArrayList
	 * @category defaults
	 */
	protected ArrayList defaultColorCollection() {
		Vector colorNames = StColorValue.ConstantNames();
		ArrayList aCollection = new ArrayList(colorNames.size());
		for (int i = 0; i < colorNames.size(); i++) {
			aCollection.add(StColorValue._GetColorByName_(colorNames.get(i).toString()));
		}
		return aCollection;
	}

	/**
	 * Answer the color which correspond to the normalized value.
	 * 
	 * @param normalizedValue double
	 * @return java.awt.Color
	 * @see jp.co.sra.jun.goodies.colors.JunColorBarModel#getColor_(double)
	 * @category private
	 */
	protected Color getColor_(double normalizedValue) {
		ArrayList aCollection = this.colorCollection();
		if (aCollection.isEmpty()) {
			return Color.white;
		}

		int index = (int) (aCollection.size() * normalizedValue);
		if (index >= aCollection.size()) {
			index = aCollection.size() - 1;
		}
		return (Color) aCollection.get(index);
	}

}
