package jp.co.sra.jun.goodies.calendar;

import java.awt.Dimension;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunCalendarTimeIntervalViewSwing class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarTimeIntervalViewSwing.java,v 8.12 2008/02/20 06:31:13 nisinaka Exp $
 */
public class JunCalendarTimeIntervalViewSwing extends JunAbstractViewJPanel implements JunCalendarTimeIntervalView {

	protected JunCalendarTimeViewSwing fromView;
	protected JunCalendarTimeViewSwing toView;

	/**
	 * Create a new instance of <code>JunCalendarTimeIntervalViewSwing</code> and initialize it.
	 * 
	 * @param aCalendarTimeIntervalModel JunCalendarTimeIntervalModel
	 * @category Instance creation
	 */
	public JunCalendarTimeIntervalViewSwing(JunCalendarTimeIntervalModel aCalendarTimeIntervalModel) {
		super(aCalendarTimeIntervalModel);
	}

	/**
	 * Answer a fromView.
	 *
	 * @return JunCalendarTimeViewSwing
	 * @category accessing
	 */
	public JunCalendarTimeViewSwing fromView() {
		if (fromView == null) {
			fromView = new JunCalendarTimeViewSwing(this.getModel().fromCalendarTimeModel());
		}
		return fromView;
	}

	/**
	 * Answer a toView.
	 *
	 * @return JunCalendarTimeViewSwing
	 * @category accessing
	 */
	public JunCalendarTimeViewSwing toView() {
		if (toView == null) {
			toView = new JunCalendarTimeViewSwing(this.getModel().toCalendarTimeModel());
		}
		return toView;
	}

	/**
	 * Get model.
	 *
	 * @return JunCalendarTimeModel
	 * @category accessing
	 */
	public JunCalendarTimeIntervalModel getModel() {
		return (JunCalendarTimeIntervalModel) this.model();
	}

	/**
	 * Build this component.
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.fromView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 0.5f, -1));
		this.add(this.toView(), WindowSpecLayout.Position(0f, 1, 0.5f, 1, 1f, -1, 1f, -1));
		this.setPreferredSize(new Dimension(150, 401));
		this.setMinimumSize(new Dimension(150, 300));
		this.setMaximumSize(new Dimension(300, 600));
	}

}
