package jp.co.sra.jun.goodies.calendar;

import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunCalendarTimeIntervalViewAwt class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarTimeIntervalViewAwt.java,v 8.12 2008/02/20 06:31:13 nisinaka Exp $
 */
public class JunCalendarTimeIntervalViewAwt extends JunAbstractViewPanel implements JunCalendarTimeIntervalView {

	protected JunCalendarTimeViewAwt fromView;
	protected JunCalendarTimeViewAwt toView;

	/**
	 * Create a new instance of <code>JunCalendarTimeIntervalViewAwt</code> and initialize it.
	 * 
	 * @param aCalendarTimeIntervalModel JunCalendarTimeIntervalModel
	 * @category Instance creation
	 */
	public JunCalendarTimeIntervalViewAwt(JunCalendarTimeIntervalModel aCalendarTimeIntervalModel) {
		super(aCalendarTimeIntervalModel);
	}

	/**
	 * Answer a fromView.
	 *
	 * @return JunCalendarTimeViewAwt
	 * @category accessing
	 */
	public JunCalendarTimeViewAwt fromView() {
		if (fromView == null) {
			fromView = new JunCalendarTimeViewAwt(this.getModel().fromCalendarTimeModel());
		}
		return fromView;
	}

	/**
	 * Answer a toView.
	 *
	 * @return JunCalendarTimeViewAwt
	 * @category accessing
	 */
	public JunCalendarTimeViewAwt toView() {
		if (toView == null) {
			toView = new JunCalendarTimeViewAwt(this.getModel().toCalendarTimeModel());
		}
		return toView;
	}

	/**
	 * Get model.
	 *
	 * @return JunCalendarTimeModel
	 * @category accessing
	 */
	public JunCalendarTimeIntervalModel getModel() {
		return (JunCalendarTimeIntervalModel) this.model();
	}

	/**
	 * Build this component.
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.fromView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 0.5f, -1));
		this.add(this.toView(), WindowSpecLayout.Position(0f, 1, 0.5f, 1, 1f, -1, 1f, -1));
		this.setSize(150, 400);
	}

}
