package jp.co.sra.jun.goodies.calendar;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCalendarDateModelTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateModelTestExamples.java,v 8.11 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateModelTestExamples extends JunTestExamples {
	/**
	 * Example1: Open calendar.
	 *
	 * @return boolean
	 */
	public static boolean Example1() {
		JunCalendarDateModel calendarDateModel = new JunCalendarDateModel();
		calendarDateModel.open();
		return true;
	}

	/**
	 * Example2: Open calendar and print calendar.
	 *
	 * @return boolean
	 */
	public static boolean Example2() {
		JunCalendarDateModel calendarDateModel = new JunCalendarDateModel();
		System.out.println(calendarDateModel.printCalendarString());
		calendarDateModel.open();
		return true;
	}

	/**
	 * Example3: Set calendar 1999.10.22 and open calendar.
	 *
	 * @return boolean
	 */
	public static boolean Example3() {
		JunCalendarDateModel calendarDateModel = JunCalendarDateModel.Year_month_day_(1999, 10, 22);
		calendarDateModel.open();
		return true;
	}

	/**
	 * Example4: Set calendar 1999.11.22 and open calendar.
	 *
	 * @return boolean
	 */
	public static boolean Example4() {
		JunCalendarDateModel calendarDateModel = JunCalendarDateModel.Year_month_day_(1999, 11, 22);
		calendarDateModel.open();
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args an array of command-line argumetns
	 */
	public static void main(String args[]) {
		new JunCalendarDateModelTestExamples();
	}
}
